/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.gestures.snapping;

import androidx.compose.animation.SplineBasedDecayKt;
import androidx.compose.animation.core.DecayAnimationSpec;
import androidx.compose.animation.core.DecayAnimationSpecKt;
import androidx.compose.foundation.ExperimentalFoundationApi;
import androidx.compose.foundation.gestures.FlingBehavior;
import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.snapping.SnapFlingBehavior;
import androidx.compose.foundation.gestures.snapping.SnapFlingBehaviorKt;
import androidx.compose.foundation.gestures.snapping.SnapLayoutInfoProvider;
import androidx.compose.foundation.gestures.snapping.SnapPositionInLayout;
import androidx.compose.foundation.gestures.snapping.SnapPositionInLayoutKt;
import androidx.compose.foundation.lazy.LazyListItemInfo;
import androidx.compose.foundation.lazy.LazyListLayoutInfo;
import androidx.compose.foundation.lazy.LazyListState;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.IntSize;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u001a\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a2\u0006\u0002\u0010\r\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000e"}, d2={"singleAxisViewportSize", "", "Landroidx/compose/foundation/lazy/LazyListLayoutInfo;", "getSingleAxisViewportSize", "(Landroidx/compose/foundation/lazy/LazyListLayoutInfo;)I", "SnapLayoutInfoProvider", "Landroidx/compose/foundation/gestures/snapping/SnapLayoutInfoProvider;", "lazyListState", "Landroidx/compose/foundation/lazy/LazyListState;", "positionInLayout", "Landroidx/compose/foundation/gestures/snapping/SnapPositionInLayout;", "rememberSnapFlingBehavior", "Landroidx/compose/foundation/gestures/FlingBehavior;", "(Landroidx/compose/foundation/lazy/LazyListState;Landroidx/compose/runtime/Composer;I)Landroidx/compose/foundation/gestures/FlingBehavior;", "foundation_release"})
@SourceDebugExtension(value={"SMAP\nLazyListSnapLayoutInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyListSnapLayoutInfoProvider.kt\nandroidx/compose/foundation/gestures/snapping/LazyListSnapLayoutInfoProviderKt\n+ 2 Composables.kt\nandroidx/compose/runtime/ComposablesKt\n+ 3 Composer.kt\nandroidx/compose/runtime/ComposerKt\n*L\n1#1,128:1\n36#2:129\n1115#3,6:130\n*S KotlinDebug\n*F\n+ 1 LazyListSnapLayoutInfoProvider.kt\nandroidx/compose/foundation/gestures/snapping/LazyListSnapLayoutInfoProviderKt\n*L\n122#1:129\n122#1:130,6\n*E\n"})
public final class LazyListSnapLayoutInfoProviderKt {
    @ExperimentalFoundationApi
    @NotNull
    public static final SnapLayoutInfoProvider SnapLayoutInfoProvider(@NotNull LazyListState lazyListState, @NotNull SnapPositionInLayout positionInLayout) {
        return new SnapLayoutInfoProvider(lazyListState, positionInLayout){
            final /* synthetic */ LazyListState $lazyListState;
            final /* synthetic */ SnapPositionInLayout $positionInLayout;
            {
                this.$lazyListState = $lazyListState;
                this.$positionInLayout = $positionInLayout;
            }

            private final LazyListLayoutInfo getLayoutInfo() {
                return this.$lazyListState.getLayoutInfo();
            }

            public float calculateApproachOffset(float initialVelocity) {
                DecayAnimationSpec decayAnimationSpec = SplineBasedDecayKt.splineBasedDecay((Density)this.$lazyListState.getDensity$foundation_release());
                float offset = Math.abs(DecayAnimationSpecKt.calculateTargetValue((DecayAnimationSpec)decayAnimationSpec, (float)0.0f, (float)initialVelocity));
                float estimatedNumberOfItemsInDecay = (float)Math.floor(Math.abs(offset) / this.averageItemSize());
                float approachOffset = estimatedNumberOfItemsInDecay * this.averageItemSize() - this.averageItemSize();
                float finalDecayOffset = RangesKt.coerceAtLeast((float)approachOffset, (float)0.0f);
                return finalDecayOffset == 0.0f ? finalDecayOffset : finalDecayOffset * Math.signum(initialVelocity);
            }

            /*
             * WARNING - void declaration
             */
            public float calculateSnappingOffset(float currentVelocity) {
                void $this$fastForEach$iv;
                float lowerBoundOffset = 0.0f;
                lowerBoundOffset = Float.NEGATIVE_INFINITY;
                float upperBoundOffset = 0.0f;
                upperBoundOffset = Float.POSITIVE_INFINITY;
                List<LazyListItemInfo> list = this.getLayoutInfo().getVisibleItemsInfo();
                SnapPositionInLayout snapPositionInLayout = this.$positionInLayout;
                boolean $i$f$fastForEach = false;
                int n = $this$fastForEach$iv.size();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    E item$iv = $this$fastForEach$iv.get(index$iv);
                    LazyListItemInfo item2 = (LazyListItemInfo)item$iv;
                    boolean bl = false;
                    float offset = SnapPositionInLayoutKt.calculateDistanceToDesiredSnapPosition(LazyListSnapLayoutInfoProviderKt.getSingleAxisViewportSize(this.getLayoutInfo()), this.getLayoutInfo().getBeforeContentPadding(), this.getLayoutInfo().getAfterContentPadding(), item2.getSize(), item2.getOffset(), item2.getIndex(), snapPositionInLayout);
                    if (offset <= 0.0f && offset > lowerBoundOffset) {
                        lowerBoundOffset = offset;
                    }
                    if (!(offset >= 0.0f) || !(offset < upperBoundOffset)) continue;
                    upperBoundOffset = offset;
                }
                return SnapFlingBehaviorKt.calculateFinalOffset(currentVelocity, lowerBoundOffset, upperBoundOffset);
            }

            /*
             * WARNING - void declaration
             */
            public final float averageItemSize() {
                float f;
                LazyListLayoutInfo $this$averageItemSize_u24lambda_u242 = this.getLayoutInfo();
                boolean bl = false;
                if (!((Collection)$this$averageItemSize_u24lambda_u242.getVisibleItemsInfo()).isEmpty()) {
                    List<LazyListItemInfo> $this$fastSumBy$iv = $this$averageItemSize_u24lambda_u242.getVisibleItemsInfo();
                    boolean $i$f$fastSumBy = false;
                    int sum$iv = 0;
                    List<LazyListItemInfo> $this$fastForEach$iv$iv = $this$fastSumBy$iv;
                    boolean $i$f$fastForEach = false;
                    int n = $this$fastForEach$iv$iv.size();
                    for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                        void it;
                        LazyListItemInfo item$iv$iv;
                        LazyListItemInfo element$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                        boolean bl2 = false;
                        LazyListItemInfo lazyListItemInfo = element$iv;
                        int n2 = sum$iv;
                        boolean bl3 = false;
                        int n3 = it.getSize();
                        sum$iv = n2 + n3;
                    }
                    f = (float)sum$iv / (float)$this$averageItemSize_u24lambda_u242.getVisibleItemsInfo().size();
                } else {
                    f = 0.0f;
                }
                return f;
            }
        };
    }

    public static /* synthetic */ SnapLayoutInfoProvider SnapLayoutInfoProvider$default(LazyListState lazyListState, SnapPositionInLayout snapPositionInLayout, int n, Object object) {
        if ((n & 2) != 0) {
            snapPositionInLayout = SnapPositionInLayout.Companion.getCenterToCenter();
        }
        return LazyListSnapLayoutInfoProviderKt.SnapLayoutInfoProvider(lazyListState, snapPositionInLayout);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalFoundationApi
    @Composable
    @NotNull
    public static final FlingBehavior rememberSnapFlingBehavior(@NotNull LazyListState lazyListState, @Nullable Composer $composer, int $changed) {
        Object object;
        void $this$cache$iv$iv;
        $composer.startReplaceableGroup(1148456277);
        ComposerKt.sourceInformation((Composer)$composer, (String)"C(rememberSnapFlingBehavior)121@4928L65,122@5005L41:LazyListSnapLayoutInfoProvider.kt#ppz6w6");
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)1148456277, (int)$changed, (int)-1, (String)"androidx.compose.foundation.gestures.snapping.rememberSnapFlingBehavior (LazyListSnapLayoutInfoProvider.kt:120)");
        }
        int n = 0xE & $changed;
        boolean $i$f$remember = false;
        $composer.startReplaceableGroup(1157296644);
        ComposerKt.sourceInformation((Composer)$composer, (String)"CC(remember)P(1):Composables.kt#9igjgp");
        Composer composer = $composer;
        boolean invalid$iv$iv = $composer.changed((Object)lazyListState);
        boolean $i$f$cache = false;
        Object it$iv$iv = $this$cache$iv$iv.rememberedValue();
        boolean bl = false;
        if (invalid$iv$iv || it$iv$iv == Composer.Companion.getEmpty()) {
            boolean bl2 = false;
            SnapLayoutInfoProvider value$iv$iv = LazyListSnapLayoutInfoProviderKt.SnapLayoutInfoProvider$default(lazyListState, null, 2, null);
            $this$cache$iv$iv.updateRememberedValue((Object)value$iv$iv);
            object = value$iv$iv;
        } else {
            object = it$iv$iv;
        }
        Object object2 = object;
        $composer.endReplaceableGroup();
        SnapLayoutInfoProvider snappingLayout = (SnapLayoutInfoProvider)object2;
        SnapFlingBehavior snapFlingBehavior = SnapFlingBehaviorKt.rememberSnapFlingBehavior(snappingLayout, $composer, 0);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        $composer.endReplaceableGroup();
        return snapFlingBehavior;
    }

    public static final int getSingleAxisViewportSize(@NotNull LazyListLayoutInfo $this$singleAxisViewportSize) {
        return $this$singleAxisViewportSize.getOrientation() == Orientation.Vertical ? IntSize.getHeight-impl((long)$this$singleAxisViewportSize.getViewportSize-YbymL2g()) : IntSize.getWidth-impl((long)$this$singleAxisViewportSize.getViewportSize-YbymL2g());
    }
}

