/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lint;

import androidx.compose.foundation.lint.FoundationNames;
import androidx.compose.lint.PsiUtilsKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Landroidx/compose/foundation/lint/BoxWithConstraintsDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "foundation-lint"})
@SourceDebugExtension(value={"SMAP\nBoxWithConstraintsDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoxWithConstraintsDetector.kt\nandroidx/compose/foundation/lint/BoxWithConstraintsDetector\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n526#2:149\n511#2,6:150\n800#3,11:156\n*S KotlinDebug\n*F\n+ 1 BoxWithConstraintsDetector.kt\nandroidx/compose/foundation/lint/BoxWithConstraintsDetector\n*L\n50#1:149\n50#1:150,6\n54#1:156,11\n*E\n"})
public final class BoxWithConstraintsDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue UnusedConstraintsParameter = Issue.Companion.create("UnusedBoxWithConstraintsScope", "BoxWithConstraints content should use the constraints provided via BoxWithConstraintsScope", "The `content` lambda in BoxWithConstraints has a scope which will include the incoming constraints. If this scope is ignored, then the cost of subcomposition is being wasted and this BoxWithConstraints should be replaced with a Box.", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(BoxWithConstraintsDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)FoundationNames.Layout.INSTANCE.getBoxWithConstraints().getShortName());
    }

    /*
     * WARNING - void declaration
     */
    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        if (PsiUtilsKt.isInPackageName(method, FoundationNames.Layout.INSTANCE.getPackageName())) {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Map map = Lint.computeKotlinArgumentMapping((UCallExpression)node, (PsiMethod)method);
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            Map map2 = map;
            boolean $i$f$filter = false;
            void var8_6 = $this$filter$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry entry = element$iv$iv = iterator.next();
                boolean bl = false;
                PsiParameter parameter = (PsiParameter)entry.getValue();
                if (!Intrinsics.areEqual((Object)parameter.getName(), (Object)"content")) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv.keySet();
            boolean $i$f$filterIsInstance = false;
            $this$filterTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Map.Entry element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ULambdaExpression)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            ULambdaExpression uLambdaExpression = (ULambdaExpression)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (uLambdaExpression == null) {
                return;
            }
            ULambdaExpression contentArgument = uLambdaExpression;
            Ref.BooleanRef foundValidReference = new Ref.BooleanRef();
            contentArgument.accept((UastVisitor)new AbstractUastVisitor(foundValidReference){
                final /* synthetic */ Ref.BooleanRef $foundValidReference;
                {
                    this.$foundValidReference = $foundValidReference;
                }

                public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                    PsiElement psiElement = UastUtils.tryResolve((UElement)((UElement)node));
                    PsiMethod psiMethod = psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null;
                    if (psiMethod == null) {
                        return this.$foundValidReference.element;
                    }
                    PsiMethod reference = psiMethod;
                    if (PsiUtilsKt.isInPackageName(reference, FoundationNames.Layout.INSTANCE.getPackageName())) {
                        PsiClass psiClass = reference.getContainingClass();
                        if (Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getName() : null), (Object)FoundationNames.Layout.INSTANCE.getBoxWithConstraintsScope().getShortName())) {
                            this.$foundValidReference.element = true;
                        }
                    }
                    PsiType psiType = (PsiType)ArraysKt.firstOrNull((Object[])reference.getHierarchicalMethodSignature().getParameterTypes());
                    boolean bl = psiType != null ? PsiUtilsKt.inheritsFrom(psiType, FoundationNames.Layout.INSTANCE.getBoxWithConstraintsScope()) : false;
                    if (bl) {
                        this.$foundValidReference.element = true;
                    }
                    return this.$foundValidReference.element;
                }

                public boolean visitThisExpression(@NotNull UThisExpression node) {
                    this.$foundValidReference.element = true;
                    return this.$foundValidReference.element;
                }

                public boolean visitCallExpression(@NotNull UCallExpression node) {
                    PsiType resolvedWildcardType;
                    PsiType psiType;
                    Object[] objectArray;
                    PsiJavaCodeReferenceElement psiJavaCodeReferenceElement;
                    PsiClassReferenceType psiClassReferenceType;
                    PsiType psiType2 = node.getReceiverType();
                    if (psiType2 == null) {
                        return this.$foundValidReference.element;
                    }
                    PsiType receiverType = psiType2;
                    if (PsiUtilsKt.inheritsFrom(receiverType, FoundationNames.Layout.INSTANCE.getBoxWithConstraintsScope())) {
                        this.$foundValidReference.element = true;
                        return this.$foundValidReference.element;
                    }
                    PsiClassReferenceType psiClassReferenceType2 = psiClassReferenceType = receiverType instanceof PsiClassReferenceType ? (PsiClassReferenceType)receiverType : null;
                    if (psiClassReferenceType == null || (psiJavaCodeReferenceElement = psiClassReferenceType.getReference()) == null || (objectArray = psiJavaCodeReferenceElement.getTypeParameters()) == null || (psiType = (PsiType)ArraysKt.firstOrNull((Object[])objectArray)) == null) {
                        return this.$foundValidReference.element;
                    }
                    PsiType firstChildReceiverType = psiType;
                    PsiWildcardType psiWildcardType = firstChildReceiverType instanceof PsiWildcardType ? (PsiWildcardType)firstChildReceiverType : null;
                    PsiType psiType3 = resolvedWildcardType = psiWildcardType != null ? psiWildcardType.getBound() : null;
                    boolean bl = psiType3 != null ? PsiUtilsKt.inheritsFrom(psiType3, FoundationNames.Layout.INSTANCE.getBoxWithConstraintsScope()) : false;
                    if (bl) {
                        this.$foundValidReference.element = true;
                    }
                    return this.$foundValidReference.element;
                }
            });
            if (!foundValidReference.element) {
                JavaContext.report$default((JavaContext)context, (Issue)UnusedConstraintsParameter, (UElement)((UElement)node), (Location)context.getLocation((UElement)contentArgument), (String)"BoxWithConstraints scope is not used", null, (int)16, null);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/compose/foundation/lint/BoxWithConstraintsDetector$Companion;", "", "()V", "UnusedConstraintsParameter", "Lcom/android/tools/lint/detector/api/Issue;", "getUnusedConstraintsParameter", "()Lcom/android/tools/lint/detector/api/Issue;", "foundation-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getUnusedConstraintsParameter() {
            return UnusedConstraintsParameter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

