/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal;

import android.graphics.Matrix;
import android.os.Build;
import android.view.inputmethod.CursorAnchorInfo;
import androidx.compose.foundation.text.input.internal.CursorAnchorInfoApi33Helper;
import androidx.compose.foundation.text.input.internal.CursorAnchorInfoApi34Helper;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.OffsetMapping;
import androidx.compose.ui.text.input.TextFieldValue;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.unit.IntSize;
import kotlin.Metadata;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0004\u001a4\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001ad\u0010\u000b\u001a\u00020\f*\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00132\b\b\u0002\u0010\u0015\u001a\u00020\u00132\b\b\u0002\u0010\u0016\u001a\u00020\u0013H\u0000\u001a\u001c\u0010\u0017\u001a\u00020\u0013*\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u001a,\u0010\u001b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u001d"}, d2={"addCharacterBounds", "Landroid/view/inputmethod/CursorAnchorInfo$Builder;", "startOffset", "", "endOffset", "offsetMapping", "Landroidx/compose/ui/text/input/OffsetMapping;", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "innerTextFieldBounds", "Landroidx/compose/ui/geometry/Rect;", "build", "Landroid/view/inputmethod/CursorAnchorInfo;", "textFieldValue", "Landroidx/compose/ui/text/input/TextFieldValue;", "matrix", "Landroid/graphics/Matrix;", "decorationBoxBounds", "includeInsertionMarker", "", "includeCharacterBounds", "includeEditorBounds", "includeLineBounds", "containsInclusive", "x", "", "y", "setInsertionMarker", "selectionStart", "foundation_release"})
public final class CursorAnchorInfoBuilder_androidKt {
    @NotNull
    public static final CursorAnchorInfo build(@NotNull CursorAnchorInfo.Builder $this$build, @NotNull TextFieldValue textFieldValue, @NotNull OffsetMapping offsetMapping, @NotNull TextLayoutResult textLayoutResult, @NotNull Matrix matrix, @NotNull Rect innerTextFieldBounds, @NotNull Rect decorationBoxBounds, boolean includeInsertionMarker, boolean includeCharacterBounds, boolean includeEditorBounds, boolean includeLineBounds) {
        $this$build.reset();
        $this$build.setMatrix(matrix);
        int selectionStart = TextRange.getMin-impl((long)textFieldValue.getSelection-d9O1mEE());
        int selectionEnd = TextRange.getMax-impl((long)textFieldValue.getSelection-d9O1mEE());
        $this$build.setSelectionRange(selectionStart, selectionEnd);
        if (includeInsertionMarker) {
            CursorAnchorInfoBuilder_androidKt.setInsertionMarker($this$build, selectionStart, offsetMapping, textLayoutResult, innerTextFieldBounds);
        }
        if (includeCharacterBounds) {
            int compositionEnd;
            TextRange textRange2 = textFieldValue.getComposition-MzsxiRA();
            int compositionStart = textRange2 != null ? TextRange.getMin-impl((long)textRange2.unbox-impl()) : -1;
            TextRange textRange3 = textFieldValue.getComposition-MzsxiRA();
            int n = compositionEnd = textRange3 != null ? TextRange.getMax-impl((long)textRange3.unbox-impl()) : -1;
            boolean bl = 0 <= compositionStart ? compositionStart < compositionEnd : false;
            if (bl) {
                $this$build.setComposingText(compositionStart, textFieldValue.getText().subSequence(compositionStart, compositionEnd));
                CursorAnchorInfoBuilder_androidKt.addCharacterBounds($this$build, compositionStart, compositionEnd, offsetMapping, textLayoutResult, innerTextFieldBounds);
            }
        }
        if (Build.VERSION.SDK_INT >= 33 && includeEditorBounds) {
            CursorAnchorInfoApi33Helper.setEditorBoundsInfo($this$build, decorationBoxBounds);
        }
        if (Build.VERSION.SDK_INT >= 34 && includeLineBounds) {
            CursorAnchorInfoApi34Helper.addVisibleLineBounds($this$build, textLayoutResult, innerTextFieldBounds);
        }
        return $this$build.build();
    }

    public static /* synthetic */ CursorAnchorInfo build$default(CursorAnchorInfo.Builder builder, TextFieldValue textFieldValue, OffsetMapping offsetMapping, TextLayoutResult textLayoutResult, Matrix matrix, Rect rect, Rect rect2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl = true;
        }
        if ((n & 0x80) != 0) {
            bl2 = true;
        }
        if ((n & 0x100) != 0) {
            bl3 = true;
        }
        if ((n & 0x200) != 0) {
            bl4 = true;
        }
        return CursorAnchorInfoBuilder_androidKt.build(builder, textFieldValue, offsetMapping, textLayoutResult, matrix, rect, rect2, bl, bl2, bl3, bl4);
    }

    private static final CursorAnchorInfo.Builder setInsertionMarker(CursorAnchorInfo.Builder $this$setInsertionMarker, int selectionStart, OffsetMapping offsetMapping, TextLayoutResult textLayoutResult, Rect innerTextFieldBounds) {
        if (selectionStart < 0) {
            return $this$setInsertionMarker;
        }
        int selectionStartTransformed = offsetMapping.originalToTransformed(selectionStart);
        Rect cursorRect2 = textLayoutResult.getCursorRect(selectionStartTransformed);
        float x = RangesKt.coerceIn((float)cursorRect2.getLeft(), (float)0.0f, (float)IntSize.getWidth-impl((long)textLayoutResult.getSize-YbymL2g()));
        boolean isTopVisible = CursorAnchorInfoBuilder_androidKt.containsInclusive(innerTextFieldBounds, x, cursorRect2.getTop());
        boolean isBottomVisible = CursorAnchorInfoBuilder_androidKt.containsInclusive(innerTextFieldBounds, x, cursorRect2.getBottom());
        boolean isRtl = textLayoutResult.getBidiRunDirection(selectionStartTransformed) == ResolvedTextDirection.Rtl;
        int flags = 0;
        if (isTopVisible || isBottomVisible) {
            flags |= 1;
        }
        if (!isTopVisible || !isBottomVisible) {
            flags |= 2;
        }
        if (isRtl) {
            flags |= 4;
        }
        $this$setInsertionMarker.setInsertionMarkerLocation(x, cursorRect2.getTop(), cursorRect2.getBottom(), cursorRect2.getBottom(), flags);
        return $this$setInsertionMarker;
    }

    private static final CursorAnchorInfo.Builder addCharacterBounds(CursorAnchorInfo.Builder $this$addCharacterBounds, int startOffset, int endOffset, OffsetMapping offsetMapping, TextLayoutResult textLayoutResult, Rect innerTextFieldBounds) {
        int startOffsetTransformed = offsetMapping.originalToTransformed(startOffset);
        int endOffsetTransformed = offsetMapping.originalToTransformed(endOffset);
        float[] array = new float[(endOffsetTransformed - startOffsetTransformed) * 4];
        textLayoutResult.getMultiParagraph().fillBoundingBoxes-8ffj60Q(TextRangeKt.TextRange((int)startOffsetTransformed, (int)endOffsetTransformed), array, 0);
        for (int offset = startOffset; offset < endOffset; ++offset) {
            int offsetTransformed = offsetMapping.originalToTransformed(offset);
            int arrayIndex = 4 * (offsetTransformed - startOffsetTransformed);
            Rect rect = new Rect(array[arrayIndex], array[arrayIndex + 1], array[arrayIndex + 2], array[arrayIndex + 3]);
            int flags = 0;
            if (innerTextFieldBounds.overlaps(rect)) {
                flags |= 1;
            }
            if (!CursorAnchorInfoBuilder_androidKt.containsInclusive(innerTextFieldBounds, rect.getLeft(), rect.getTop()) || !CursorAnchorInfoBuilder_androidKt.containsInclusive(innerTextFieldBounds, rect.getRight(), rect.getBottom())) {
                flags |= 2;
            }
            if (textLayoutResult.getBidiRunDirection(offsetTransformed) == ResolvedTextDirection.Rtl) {
                flags |= 4;
            }
            $this$addCharacterBounds.addCharacterBounds(offset, rect.getLeft(), rect.getTop(), rect.getRight(), rect.getBottom(), flags);
        }
        return $this$addCharacterBounds;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean containsInclusive(Rect $this$containsInclusive, float x, float y) {
        float f = $this$containsInclusive.getLeft();
        if (!(x <= $this$containsInclusive.getRight())) return false;
        if (!(f <= x)) return false;
        boolean bl = true;
        if (!bl) return false;
        f = $this$containsInclusive.getTop();
        if (!(y <= $this$containsInclusive.getBottom())) return false;
        if (!(f <= y)) return false;
        return true;
    }
}

