/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text2.input;

import androidx.annotation.VisibleForTesting;
import androidx.compose.foundation.ExperimentalFoundationApi;
import androidx.compose.foundation.text2.input.InputTransformation;
import androidx.compose.foundation.text2.input.TextFieldBuffer;
import androidx.compose.foundation.text2.input.TextFieldCharSequence;
import androidx.compose.foundation.text2.input.TextFieldCharSequenceKt;
import androidx.compose.foundation.text2.input.TextUndoManager;
import androidx.compose.foundation.text2.input.TextUndoManagerKt;
import androidx.compose.foundation.text2.input.UndoState;
import androidx.compose.foundation.text2.input.internal.ChangeTracker;
import androidx.compose.foundation.text2.input.internal.EditingBuffer;
import androidx.compose.foundation.text2.input.internal.undo.TextFieldEditUndoBehavior;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.State;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.saveable.SaverScope;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001:\u0002JKB\u001b\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0015\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b)J\u0010\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020,H\u0001J*\u0010-\u001a\u00020'2\u0006\u0010.\u001a\u00020\u00162\b\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J\"\u00105\u001a\u00020'2\u0017\u00106\u001a\u0013\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020'07\u00a2\u0006\u0002\b8H\u0086\bJE\u00109\u001a\u00020'2\b\u0010/\u001a\u0004\u0018\u0001002\b\b\u0002\u00101\u001a\u0002022\b\b\u0002\u00103\u001a\u0002042\u0017\u00106\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020'07\u00a2\u0006\u0002\b8H\u0080\b\u00a2\u0006\u0002\b:J'\u0010;\u001a\u00020'2\u0017\u00106\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020'07\u00a2\u0006\u0002\b8H\u0080\b\u00a2\u0006\u0002\b<J\u0018\u0010=\u001a\u00020'2\u0006\u0010>\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u0016H\u0002J(\u0010?\u001a\u00020'2\u0006\u0010.\u001a\u00020\u00162\u0006\u0010@\u001a\u00020\u00162\u0006\u0010A\u001a\u00020B2\u0006\u00103\u001a\u000204H\u0002J\u0015\u0010C\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\bDJ\u0015\u0010E\u001a\u00020'2\u0006\u0010+\u001a\u00020\u0016H\u0001\u00a2\u0006\u0002\bFJ\u0010\u0010G\u001a\u00020,2\u0006\u0010H\u001a\u00020\u0016H\u0001J\b\u0010I\u001a\u00020\u0003H\u0016R$\u0010\n\u001a\u00020\u000b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00168F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001e\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u00020\"8GX\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b#\u0010\r\u001a\u0004\b$\u0010%\u00a8\u0006L"}, d2={"Landroidx/compose/foundation/text2/input/TextFieldState;", "", "initialText", "", "initialSelectionInChars", "Landroidx/compose/ui/text/TextRange;", "(Ljava/lang/String;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "initialTextUndoManager", "Landroidx/compose/foundation/text2/input/TextUndoManager;", "(Ljava/lang/String;JLandroidx/compose/foundation/text2/input/TextUndoManager;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "mainBuffer", "Landroidx/compose/foundation/text2/input/internal/EditingBuffer;", "getMainBuffer$foundation_release$annotations", "()V", "getMainBuffer$foundation_release", "()Landroidx/compose/foundation/text2/input/internal/EditingBuffer;", "setMainBuffer$foundation_release", "(Landroidx/compose/foundation/text2/input/internal/EditingBuffer;)V", "notifyImeListeners", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/foundation/text2/input/TextFieldState$NotifyImeListener;", "<set-?>", "Landroidx/compose/foundation/text2/input/TextFieldCharSequence;", "text", "getText", "()Landroidx/compose/foundation/text2/input/TextFieldCharSequence;", "setText", "(Landroidx/compose/foundation/text2/input/TextFieldCharSequence;)V", "text$delegate", "Landroidx/compose/runtime/MutableState;", "textUndoManager", "getTextUndoManager$foundation_release", "()Landroidx/compose/foundation/text2/input/TextUndoManager;", "undoState", "Landroidx/compose/foundation/text2/input/UndoState;", "getUndoState$annotations", "getUndoState", "()Landroidx/compose/foundation/text2/input/UndoState;", "addNotifyImeListener", "", "notifyImeListener", "addNotifyImeListener$foundation_release", "commitEdit", "newValue", "Landroidx/compose/foundation/text2/input/TextFieldBuffer;", "commitEditAsUser", "previousValue", "inputTransformation", "Landroidx/compose/foundation/text2/input/InputTransformation;", "notifyImeOfChanges", "", "undoBehavior", "Landroidx/compose/foundation/text2/input/internal/undo/TextFieldEditUndoBehavior;", "edit", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "editAsUser", "editAsUser$foundation_release", "editWithNoSideEffects", "editWithNoSideEffects$foundation_release", "notifyIme", "oldValue", "recordEditForUndo", "postValue", "changes", "Landroidx/compose/foundation/text2/input/TextFieldBuffer$ChangeList;", "removeNotifyImeListener", "removeNotifyImeListener$foundation_release", "resetStateAndNotifyIme", "resetStateAndNotifyIme$foundation_release", "startEdit", "value", "toString", "NotifyImeListener", "Saver", "foundation_release"})
@ExperimentalFoundationApi
@Stable
@SourceDebugExtension(value={"SMAP\nTextFieldState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextFieldState.kt\nandroidx/compose/foundation/text2/input/TextFieldState\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 4 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n*L\n1#1,569:1\n1208#2:570\n1187#2,2:571\n81#3:573\n107#3,2:574\n460#4,11:576\n*S KotlinDebug\n*F\n+ 1 TextFieldState.kt\nandroidx/compose/foundation/text2/input/TextFieldState\n*L\n406#1:570\n406#1:571,2\n107#1:573\n107#1:574,2\n412#1:576,11\n*E\n"})
public final class TextFieldState {
    @NotNull
    private final TextUndoManager textUndoManager;
    @NotNull
    private EditingBuffer mainBuffer;
    @NotNull
    private final MutableState text$delegate;
    @NotNull
    private final UndoState undoState;
    @NotNull
    private final MutableVector<NotifyImeListener> notifyImeListeners;
    public static final int $stable;

    private TextFieldState(String initialText, long initialSelectionInChars, TextUndoManager initialTextUndoManager) {
        this.textUndoManager = initialTextUndoManager;
        this.mainBuffer = new EditingBuffer(initialText, TextRangeKt.coerceIn-8ffj60Q((long)initialSelectionInChars, (int)0, (int)initialText.length()), null);
        this.text$delegate = SnapshotStateKt.mutableStateOf$default((Object)TextFieldCharSequenceKt.TextFieldCharSequence-FDrldGo(initialText, initialSelectionInChars), null, (int)2, null);
        this.undoState = new UndoState(this);
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.notifyImeListeners = new MutableVector((Object[])new NotifyImeListener[capacity$iv$iv], 0);
    }

    private TextFieldState(String initialText, long initialSelectionInChars) {
        this(initialText, initialSelectionInChars, new TextUndoManager(null, null, 3, null), null);
    }

    public /* synthetic */ TextFieldState(String string2, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string2 = "";
        }
        if ((n & 2) != 0) {
            l = TextRangeKt.TextRange((int)string2.length());
        }
        this(string2, l, (DefaultConstructorMarker)null);
    }

    @NotNull
    public final TextUndoManager getTextUndoManager$foundation_release() {
        return this.textUndoManager;
    }

    @NotNull
    public final EditingBuffer getMainBuffer$foundation_release() {
        return this.mainBuffer;
    }

    public final void setMainBuffer$foundation_release(@NotNull EditingBuffer editingBuffer) {
        this.mainBuffer = editingBuffer;
    }

    @VisibleForTesting
    public static /* synthetic */ void getMainBuffer$foundation_release$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TextFieldCharSequence getText() {
        void $this$getValue$iv;
        State state = (State)this.text$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (TextFieldCharSequence)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setText(TextFieldCharSequence textFieldCharSequence) {
        void $this$setValue$iv;
        MutableState mutableState = this.text$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)textFieldCharSequence);
    }

    public final void edit(@NotNull Function1<? super TextFieldBuffer, Unit> block) {
        boolean $i$f$edit = false;
        TextFieldBuffer mutableValue = this.startEdit(this.getText());
        block.invoke((Object)mutableValue);
        this.commitEdit(mutableValue);
    }

    @NotNull
    public String toString() {
        return "TextFieldState(selectionInChars=" + TextRange.toString-impl((long)this.getText().getSelectionInChars-d9O1mEE()) + ", text=\"" + this.getText() + "\")";
    }

    @ExperimentalFoundationApi
    @NotNull
    public final UndoState getUndoState() {
        return this.undoState;
    }

    @ExperimentalFoundationApi
    public static /* synthetic */ void getUndoState$annotations() {
    }

    @PublishedApi
    @NotNull
    public final TextFieldBuffer startEdit(@NotNull TextFieldCharSequence value) {
        return new TextFieldBuffer(value, null, null, null, 14, null);
    }

    @PublishedApi
    public final void commitEdit(@NotNull TextFieldBuffer newValue) {
        boolean selectionChanged;
        boolean textChanged = newValue.getChanges().getChangeCount() > 0;
        boolean bl = selectionChanged = !TextRange.equals-impl0((long)newValue.getSelectionInChars-d9O1mEE(), (long)this.mainBuffer.getSelection-d9O1mEE());
        if (textChanged || selectionChanged) {
            TextFieldCharSequence finalValue = TextFieldBuffer.toTextFieldCharSequence-udt6zUU$foundation_release$default(newValue, 0L, null, 3, null);
            this.resetStateAndNotifyIme$foundation_release(finalValue);
        }
        this.textUndoManager.clearHistory();
    }

    public final void editAsUser$foundation_release(@Nullable InputTransformation inputTransformation, boolean notifyImeOfChanges, @NotNull TextFieldEditUndoBehavior undoBehavior, @NotNull Function1<? super EditingBuffer, Unit> block) {
        boolean $i$f$editAsUser$foundation_release = false;
        TextFieldCharSequence previousValue = this.getText();
        this.getMainBuffer$foundation_release().getChangeTracker().clearChanges();
        block.invoke((Object)this.getMainBuffer$foundation_release());
        if (this.getMainBuffer$foundation_release().getChangeTracker().getChangeCount() == 0 && TextRange.equals-impl0((long)previousValue.getSelectionInChars-d9O1mEE(), (long)this.getMainBuffer$foundation_release().getSelection-d9O1mEE()) && Intrinsics.areEqual((Object)previousValue.getCompositionInChars-MzsxiRA(), (Object)this.getMainBuffer$foundation_release().getComposition-MzsxiRA())) {
            return;
        }
        this.commitEditAsUser(previousValue, inputTransformation, notifyImeOfChanges, undoBehavior);
    }

    public static /* synthetic */ void editAsUser$foundation_release$default(TextFieldState $this, InputTransformation inputTransformation, boolean notifyImeOfChanges, TextFieldEditUndoBehavior undoBehavior, Function1 block, int n, Object object) {
        if ((n & 2) != 0) {
            notifyImeOfChanges = true;
        }
        if ((n & 4) != 0) {
            undoBehavior = TextFieldEditUndoBehavior.MergeIfPossible;
        }
        boolean $i$f$editAsUser$foundation_release = false;
        TextFieldCharSequence previousValue = $this.getText();
        $this.getMainBuffer$foundation_release().getChangeTracker().clearChanges();
        block.invoke((Object)$this.getMainBuffer$foundation_release());
        if ($this.getMainBuffer$foundation_release().getChangeTracker().getChangeCount() == 0 && TextRange.equals-impl0((long)previousValue.getSelectionInChars-d9O1mEE(), (long)$this.getMainBuffer$foundation_release().getSelection-d9O1mEE()) && Intrinsics.areEqual((Object)previousValue.getCompositionInChars-MzsxiRA(), (Object)$this.getMainBuffer$foundation_release().getComposition-MzsxiRA())) {
            return;
        }
        $this.commitEditAsUser(previousValue, inputTransformation, notifyImeOfChanges, undoBehavior);
    }

    public final void editWithNoSideEffects$foundation_release(@NotNull Function1<? super EditingBuffer, Unit> block) {
        boolean $i$f$editWithNoSideEffects$foundation_release = false;
        TextFieldCharSequence previousValue = this.getText();
        this.getMainBuffer$foundation_release().getChangeTracker().clearChanges();
        block.invoke((Object)this.getMainBuffer$foundation_release());
        TextFieldCharSequence afterEditValue = TextFieldCharSequenceKt.TextFieldCharSequence-3r_uNRQ(this.getMainBuffer$foundation_release().toString(), this.getMainBuffer$foundation_release().getSelection-d9O1mEE(), this.getMainBuffer$foundation_release().getComposition-MzsxiRA());
        this.setText(afterEditValue);
        this.notifyIme(previousValue, afterEditValue);
    }

    private final void commitEditAsUser(TextFieldCharSequence previousValue, InputTransformation inputTransformation, boolean notifyImeOfChanges, TextFieldEditUndoBehavior undoBehavior) {
        TextFieldCharSequence afterEditValue = TextFieldCharSequenceKt.TextFieldCharSequence-3r_uNRQ(this.mainBuffer.toString(), this.mainBuffer.getSelection-d9O1mEE(), this.mainBuffer.getComposition-MzsxiRA());
        if (inputTransformation == null) {
            TextFieldCharSequence oldValue = this.getText();
            this.setText(afterEditValue);
            if (notifyImeOfChanges) {
                this.notifyIme(oldValue, afterEditValue);
            }
            this.recordEditForUndo(previousValue, this.getText(), this.mainBuffer.getChangeTracker(), undoBehavior);
            return;
        }
        TextFieldCharSequence oldValue = this.getText();
        if (afterEditValue.contentEquals(oldValue) && TextRange.equals-impl0((long)afterEditValue.getSelectionInChars-d9O1mEE(), (long)oldValue.getSelectionInChars-d9O1mEE())) {
            this.setText(afterEditValue);
            if (notifyImeOfChanges) {
                this.notifyIme(oldValue, afterEditValue);
            }
            return;
        }
        ChangeTracker changeTracker = this.mainBuffer.getChangeTracker();
        TextFieldBuffer mutableValue = new TextFieldBuffer(afterEditValue, changeTracker, oldValue, null, 8, null);
        inputTransformation.transformInput(oldValue, mutableValue);
        TextFieldCharSequence afterFilterValue = TextFieldBuffer.toTextFieldCharSequence-udt6zUU$foundation_release$default(mutableValue, 0L, afterEditValue.getCompositionInChars-MzsxiRA(), 1, null);
        if (Intrinsics.areEqual((Object)afterFilterValue, (Object)afterEditValue)) {
            this.setText(afterFilterValue);
            if (notifyImeOfChanges) {
                this.notifyIme(oldValue, afterEditValue);
            }
        } else {
            this.resetStateAndNotifyIme$foundation_release(afterFilterValue);
        }
        this.recordEditForUndo(previousValue, this.getText(), mutableValue.getChanges(), undoBehavior);
    }

    private final void recordEditForUndo(TextFieldCharSequence previousValue, TextFieldCharSequence postValue, TextFieldBuffer.ChangeList changes, TextFieldEditUndoBehavior undoBehavior) {
        switch (WhenMappings.$EnumSwitchMapping$0[undoBehavior.ordinal()]) {
            case 1: {
                this.textUndoManager.clearHistory();
                break;
            }
            case 2: {
                TextUndoManagerKt.recordChanges(this.textUndoManager, previousValue, postValue, changes, true);
                break;
            }
            case 3: {
                TextUndoManagerKt.recordChanges(this.textUndoManager, previousValue, postValue, changes, false);
            }
        }
    }

    public final void addNotifyImeListener$foundation_release(@NotNull NotifyImeListener notifyImeListener) {
        this.notifyImeListeners.add((Object)notifyImeListener);
    }

    public final void removeNotifyImeListener$foundation_release(@NotNull NotifyImeListener notifyImeListener) {
        this.notifyImeListeners.remove((Object)notifyImeListener);
    }

    @VisibleForTesting
    public final void resetStateAndNotifyIme$foundation_release(@NotNull TextFieldCharSequence newValue) {
        boolean compositionChanged;
        TextFieldCharSequence bufferState = TextFieldCharSequenceKt.TextFieldCharSequence-3r_uNRQ(this.mainBuffer.toString(), this.mainBuffer.getSelection-d9O1mEE(), this.mainBuffer.getComposition-MzsxiRA());
        boolean textChanged = false;
        boolean selectionChanged = false;
        boolean bl = compositionChanged = !Intrinsics.areEqual((Object)newValue.getCompositionInChars-MzsxiRA(), (Object)this.mainBuffer.getComposition-MzsxiRA());
        if (!bufferState.contentEquals(newValue)) {
            this.mainBuffer = new EditingBuffer(((Object)newValue).toString(), newValue.getSelectionInChars-d9O1mEE(), null);
            textChanged = true;
        } else if (!TextRange.equals-impl0((long)bufferState.getSelectionInChars-d9O1mEE(), (long)newValue.getSelectionInChars-d9O1mEE())) {
            this.mainBuffer.setSelection(TextRange.getStart-impl((long)newValue.getSelectionInChars-d9O1mEE()), TextRange.getEnd-impl((long)newValue.getSelectionInChars-d9O1mEE()));
            selectionChanged = true;
        }
        TextRange composition = newValue.getCompositionInChars-MzsxiRA();
        if (composition == null || TextRange.getCollapsed-impl((long)composition.unbox-impl())) {
            this.mainBuffer.commitComposition();
        } else {
            this.mainBuffer.setComposition(TextRange.getMin-impl((long)composition.unbox-impl()), TextRange.getMax-impl((long)composition.unbox-impl()));
        }
        if (textChanged || !selectionChanged && compositionChanged) {
            this.mainBuffer.commitComposition();
        }
        TextFieldCharSequence finalValue = TextFieldCharSequenceKt.TextFieldCharSequence-3r_uNRQ(textChanged ? newValue : bufferState, this.mainBuffer.getSelection-d9O1mEE(), this.mainBuffer.getComposition-MzsxiRA());
        this.setText(finalValue);
        this.notifyIme(bufferState, finalValue);
    }

    private final void notifyIme(TextFieldCharSequence oldValue, TextFieldCharSequence newValue) {
        MutableVector<NotifyImeListener> this_$iv = this.notifyImeListeners;
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                NotifyImeListener it = (NotifyImeListener)content$iv[i$iv];
                boolean bl = false;
                it.onChange(oldValue, newValue);
            } while (++i$iv < size$iv);
        }
    }

    public /* synthetic */ TextFieldState(String initialText, long initialSelectionInChars, TextUndoManager initialTextUndoManager, DefaultConstructorMarker $constructor_marker) {
        this(initialText, initialSelectionInChars, initialTextUndoManager);
    }

    public /* synthetic */ TextFieldState(String initialText, long initialSelectionInChars, DefaultConstructorMarker $constructor_marker) {
        this(initialText, initialSelectionInChars);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Landroidx/compose/foundation/text2/input/TextFieldState$NotifyImeListener;", "", "onChange", "", "oldValue", "Landroidx/compose/foundation/text2/input/TextFieldCharSequence;", "newValue", "foundation_release"})
    public static interface NotifyImeListener {
        public void onChange(@NotNull TextFieldCharSequence var1, @NotNull TextFieldCharSequence var2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0003H\u0016J\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0003*\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Landroidx/compose/foundation/text2/input/TextFieldState$Saver;", "Landroidx/compose/runtime/saveable/Saver;", "Landroidx/compose/foundation/text2/input/TextFieldState;", "", "()V", "restore", "value", "save", "Landroidx/compose/runtime/saveable/SaverScope;", "foundation_release"})
    @StabilityInferred(parameters=1)
    public static final class Saver
    implements androidx.compose.runtime.saveable.Saver<TextFieldState, Object> {
        @NotNull
        public static final Saver INSTANCE = new Saver();
        public static final int $stable;

        private Saver() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public Object save(@NotNull SaverScope $this$save, @NotNull TextFieldState value) {
            void $this$save_u24lambda_u240;
            Object object;
            Object[] objectArray = new Object[4];
            objectArray[0] = ((Object)value.getText()).toString();
            objectArray[1] = TextRange.getStart-impl((long)value.getText().getSelectionInChars-d9O1mEE());
            objectArray[2] = TextRange.getEnd-impl((long)value.getText().getSelectionInChars-d9O1mEE());
            TextUndoManager.Companion.Saver saver2 = TextUndoManager.Companion.Saver.INSTANCE;
            int n = 3;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            objectArray2[n] = object = $this$save_u24lambda_u240.save($this$save, value.getTextUndoManager$foundation_release());
            return CollectionsKt.listOf((Object[])objectArray);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public TextFieldState restore(@NotNull Object value) {
            void $this$restore_u24lambda_u241;
            TextUndoManager textUndoManager;
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
            List list = (List)value;
            Object text = list.get(0);
            Object selectionStart = list.get(1);
            Object selectionEnd = list.get(2);
            Object savedTextUndoManager = list.get(3);
            Intrinsics.checkNotNull(text, (String)"null cannot be cast to non-null type kotlin.String");
            String string2 = (String)text;
            Intrinsics.checkNotNull(selectionStart, (String)"null cannot be cast to non-null type kotlin.Int");
            int n = (Integer)selectionStart;
            Intrinsics.checkNotNull(selectionEnd, (String)"null cannot be cast to non-null type kotlin.Int");
            TextUndoManager.Companion.Saver saver2 = TextUndoManager.Companion.Saver.INSTANCE;
            long l = TextRangeKt.TextRange((int)n, (int)((Integer)selectionEnd));
            String string3 = string2;
            boolean bl = false;
            Object e = savedTextUndoManager;
            Intrinsics.checkNotNull(e);
            TextUndoManager textUndoManager2 = textUndoManager = $this$restore_u24lambda_u241.restore(e);
            Intrinsics.checkNotNull((Object)textUndoManager2);
            DefaultConstructorMarker defaultConstructorMarker = null;
            TextUndoManager textUndoManager3 = textUndoManager2;
            long l2 = l;
            String string4 = string3;
            return new TextFieldState(string4, l2, textUndoManager3, defaultConstructorMarker);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TextFieldEditUndoBehavior.values().length];
            try {
                nArray[TextFieldEditUndoBehavior.ClearHistory.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextFieldEditUndoBehavior.MergeIfPossible.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextFieldEditUndoBehavior.NeverMerge.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

