/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.content.internal;

import android.app.Activity;
import android.content.ClipData;
import android.content.Context;
import android.content.ContextWrapper;
import android.net.Uri;
import android.os.Build;
import android.view.DragEvent;
import android.view.View;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.ui.draganddrop.DragAndDropEvent;
import androidx.compose.ui.draganddrop.DragAndDrop_androidKt;
import androidx.compose.ui.node.CompositionLocalConsumerModifierNode;
import androidx.compose.ui.node.CompositionLocalConsumerModifierNodeKt;
import androidx.compose.ui.platform.AndroidCompositionLocals_androidKt;
import androidx.core.view.DragAndDropPermissionsCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002\u001a\u0014\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a8\u0006\f"}, d2={"tryGetActivity", "Landroid/app/Activity;", "view", "Landroid/view/View;", "containsContentUri", "", "Landroid/content/ClipData;", "dragAndDropRequestPermission", "", "Landroidx/compose/ui/node/CompositionLocalConsumerModifierNode;", "event", "Landroidx/compose/ui/draganddrop/DragAndDropEvent;", "foundation_release"})
public final class DragAndDropRequestPermission_androidKt {
    public static final void dragAndDropRequestPermission(@NotNull CompositionLocalConsumerModifierNode $this$dragAndDropRequestPermission, @NotNull DragAndDropEvent event) {
        if (Build.VERSION.SDK_INT < 24) {
            return;
        }
        if (!DragAndDropRequestPermission_androidKt.containsContentUri(DragAndDrop_androidKt.toAndroidDragEvent((DragAndDropEvent)event).getClipData())) {
            return;
        }
        if ($this$dragAndDropRequestPermission.getNode().isAttached()) {
            View view = (View)CompositionLocalConsumerModifierNodeKt.currentValueOf((CompositionLocalConsumerModifierNode)$this$dragAndDropRequestPermission, (CompositionLocal)((CompositionLocal)AndroidCompositionLocals_androidKt.getLocalView()));
            Activity activity = DragAndDropRequestPermission_androidKt.tryGetActivity(view);
            if (activity == null) {
                return;
            }
            Activity activity2 = activity;
            DragAndDropPermissionsCompat.request((Activity)activity2, (DragEvent)DragAndDrop_androidKt.toAndroidDragEvent((DragAndDropEvent)event));
        }
    }

    private static final boolean containsContentUri(ClipData $this$containsContentUri) {
        int n = $this$containsContentUri.getItemCount();
        for (int i = 0; i < n; ++i) {
            Uri uri = $this$containsContentUri.getItemAt(i).getUri();
            if (uri == null || !Intrinsics.areEqual((Object)uri.getScheme(), (Object)"content")) continue;
            return true;
        }
        return false;
    }

    private static final Activity tryGetActivity(View view) {
        Context context = view.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }
}

