/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input;

import androidx.compose.foundation.ExperimentalFoundationApi;
import androidx.compose.foundation.text.input.EmptyChangeList;
import androidx.compose.foundation.text.input.TextFieldCharSequence;
import androidx.compose.foundation.text.input.TextFieldCharSequenceKt;
import androidx.compose.foundation.text.input.internal.ChangeTracker;
import androidx.compose.foundation.text.input.internal.OffsetMappingCalculator;
import androidx.compose.foundation.text.input.internal.PartialGapBuffer;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\f\n\u0000\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0015\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u00002\u00060\u0001j\u0002`\u0002:\u0001KB1\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0014\u0010%\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010&\u001a\u00020'H\u0016J\u0016\u0010%\u001a\u00060\u0001j\u0002`\u00022\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J&\u0010%\u001a\u00060\u0001j\u0002`\u00022\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u0018H\u0016J\b\u0010,\u001a\u00020)H\u0007J\u000e\u0010-\u001a\u00020'2\u0006\u0010.\u001a\u00020\u0018J\b\u0010/\u001a\u000200H\u0002J \u00101\u001a\u0002002\u0006\u00102\u001a\u00020\u00182\u0006\u00103\u001a\u00020\u00182\u0006\u00104\u001a\u00020\u0018H\u0002J\u0010\u00105\u001a\u0002002\u0006\u0010.\u001a\u00020\u0018H\u0007J\u0010\u00106\u001a\u0002002\u0006\u0010.\u001a\u00020\u0018H\u0007J\u001e\u00107\u001a\u0002002\u0006\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)J9\u00107\u001a\u0002002\u0006\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)2\b\b\u0002\u00108\u001a\u00020\u00182\b\b\u0002\u00109\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b:J \u0010;\u001a\u0002002\u0006\u0010.\u001a\u00020\u00182\u0006\u0010<\u001a\u00020\u00152\u0006\u0010=\u001a\u00020\u0015H\u0002J\u001a\u0010>\u001a\u0002002\u0006\u0010?\u001a\u00020\u001cH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b@\u0010\"J\b\u0010A\u001a\u000200H\u0007J\u0015\u0010B\u001a\u0002002\u0006\u0010C\u001a\u00020)H\u0000\u00a2\u0006\u0002\bDJ\b\u0010E\u001a\u00020FH\u0016J(\u0010G\u001a\u00020\u00042\b\b\u0002\u0010\u001d\u001a\u00020\u001c2\n\b\u0002\u0010H\u001a\u0004\u0018\u00010\u001cH\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\bI\u0010JR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158G\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c8G@FX\u0087\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0012\u0012\u0004\b\u001e\u0010\u0011\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0016\u0010#\u001a\u00020\u001cX\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010$R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006L"}, d2={"Landroidx/compose/foundation/text/input/TextFieldBuffer;", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "initialValue", "Landroidx/compose/foundation/text/input/TextFieldCharSequence;", "initialChanges", "Landroidx/compose/foundation/text/input/internal/ChangeTracker;", "sourceValue", "offsetMappingCalculator", "Landroidx/compose/foundation/text/input/internal/OffsetMappingCalculator;", "(Landroidx/compose/foundation/text/input/TextFieldCharSequence;Landroidx/compose/foundation/text/input/internal/ChangeTracker;Landroidx/compose/foundation/text/input/TextFieldCharSequence;Landroidx/compose/foundation/text/input/internal/OffsetMappingCalculator;)V", "buffer", "Landroidx/compose/foundation/text/input/internal/PartialGapBuffer;", "changeTracker", "changes", "Landroidx/compose/foundation/text/input/TextFieldBuffer$ChangeList;", "getChanges$annotations", "()V", "getChanges", "()Landroidx/compose/foundation/text/input/TextFieldBuffer$ChangeList;", "hasSelection", "", "()Z", "length", "", "getLength", "()I", "value", "Landroidx/compose/ui/text/TextRange;", "selection", "getSelection-d9O1mEE$annotations", "getSelection-d9O1mEE", "()J", "setSelection-5zc-tL8", "(J)V", "selectionInChars", "J", "append", "char", "", "text", "", "start", "end", "asCharSequence", "charAt", "index", "clearChangeList", "", "onTextWillChange", "replaceStart", "replaceEnd", "newLength", "placeCursorAfterCharAt", "placeCursorBeforeCharAt", "replace", "textStart", "textEnd", "replace$foundation_release", "requireValidIndex", "startExclusive", "endExclusive", "requireValidRange", "range", "requireValidRange-5zc-tL8", "revertAllChanges", "setTextIfChanged", "newText", "setTextIfChanged$foundation_release", "toString", "", "toTextFieldCharSequence", "composition", "toTextFieldCharSequence-udt6zUU$foundation_release", "(JLandroidx/compose/ui/text/TextRange;)Landroidx/compose/foundation/text/input/TextFieldCharSequence;", "ChangeList", "foundation_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nTextFieldBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextFieldBuffer.kt\nandroidx/compose/foundation/text/input/TextFieldBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 TextFieldBuffer.kt\nandroidx/compose/foundation/text/input/TextFieldBufferKt\n*L\n1#1,560:1\n1#2:561\n503#3,43:562\n*S KotlinDebug\n*F\n+ 1 TextFieldBuffer.kt\nandroidx/compose/foundation/text/input/TextFieldBuffer\n*L\n170#1:562,43\n*E\n"})
public final class TextFieldBuffer
implements Appendable {
    @NotNull
    private final TextFieldCharSequence sourceValue;
    @Nullable
    private final OffsetMappingCalculator offsetMappingCalculator;
    @NotNull
    private final PartialGapBuffer buffer;
    @Nullable
    private ChangeTracker changeTracker;
    private long selectionInChars;
    public static final int $stable = 8;

    public TextFieldBuffer(@NotNull TextFieldCharSequence initialValue, @Nullable ChangeTracker initialChanges, @NotNull TextFieldCharSequence sourceValue, @Nullable OffsetMappingCalculator offsetMappingCalculator) {
        ChangeTracker changeTracker;
        this.sourceValue = sourceValue;
        this.offsetMappingCalculator = offsetMappingCalculator;
        this.buffer = new PartialGapBuffer(initialValue);
        TextFieldBuffer textFieldBuffer = this;
        ChangeTracker changeTracker2 = initialChanges;
        if (changeTracker2 != null) {
            ChangeTracker changeTracker3 = changeTracker2;
            TextFieldBuffer textFieldBuffer2 = textFieldBuffer;
            boolean bl = false;
            changeTracker = new ChangeTracker(initialChanges);
            textFieldBuffer = textFieldBuffer2;
        } else {
            changeTracker = null;
        }
        textFieldBuffer.changeTracker = changeTracker;
        this.selectionInChars = initialValue.getSelection-d9O1mEE();
    }

    public /* synthetic */ TextFieldBuffer(TextFieldCharSequence textFieldCharSequence, ChangeTracker changeTracker, TextFieldCharSequence textFieldCharSequence2, OffsetMappingCalculator offsetMappingCalculator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            changeTracker = null;
        }
        if ((n & 4) != 0) {
            textFieldCharSequence2 = textFieldCharSequence;
        }
        if ((n & 8) != 0) {
            offsetMappingCalculator = null;
        }
        this(textFieldCharSequence, changeTracker, textFieldCharSequence2, offsetMappingCalculator);
    }

    public final int getLength() {
        return this.buffer.length();
    }

    @NotNull
    public final ChangeList getChanges() {
        ChangeTracker changeTracker = this.changeTracker;
        return changeTracker != null ? (ChangeList)changeTracker : (ChangeList)EmptyChangeList.INSTANCE;
    }

    @ExperimentalFoundationApi
    public static /* synthetic */ void getChanges$annotations() {
    }

    @JvmName(name="hasSelection")
    public final boolean hasSelection() {
        return !TextRange.getCollapsed-impl((long)this.getSelection-d9O1mEE());
    }

    @ExperimentalFoundationApi
    public final long getSelection-d9O1mEE() {
        return this.selectionInChars;
    }

    public final void setSelection-5zc-tL8(long value) {
        this.requireValidRange-5zc-tL8(value);
        this.selectionInChars = value;
    }

    @ExperimentalFoundationApi
    public static /* synthetic */ void getSelection-d9O1mEE$annotations() {
    }

    public final void replace(int start, int end, @NotNull CharSequence text) {
        this.replace$foundation_release(start, end, text, 0, text.length());
    }

    public final void replace$foundation_release(int start, int end, @NotNull CharSequence text, int textStart, int textEnd) {
        if (!(start <= end)) {
            boolean $i$a$-require-TextFieldBuffer$replace$32 = false;
            String $i$a$-require-TextFieldBuffer$replace$32 = "Expected start=" + start + " <= end=" + end;
            throw new IllegalArgumentException($i$a$-require-TextFieldBuffer$replace$32.toString());
        }
        if (!(textStart <= textEnd)) {
            boolean bl = false;
            String string2 = "Expected textStart=" + textStart + " <= textEnd=" + textEnd;
            throw new IllegalArgumentException(string2.toString());
        }
        this.onTextWillChange(start, end, textEnd - textStart);
        this.buffer.replace(start, end, text, textStart, textEnd);
    }

    public static /* synthetic */ void replace$foundation_release$default(TextFieldBuffer textFieldBuffer, int n, int n2, CharSequence charSequence, int n3, int n4, int n5, Object object) {
        if ((n5 & 8) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n4 = charSequence.length();
        }
        textFieldBuffer.replace$foundation_release(n, n2, charSequence, n3, n4);
    }

    /*
     * WARNING - void declaration
     */
    public final void setTextIfChanged$foundation_release(@NotNull CharSequence newText) {
        CharSequence a$iv = this.buffer;
        boolean $i$f$findCommonPrefixAndSuffix = false;
        int aStart$iv = 0;
        int aEnd$iv = a$iv.length();
        int bStart$iv = 0;
        int bEnd$iv = newText.length();
        if (a$iv.length() > 0 && newText.length() > 0) {
            boolean prefixFound$iv = false;
            boolean suffixFound$iv = false;
            do {
                if (!prefixFound$iv) {
                    if (a$iv.charAt(aStart$iv) == newText.charAt(bStart$iv)) {
                        ++aStart$iv;
                        ++bStart$iv;
                    } else {
                        prefixFound$iv = true;
                    }
                }
                if (suffixFound$iv) continue;
                if (a$iv.charAt(aEnd$iv - 1) == newText.charAt(bEnd$iv - 1)) {
                    --aEnd$iv;
                    --bEnd$iv;
                    continue;
                }
                suffixFound$iv = true;
            } while (aStart$iv < aEnd$iv && bStart$iv < bEnd$iv && (!prefixFound$iv || !suffixFound$iv));
        }
        if (aStart$iv < aEnd$iv || bStart$iv < bEnd$iv) {
            void newEnd;
            void newStart;
            void thisEnd;
            int n = bEnd$iv;
            int n2 = bStart$iv;
            int n3 = aEnd$iv;
            int thisStart = aStart$iv;
            boolean bl = false;
            this.replace$foundation_release(thisStart, (int)thisEnd, newText, (int)newStart, (int)newEnd);
        }
    }

    @Override
    @NotNull
    public Appendable append(@Nullable CharSequence text) {
        TextFieldBuffer textFieldBuffer;
        TextFieldBuffer $this$append_u24lambda_u244 = textFieldBuffer = this;
        boolean bl = false;
        if (text != null) {
            $this$append_u24lambda_u244.onTextWillChange($this$append_u24lambda_u244.getLength(), $this$append_u24lambda_u244.getLength(), text.length());
            PartialGapBuffer.replace$default($this$append_u24lambda_u244.buffer, $this$append_u24lambda_u244.buffer.length(), $this$append_u24lambda_u244.buffer.length(), text, 0, 0, 24, null);
        }
        return textFieldBuffer;
    }

    @Override
    @NotNull
    public Appendable append(@Nullable CharSequence text, int start, int end) {
        TextFieldBuffer textFieldBuffer;
        TextFieldBuffer $this$append_u24lambda_u245 = textFieldBuffer = this;
        boolean bl = false;
        if (text != null) {
            $this$append_u24lambda_u245.onTextWillChange($this$append_u24lambda_u245.getLength(), $this$append_u24lambda_u245.getLength(), end - start);
            PartialGapBuffer.replace$default($this$append_u24lambda_u245.buffer, $this$append_u24lambda_u245.buffer.length(), $this$append_u24lambda_u245.buffer.length(), text.subSequence(start, end), 0, 0, 24, null);
        }
        return textFieldBuffer;
    }

    @Override
    @NotNull
    public Appendable append(char c) {
        TextFieldBuffer textFieldBuffer;
        TextFieldBuffer $this$append_u24lambda_u246 = textFieldBuffer = this;
        boolean bl = false;
        $this$append_u24lambda_u246.onTextWillChange($this$append_u24lambda_u246.getLength(), $this$append_u24lambda_u246.getLength(), 1);
        PartialGapBuffer.replace$default($this$append_u24lambda_u246.buffer, $this$append_u24lambda_u246.buffer.length(), $this$append_u24lambda_u246.buffer.length(), String.valueOf(c), 0, 0, 24, null);
        return textFieldBuffer;
    }

    private final void onTextWillChange(int replaceStart, int replaceEnd, int newLength) {
        ChangeTracker changeTracker = this.changeTracker;
        if (changeTracker == null) {
            ChangeTracker changeTracker2;
            ChangeTracker it = changeTracker2 = new ChangeTracker(null, 1, null);
            boolean bl = false;
            this.changeTracker = it;
            changeTracker = changeTracker2;
        }
        changeTracker.trackChange(replaceStart, replaceEnd, newLength);
        OffsetMappingCalculator offsetMappingCalculator = this.offsetMappingCalculator;
        if (offsetMappingCalculator != null) {
            offsetMappingCalculator.recordEditOperation(replaceStart, replaceEnd, newLength);
        }
        int start = Math.min(replaceStart, replaceEnd);
        int end = Math.max(replaceStart, replaceEnd);
        int selStart = TextRange.getMin-impl((long)this.getSelection-d9O1mEE());
        int selEnd = TextRange.getMax-impl((long)this.getSelection-d9O1mEE());
        if (selEnd < start) {
            return;
        }
        if (selStart <= start && end <= selEnd) {
            int diff = newLength - (end - start);
            if (selStart == selEnd) {
                selStart += diff;
            }
            selEnd += diff;
        } else if (selStart > start && selEnd < end) {
            selStart = start + newLength;
            selEnd = start + newLength;
        } else if (selStart >= end) {
            int diff = newLength - (end - start);
            selStart += diff;
            selEnd += diff;
        } else if (start < selStart) {
            selStart = start + newLength;
            selEnd += newLength - (end - start);
        } else {
            selEnd = start;
        }
        this.selectionInChars = TextRangeKt.TextRange((int)selStart, (int)selEnd);
    }

    public final char charAt(int index2) {
        return this.buffer.charAt(index2);
    }

    @NotNull
    public String toString() {
        return this.buffer.toString();
    }

    @ExperimentalFoundationApi
    @NotNull
    public final CharSequence asCharSequence() {
        return this.buffer;
    }

    private final void clearChangeList() {
        block0: {
            ChangeTracker changeTracker = this.changeTracker;
            if (changeTracker == null) break block0;
            changeTracker.clearChanges();
        }
    }

    @ExperimentalFoundationApi
    public final void revertAllChanges() {
        this.replace(0, this.getLength(), ((Object)this.sourceValue).toString());
        this.setSelection-5zc-tL8(this.sourceValue.getSelection-d9O1mEE());
        this.clearChangeList();
    }

    @ExperimentalFoundationApi
    public final void placeCursorBeforeCharAt(int index2) {
        this.requireValidIndex(index2, true, false);
        this.selectionInChars = TextRangeKt.TextRange((int)index2);
    }

    @ExperimentalFoundationApi
    public final void placeCursorAfterCharAt(int index2) {
        this.requireValidIndex(index2, false, true);
        this.selectionInChars = TextRangeKt.TextRange((int)RangesKt.coerceAtMost((int)(index2 + 1), (int)this.getLength()));
    }

    @NotNull
    public final TextFieldCharSequence toTextFieldCharSequence-udt6zUU$foundation_release(long selection, @Nullable TextRange composition) {
        return TextFieldCharSequenceKt.TextFieldCharSequence-3r_uNRQ(this.buffer.toString(), selection, composition);
    }

    public static /* synthetic */ TextFieldCharSequence toTextFieldCharSequence-udt6zUU$foundation_release$default(TextFieldBuffer textFieldBuffer, long l, TextRange textRange2, int n, Object object) {
        if ((n & 1) != 0) {
            l = textFieldBuffer.getSelection-d9O1mEE();
        }
        if ((n & 2) != 0) {
            textRange2 = null;
        }
        return textFieldBuffer.toTextFieldCharSequence-udt6zUU$foundation_release(l, textRange2);
    }

    private final void requireValidIndex(int index2, boolean startExclusive, boolean endExclusive) {
        int end;
        int start = startExclusive ? 0 : -1;
        int n = end = endExclusive ? this.getLength() : this.getLength() + 1;
        if (!(start <= index2 ? index2 < end : false)) {
            boolean bl = false;
            String string2 = "Expected " + index2 + " to be in [" + start + ", " + end + ')';
            throw new IllegalArgumentException(string2.toString());
        }
    }

    private final void requireValidRange-5zc-tL8(long range) {
        long validRange = TextRangeKt.TextRange((int)0, (int)this.getLength());
        if (!TextRange.contains-5zc-tL8((long)validRange, (long)range)) {
            boolean bl = false;
            String string2 = "Expected " + TextRange.toString-impl((long)range) + " to be in " + TextRange.toString-impl((long)validRange);
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\bg\u0018\u00002\u00020\u0001J\u001d\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H&\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H&\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\f\u0010\nR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0002\u0082\u0002\u0011\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Landroidx/compose/foundation/text/input/TextFieldBuffer$ChangeList;", "", "changeCount", "", "getChangeCount", "()I", "getOriginalRange", "Landroidx/compose/ui/text/TextRange;", "changeIndex", "getOriginalRange--jx7JFs", "(I)J", "getRange", "getRange--jx7JFs", "foundation_release"})
    @ExperimentalFoundationApi
    public static interface ChangeList {
        public int getChangeCount();

        public long getRange--jx7JFs(int var1);

        public long getOriginalRange--jx7JFs(int var1);
    }
}

