/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal;

import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputContentInfo;
import androidx.compose.foundation.text.input.internal.InputEventCallback2;
import androidx.compose.foundation.text.input.internal.InputMethodManager;
import androidx.compose.foundation.text.input.internal.RecordingInputConnection_androidKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.input.CommitTextCommand;
import androidx.compose.ui.text.input.DeleteSurroundingTextCommand;
import androidx.compose.ui.text.input.DeleteSurroundingTextInCodePointsCommand;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.FinishComposingTextCommand;
import androidx.compose.ui.text.input.ImeAction;
import androidx.compose.ui.text.input.SetComposingRegionCommand;
import androidx.compose.ui.text.input.SetComposingTextCommand;
import androidx.compose.ui.text.input.SetSelectionCommand;
import androidx.compose.ui.text.input.TextFieldValue;
import androidx.compose.ui.text.input.TextFieldValueKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0010H\u0002J\b\u0010\u001e\u001a\u00020\u0007H\u0016J\b\u0010\u001f\u001a\u00020\u0007H\u0002J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\fH\u0016J\b\u0010\"\u001a\u00020\u001cH\u0016J\u0012\u0010#\u001a\u00020\u00072\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\"\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\f2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\u0012\u0010,\u001a\u00020\u00072\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\u001a\u0010/\u001a\u00020\u00072\b\u0010$\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u00020\fH\u0016J\u0018\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u00020\f2\u0006\u00104\u001a\u00020\fH\u0016J\u0018\u00105\u001a\u00020\u00072\u0006\u00103\u001a\u00020\f2\u0006\u00104\u001a\u00020\fH\u0016J\b\u00106\u001a\u00020\u0007H\u0016J\b\u00107\u001a\u00020\u0007H\u0002J\u0017\u00108\u001a\u00020\u00072\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u001c0:H\u0082\bJ\b\u0010;\u001a\u00020\u0007H\u0016J\u0010\u0010<\u001a\u00020\f2\u0006\u0010=\u001a\u00020\fH\u0016J\u001a\u0010>\u001a\u00020?2\b\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010)\u001a\u00020\fH\u0016J\n\u0010B\u001a\u0004\u0018\u00010CH\u0016J\u0012\u0010D\u001a\u0004\u0018\u0001002\u0006\u0010)\u001a\u00020\fH\u0016J\u0018\u0010E\u001a\u0002002\u0006\u0010F\u001a\u00020\f2\u0006\u0010)\u001a\u00020\fH\u0016J\u0018\u0010G\u001a\u0002002\u0006\u0010F\u001a\u00020\f2\u0006\u0010)\u001a\u00020\fH\u0016J\u0010\u0010H\u001a\u00020\u001c2\u0006\u0010I\u001a\u00020JH\u0002J\u0010\u0010K\u001a\u00020\u00072\u0006\u0010L\u001a\u00020\fH\u0016J\u0010\u0010M\u001a\u00020\u00072\u0006\u0010N\u001a\u00020\fH\u0016J\u001c\u0010O\u001a\u00020\u00072\b\u0010P\u001a\u0004\u0018\u00010J2\b\u0010Q\u001a\u0004\u0018\u00010+H\u0016J\u0010\u0010R\u001a\u00020\u00072\u0006\u0010S\u001a\u00020\u0007H\u0016J\u0010\u0010T\u001a\u00020\u00072\u0006\u0010U\u001a\u00020\fH\u0016J\u0010\u0010V\u001a\u00020\u00072\u0006\u0010W\u001a\u00020XH\u0016J\u0010\u0010Y\u001a\u00020\u001c2\u0006\u0010Z\u001a\u00020\fH\u0002J\u0018\u0010[\u001a\u00020\u00072\u0006\u0010\\\u001a\u00020\f2\u0006\u0010]\u001a\u00020\fH\u0016J\u001a\u0010^\u001a\u00020\u00072\b\u0010$\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u00020\fH\u0016J\u0018\u0010_\u001a\u00020\u00072\u0006\u0010\\\u001a\u00020\f2\u0006\u0010]\u001a\u00020\fH\u0016J\u0016\u0010`\u001a\u00020\u001c2\u0006\u0010a\u001a\u00020\u00032\u0006\u0010b\u001a\u00020cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006d"}, d2={"Landroidx/compose/foundation/text/input/internal/RecordingInputConnection;", "Landroid/view/inputmethod/InputConnection;", "initState", "Landroidx/compose/ui/text/input/TextFieldValue;", "eventCallback", "Landroidx/compose/foundation/text/input/internal/InputEventCallback2;", "autoCorrect", "", "(Landroidx/compose/ui/text/input/TextFieldValue;Landroidx/compose/foundation/text/input/internal/InputEventCallback2;Z)V", "getAutoCorrect", "()Z", "batchDepth", "", "currentExtractedTextRequestToken", "editCommands", "", "Landroidx/compose/ui/text/input/EditCommand;", "getEventCallback", "()Landroidx/compose/foundation/text/input/internal/InputEventCallback2;", "extractedTextMonitorMode", "isActive", "value", "textFieldValue", "getTextFieldValue$foundation_release", "()Landroidx/compose/ui/text/input/TextFieldValue;", "setTextFieldValue$foundation_release", "(Landroidx/compose/ui/text/input/TextFieldValue;)V", "addEditCommandWithBatch", "", "editCommand", "beginBatchEdit", "beginBatchEditInternal", "clearMetaKeyStates", "states", "closeConnection", "commitCompletion", "text", "Landroid/view/inputmethod/CompletionInfo;", "commitContent", "inputContentInfo", "Landroid/view/inputmethod/InputContentInfo;", "flags", "opts", "Landroid/os/Bundle;", "commitCorrection", "correctionInfo", "Landroid/view/inputmethod/CorrectionInfo;", "commitText", "", "newCursorPosition", "deleteSurroundingText", "beforeLength", "afterLength", "deleteSurroundingTextInCodePoints", "endBatchEdit", "endBatchEditInternal", "ensureActive", "block", "Lkotlin/Function0;", "finishComposingText", "getCursorCapsMode", "reqModes", "getExtractedText", "Landroid/view/inputmethod/ExtractedText;", "request", "Landroid/view/inputmethod/ExtractedTextRequest;", "getHandler", "Landroid/os/Handler;", "getSelectedText", "getTextAfterCursor", "maxChars", "getTextBeforeCursor", "logDebug", "message", "", "performContextMenuAction", "id", "performEditorAction", "editorAction", "performPrivateCommand", "action", "data", "reportFullscreenMode", "enabled", "requestCursorUpdates", "cursorUpdateMode", "sendKeyEvent", "event", "Landroid/view/KeyEvent;", "sendSynthesizedKeyEvent", "code", "setComposingRegion", "start", "end", "setComposingText", "setSelection", "updateInputState", "state", "inputMethodManager", "Landroidx/compose/foundation/text/input/internal/InputMethodManager;", "foundation_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRecordingInputConnection.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecordingInputConnection.android.kt\nandroidx/compose/foundation/text/input/internal/RecordingInputConnection\n*L\n1#1,474:1\n94#1,5:475\n94#1,5:480\n94#1,5:485\n94#1,5:490\n94#1,5:495\n94#1,5:500\n94#1,5:505\n94#1,5:510\n94#1,5:515\n94#1,5:520\n94#1,5:525\n94#1,5:530\n94#1,5:535\n94#1,5:540\n94#1,5:545\n94#1,5:550\n94#1,5:555\n*S KotlinDebug\n*F\n+ 1 RecordingInputConnection.android.kt\nandroidx/compose/foundation/text/input/internal/RecordingInputConnection\n*L\n151#1:475,5\n186#1:480,5\n191#1:485,5\n197#1:490,5\n205#1:495,5\n216#1:500,5\n222#1:505,5\n228#1:510,5\n234#1:515,5\n269#1:520,5\n352#1:525,5\n378#1:530,5\n400#1:535,5\n410#1:540,5\n422#1:545,5\n442#1:550,5\n451#1:555,5\n*E\n"})
public final class RecordingInputConnection
implements InputConnection {
    @NotNull
    private final InputEventCallback2 eventCallback;
    private final boolean autoCorrect;
    private int batchDepth;
    @NotNull
    private TextFieldValue textFieldValue;
    private int currentExtractedTextRequestToken;
    private boolean extractedTextMonitorMode;
    @NotNull
    private final List<EditCommand> editCommands;
    private boolean isActive;
    public static final int $stable = 8;

    public RecordingInputConnection(@NotNull TextFieldValue initState, @NotNull InputEventCallback2 eventCallback, boolean autoCorrect) {
        this.eventCallback = eventCallback;
        this.autoCorrect = autoCorrect;
        this.textFieldValue = initState;
        this.editCommands = new ArrayList();
        this.isActive = true;
    }

    @NotNull
    public final InputEventCallback2 getEventCallback() {
        return this.eventCallback;
    }

    public final boolean getAutoCorrect() {
        return this.autoCorrect;
    }

    @NotNull
    public final TextFieldValue getTextFieldValue$foundation_release() {
        return this.textFieldValue;
    }

    public final void setTextFieldValue$foundation_release(@NotNull TextFieldValue value) {
        this.textFieldValue = value;
    }

    private final boolean ensureActive(Function0<Unit> block) {
        boolean bl;
        boolean $i$f$ensureActive = false;
        boolean applying = bl = this.isActive;
        boolean bl2 = false;
        if (applying) {
            block.invoke();
        }
        return bl;
    }

    public final void updateInputState(@NotNull TextFieldValue state, @NotNull InputMethodManager inputMethodManager) {
        if (!this.isActive) {
            return;
        }
        this.setTextFieldValue$foundation_release(state);
        if (this.extractedTextMonitorMode) {
            inputMethodManager.updateExtractedText(this.currentExtractedTextRequestToken, RecordingInputConnection_androidKt.access$toExtractedText(state));
        }
        TextRange textRange2 = state.getComposition-MzsxiRA();
        int compositionStart = textRange2 != null ? TextRange.getMin-impl((long)textRange2.unbox-impl()) : -1;
        TextRange textRange3 = state.getComposition-MzsxiRA();
        int compositionEnd = textRange3 != null ? TextRange.getMax-impl((long)textRange3.unbox-impl()) : -1;
        inputMethodManager.updateSelection(TextRange.getMin-impl((long)state.getSelection-d9O1mEE()), TextRange.getMax-impl((long)state.getSelection-d9O1mEE()), compositionStart, compositionEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addEditCommandWithBatch(EditCommand editCommand) {
        this.beginBatchEditInternal();
        try {
            this.editCommands.add(editCommand);
        }
        finally {
            this.endBatchEditInternal();
        }
    }

    public boolean beginBatchEdit() {
        boolean bl;
        RecordingInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean applying$iv = bl = this_$iv.isActive;
        boolean bl2 = false;
        if (applying$iv) {
            boolean bl3 = false;
            return this.beginBatchEditInternal();
        }
        return bl;
    }

    private final boolean beginBatchEditInternal() {
        int n = this.batchDepth;
        this.batchDepth = n + 1;
        return true;
    }

    public boolean endBatchEdit() {
        return this.endBatchEditInternal();
    }

    private final boolean endBatchEditInternal() {
        int n = this.batchDepth;
        this.batchDepth = n + -1;
        if (this.batchDepth == 0 && !((Collection)this.editCommands).isEmpty()) {
            this.eventCallback.onEditCommands(CollectionsKt.toMutableList((Collection)this.editCommands));
            this.editCommands.clear();
        }
        return this.batchDepth > 0;
    }

    public void closeConnection() {
        this.editCommands.clear();
        this.batchDepth = 0;
        this.isActive = false;
        this.eventCallback.onConnectionClosed(this);
    }

    public boolean commitText(@Nullable CharSequence text, int newCursorPosition) {
        boolean bl;
        RecordingInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean applying$iv = bl = this_$iv.isActive;
        boolean bl2 = false;
        if (applying$iv) {
            boolean bl3 = false;
            this.addEditCommandWithBatch((EditCommand)new CommitTextCommand(String.valueOf(text), newCursorPosition));
        }
        return bl;
    }

    public boolean setComposingRegion(int start, int end) {
        boolean bl;
        RecordingInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean applying$iv = bl = this_$iv.isActive;
        boolean bl2 = false;
        if (applying$iv) {
            boolean bl3 = false;
            this.addEditCommandWithBatch((EditCommand)new SetComposingRegionCommand(start, end));
        }
        return bl;
    }

    public boolean setComposingText(@Nullable CharSequence text, int newCursorPosition) {
        boolean bl;
        RecordingInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean applying$iv = bl = this_$iv.isActive;
        boolean bl2 = false;
        if (applying$iv) {
            boolean bl3 = false;
            this.addEditCommandWithBatch((EditCommand)new SetComposingTextCommand(String.valueOf(text), newCursorPosition));
        }
        return bl;
    }

    public boolean deleteSurroundingTextInCodePoints(int beforeLength, int afterLength) {
        boolean bl;
        RecordingInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean applying$iv = bl = this_$iv.isActive;
        boolean bl2 = false;
        if (applying$iv) {
            boolean bl3 = false;
            this.addEditCommandWithBatch((EditCommand)new DeleteSurroundingTextInCodePointsCommand(beforeLength, afterLength));
            return true;
        }
        return bl;
    }

    public boolean deleteSurroundingText(int beforeLength, int afterLength) {
        boolean bl;
        RecordingInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean applying$iv = bl = this_$iv.isActive;
        boolean bl2 = false;
        if (applying$iv) {
            boolean bl3 = false;
            this.addEditCommandWithBatch((EditCommand)new DeleteSurroundingTextCommand(beforeLength, afterLength));
            return true;
        }
        return bl;
    }

    public boolean setSelection(int start, int end) {
        boolean bl;
        RecordingInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean applying$iv = bl = this_$iv.isActive;
        boolean bl2 = false;
        if (applying$iv) {
            boolean bl3 = false;
            this.addEditCommandWithBatch((EditCommand)new SetSelectionCommand(start, end));
            return true;
        }
        return bl;
    }

    public boolean finishComposingText() {
        boolean bl;
        RecordingInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean applying$iv = bl = this_$iv.isActive;
        boolean bl2 = false;
        if (applying$iv) {
            boolean bl3 = false;
            this.addEditCommandWithBatch((EditCommand)new FinishComposingTextCommand());
            return true;
        }
        return bl;
    }

    public boolean sendKeyEvent(@NotNull KeyEvent event) {
        boolean bl;
        RecordingInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean applying$iv = bl = this_$iv.isActive;
        boolean bl2 = false;
        if (applying$iv) {
            boolean bl3 = false;
            this.eventCallback.onKeyEvent(event);
            return true;
        }
        return bl;
    }

    @NotNull
    public CharSequence getTextBeforeCursor(int maxChars, int flags) {
        String result2 = TextFieldValueKt.getTextBeforeSelection((TextFieldValue)this.textFieldValue, (int)maxChars).toString();
        return result2;
    }

    @NotNull
    public CharSequence getTextAfterCursor(int maxChars, int flags) {
        String result2 = TextFieldValueKt.getTextAfterSelection((TextFieldValue)this.textFieldValue, (int)maxChars).toString();
        return result2;
    }

    @Nullable
    public CharSequence getSelectedText(int flags) {
        CharSequence result2 = TextRange.getCollapsed-impl((long)this.textFieldValue.getSelection-d9O1mEE()) ? null : (CharSequence)TextFieldValueKt.getSelectedText((TextFieldValue)this.textFieldValue).toString();
        return result2;
    }

    public boolean requestCursorUpdates(int cursorUpdateMode) {
        boolean bl;
        RecordingInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean applying$iv = bl = this_$iv.isActive;
        boolean bl2 = false;
        if (applying$iv) {
            boolean bl3 = false;
            boolean immediate = (cursorUpdateMode & 1) != 0;
            boolean monitor = (cursorUpdateMode & 2) != 0;
            boolean includeInsertionMarker = true;
            boolean includeCharacterBounds = true;
            boolean includeEditorBounds = false;
            boolean includeLineBounds = false;
            if (Build.VERSION.SDK_INT >= 33) {
                includeInsertionMarker = (cursorUpdateMode & 0x10) != 0;
                includeCharacterBounds = (cursorUpdateMode & 8) != 0;
                boolean bl4 = includeEditorBounds = (cursorUpdateMode & 4) != 0;
                if (Build.VERSION.SDK_INT >= 34) {
                    boolean bl5 = includeLineBounds = (cursorUpdateMode & 0x20) != 0;
                }
                if (!(includeInsertionMarker || includeCharacterBounds || includeEditorBounds || includeLineBounds)) {
                    includeInsertionMarker = true;
                    includeCharacterBounds = true;
                    includeEditorBounds = true;
                    if (Build.VERSION.SDK_INT >= 34) {
                        includeLineBounds = true;
                    }
                }
            }
            this.eventCallback.onRequestCursorAnchorInfo(immediate, monitor, includeInsertionMarker, includeCharacterBounds, includeEditorBounds, includeLineBounds);
            return true;
        }
        return bl;
    }

    @NotNull
    public ExtractedText getExtractedText(@Nullable ExtractedTextRequest request2, int flags) {
        boolean bl = this.extractedTextMonitorMode = (flags & 1) != 0;
        if (this.extractedTextMonitorMode) {
            ExtractedTextRequest extractedTextRequest = request2;
            this.currentExtractedTextRequestToken = extractedTextRequest != null ? extractedTextRequest.token : 0;
        }
        ExtractedText extractedText = RecordingInputConnection_androidKt.access$toExtractedText(this.textFieldValue);
        return extractedText;
    }

    public boolean performContextMenuAction(int id) {
        boolean bl;
        RecordingInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean applying$iv = bl = this_$iv.isActive;
        boolean bl2 = false;
        if (applying$iv) {
            boolean bl3 = false;
            switch (id) {
                case 16908319: {
                    this.addEditCommandWithBatch((EditCommand)new SetSelectionCommand(0, this.textFieldValue.getText().length()));
                    break;
                }
                case 0x1020020: {
                    this.sendSynthesizedKeyEvent(277);
                    break;
                }
                case 0x1020021: {
                    this.sendSynthesizedKeyEvent(278);
                    break;
                }
                case 0x1020022: {
                    this.sendSynthesizedKeyEvent(279);
                }
            }
            return false;
        }
        return bl;
    }

    private final void sendSynthesizedKeyEvent(int code) {
        this.sendKeyEvent(new KeyEvent(0, code));
        this.sendKeyEvent(new KeyEvent(1, code));
    }

    public boolean performEditorAction(int editorAction) {
        boolean bl;
        RecordingInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean applying$iv = bl = this_$iv.isActive;
        boolean bl2 = false;
        if (applying$iv) {
            int n;
            boolean bl3 = false;
            switch (editorAction) {
                case 0: {
                    n = ImeAction.Companion.getDefault-eUduSuo();
                    break;
                }
                case 6: {
                    n = ImeAction.Companion.getDone-eUduSuo();
                    break;
                }
                case 4: {
                    n = ImeAction.Companion.getSend-eUduSuo();
                    break;
                }
                case 3: {
                    n = ImeAction.Companion.getSearch-eUduSuo();
                    break;
                }
                case 7: {
                    n = ImeAction.Companion.getPrevious-eUduSuo();
                    break;
                }
                case 5: {
                    n = ImeAction.Companion.getNext-eUduSuo();
                    break;
                }
                case 2: {
                    n = ImeAction.Companion.getGo-eUduSuo();
                    break;
                }
                default: {
                    Log.w((String)"RecordingIC", (String)("IME sends unsupported Editor Action: " + editorAction));
                    n = ImeAction.Companion.getDefault-eUduSuo();
                }
            }
            int imeAction = n;
            this.eventCallback.onImeAction-KlQnJC8(imeAction);
            return true;
        }
        return bl;
    }

    public boolean commitCompletion(@Nullable CompletionInfo text) {
        boolean bl;
        RecordingInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean applying$iv = bl = this_$iv.isActive;
        boolean bl2 = false;
        if (applying$iv) {
            boolean bl3 = false;
            return false;
        }
        return bl;
    }

    public boolean commitCorrection(@Nullable CorrectionInfo correctionInfo) {
        boolean bl;
        RecordingInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean applying$iv = bl = this_$iv.isActive;
        boolean bl2 = false;
        if (applying$iv) {
            boolean bl3 = false;
            return this.autoCorrect;
        }
        return bl;
    }

    @Nullable
    public Handler getHandler() {
        return null;
    }

    public boolean clearMetaKeyStates(int states) {
        boolean bl;
        RecordingInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean applying$iv = bl = this_$iv.isActive;
        boolean bl2 = false;
        if (applying$iv) {
            boolean bl3 = false;
            return false;
        }
        return bl;
    }

    public boolean reportFullscreenMode(boolean enabled) {
        return false;
    }

    public int getCursorCapsMode(int reqModes) {
        return TextUtils.getCapsMode((CharSequence)this.textFieldValue.getText(), (int)TextRange.getMin-impl((long)this.textFieldValue.getSelection-d9O1mEE()), (int)reqModes);
    }

    public boolean performPrivateCommand(@Nullable String action, @Nullable Bundle data) {
        boolean bl;
        RecordingInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean applying$iv = bl = this_$iv.isActive;
        boolean bl2 = false;
        if (applying$iv) {
            boolean bl3 = false;
            return true;
        }
        return bl;
    }

    public boolean commitContent(@NotNull InputContentInfo inputContentInfo, int flags, @Nullable Bundle opts) {
        boolean bl;
        RecordingInputConnection this_$iv = this;
        boolean $i$f$ensureActive = false;
        boolean applying$iv = bl = this_$iv.isActive;
        boolean bl2 = false;
        if (applying$iv) {
            boolean bl3 = false;
            return false;
        }
        return bl;
    }

    private final void logDebug(String message) {
    }
}

