/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal;

import android.os.Build;
import android.view.inputmethod.CursorAnchorInfo;
import androidx.compose.foundation.text.input.TextFieldCharSequence;
import androidx.compose.foundation.text.input.internal.ComposeInputMethodManager;
import androidx.compose.foundation.text.input.internal.CursorAnchorInfoBuilder_androidKt;
import androidx.compose.foundation.text.input.internal.TextLayoutState;
import androidx.compose.foundation.text.input.internal.TransformedTextFieldState;
import androidx.compose.foundation.text.selection.SelectionManagerKt;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.AndroidMatrixConversions_androidKt;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.text.TextLayoutResult;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J8\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"J\b\u0010#\u001a\u00020\u001eH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006$"}, d2={"Landroidx/compose/foundation/text/input/internal/CursorAnchorInfoController;", "", "textFieldState", "Landroidx/compose/foundation/text/input/internal/TransformedTextFieldState;", "textLayoutState", "Landroidx/compose/foundation/text/input/internal/TextLayoutState;", "composeImm", "Landroidx/compose/foundation/text/input/internal/ComposeInputMethodManager;", "monitorScope", "Lkotlinx/coroutines/CoroutineScope;", "(Landroidx/compose/foundation/text/input/internal/TransformedTextFieldState;Landroidx/compose/foundation/text/input/internal/TextLayoutState;Landroidx/compose/foundation/text/input/internal/ComposeInputMethodManager;Lkotlinx/coroutines/CoroutineScope;)V", "androidMatrix", "Landroid/graphics/Matrix;", "builder", "Landroid/view/inputmethod/CursorAnchorInfo$Builder;", "hasPendingImmediateRequest", "", "includeCharacterBounds", "includeEditorBounds", "includeInsertionMarker", "includeLineBounds", "matrix", "Landroidx/compose/ui/graphics/Matrix;", "[F", "monitorEnabled", "monitorJob", "Lkotlinx/coroutines/Job;", "calculateCursorAnchorInfo", "Landroid/view/inputmethod/CursorAnchorInfo;", "requestUpdates", "", "immediate", "monitor", "cursorUpdateMode", "", "startOrStopMonitoring", "foundation_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCursorAnchorInfoController.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CursorAnchorInfoController.android.kt\nandroidx/compose/foundation/text/input/internal/CursorAnchorInfoController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,203:1\n1#2:204\n*E\n"})
public final class CursorAnchorInfoController {
    @NotNull
    private final TransformedTextFieldState textFieldState;
    @NotNull
    private final TextLayoutState textLayoutState;
    @NotNull
    private final ComposeInputMethodManager composeImm;
    @NotNull
    private final CoroutineScope monitorScope;
    private boolean monitorEnabled;
    private boolean hasPendingImmediateRequest;
    @Nullable
    private Job monitorJob;
    private boolean includeInsertionMarker;
    private boolean includeCharacterBounds;
    private boolean includeEditorBounds;
    private boolean includeLineBounds;
    @NotNull
    private final CursorAnchorInfo.Builder builder;
    @NotNull
    private final float[] matrix;
    @NotNull
    private final android.graphics.Matrix androidMatrix;
    public static final int $stable = 8;

    public CursorAnchorInfoController(@NotNull TransformedTextFieldState textFieldState, @NotNull TextLayoutState textLayoutState, @NotNull ComposeInputMethodManager composeImm2, @NotNull CoroutineScope monitorScope) {
        this.textFieldState = textFieldState;
        this.textLayoutState = textLayoutState;
        this.composeImm = composeImm2;
        this.monitorScope = monitorScope;
        this.builder = new CursorAnchorInfo.Builder();
        this.matrix = Matrix.constructor-impl$default(null, (int)1, null);
        this.androidMatrix = new android.graphics.Matrix();
    }

    public final void requestUpdates(int cursorUpdateMode) {
        boolean immediate = (cursorUpdateMode & 1) != 0;
        boolean monitor = (cursorUpdateMode & 2) != 0;
        boolean includeInsertionMarker = true;
        boolean includeCharacterBounds = true;
        boolean includeEditorBounds = false;
        boolean includeLineBounds = false;
        if (Build.VERSION.SDK_INT >= 33) {
            includeInsertionMarker = (cursorUpdateMode & 0x10) != 0;
            includeCharacterBounds = (cursorUpdateMode & 8) != 0;
            boolean bl = includeEditorBounds = (cursorUpdateMode & 4) != 0;
            if (Build.VERSION.SDK_INT >= 34) {
                boolean bl2 = includeLineBounds = (cursorUpdateMode & 0x20) != 0;
            }
            if (!(includeInsertionMarker || includeCharacterBounds || includeEditorBounds || includeLineBounds)) {
                includeInsertionMarker = true;
                includeCharacterBounds = true;
                includeEditorBounds = true;
                if (Build.VERSION.SDK_INT >= 34) {
                    includeLineBounds = true;
                }
            }
        }
        this.requestUpdates(immediate, monitor, includeInsertionMarker, includeCharacterBounds, includeEditorBounds, includeLineBounds);
    }

    private final void requestUpdates(boolean immediate, boolean monitor, boolean includeInsertionMarker, boolean includeCharacterBounds, boolean includeEditorBounds, boolean includeLineBounds) {
        this.includeInsertionMarker = includeInsertionMarker;
        this.includeCharacterBounds = includeCharacterBounds;
        this.includeEditorBounds = includeEditorBounds;
        this.includeLineBounds = includeLineBounds;
        if (immediate) {
            this.hasPendingImmediateRequest = true;
            CursorAnchorInfo cursorAnchorInfo = this.calculateCursorAnchorInfo();
            if (cursorAnchorInfo != null) {
                CursorAnchorInfo cursorAnchorInfo2 = cursorAnchorInfo;
                ComposeInputMethodManager composeInputMethodManager = this.composeImm;
                CursorAnchorInfo p0 = cursorAnchorInfo2;
                boolean bl = false;
                composeInputMethodManager.updateCursorAnchorInfo(p0);
            }
        }
        this.monitorEnabled = monitor;
        this.startOrStopMonitoring();
    }

    private final void startOrStopMonitoring() {
        if (this.monitorEnabled) {
            Job job = this.monitorJob;
            if (!(job != null ? job.isActive() : false)) {
                this.monitorJob = BuildersKt.launch$default((CoroutineScope)this.monitorScope, null, (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ CursorAnchorInfoController this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = FlowKt.filterNotNull((Flow)FlowKt.drop((Flow)SnapshotStateKt.snapshotFlow((Function0)((Function0)new Function0<CursorAnchorInfo>(this.this$0){
                                    final /* synthetic */ CursorAnchorInfoController this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(0);
                                    }

                                    @Nullable
                                    public final CursorAnchorInfo invoke() {
                                        return CursorAnchorInfoController.access$calculateCursorAnchorInfo(this.this$0);
                                    }
                                })), (int)1)).collect(new FlowCollector(this.this$0){
                                    final /* synthetic */ CursorAnchorInfoController this$0;
                                    {
                                        this.this$0 = $receiver;
                                    }

                                    @Nullable
                                    public final Object emit(@NotNull CursorAnchorInfo it, @NotNull Continuation<? super Unit> $completion) {
                                        CursorAnchorInfoController.access$getComposeImm$p(this.this$0).updateCursorAnchorInfo(it);
                                        return Unit.INSTANCE;
                                    }
                                }, (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
            }
        } else {
            Job job = this.monitorJob;
            if (job != null) {
                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
            }
            this.monitorJob = null;
        }
    }

    private final CursorAnchorInfo calculateCursorAnchorInfo() {
        LayoutCoordinates coreCoordinates;
        LayoutCoordinates layoutCoordinates;
        block10: {
            block9: {
                LayoutCoordinates layoutCoordinates2;
                LayoutCoordinates it;
                block8: {
                    block7: {
                        LayoutCoordinates layoutCoordinates3 = this.textLayoutState.getCoreNodeCoordinates();
                        if (layoutCoordinates3 == null) break block7;
                        it = layoutCoordinates = layoutCoordinates3;
                        boolean bl = false;
                        Object object = layoutCoordinates2 = it.isAttached() ? layoutCoordinates : null;
                        if (layoutCoordinates2 != null) break block8;
                    }
                    return null;
                }
                coreCoordinates = layoutCoordinates2;
                layoutCoordinates2 = this.textLayoutState.getDecoratorNodeCoordinates();
                if (layoutCoordinates2 == null) break block9;
                LayoutCoordinates it2 = it = layoutCoordinates2;
                boolean bl = false;
                Object object = layoutCoordinates = it2.isAttached() ? it : null;
                if (layoutCoordinates != null) break block10;
            }
            return null;
        }
        LayoutCoordinates decorationBoxCoordinates = layoutCoordinates;
        TextLayoutResult textLayoutResult = this.textLayoutState.getLayoutResult();
        if (textLayoutResult == null) {
            return null;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        TextFieldCharSequence text = this.textFieldState.getVisualText();
        Matrix.reset-impl((float[])this.matrix);
        coreCoordinates.transformToScreen-58bKbWc(this.matrix);
        AndroidMatrixConversions_androidKt.setFrom-EL8BTi8((android.graphics.Matrix)this.androidMatrix, (float[])this.matrix);
        Rect innerTextFieldBounds = SelectionManagerKt.visibleBounds(coreCoordinates);
        Rect decorationBoxBounds = coreCoordinates.localBoundingBoxOf(decorationBoxCoordinates, false);
        return CursorAnchorInfoBuilder_androidKt.build-vxqZcH0(this.builder, text, text.getSelection-d9O1mEE(), text.getComposition-MzsxiRA(), textLayoutResult2, this.androidMatrix, innerTextFieldBounds, decorationBoxBounds, this.includeInsertionMarker, this.includeCharacterBounds, this.includeEditorBounds, this.includeLineBounds);
    }

    public static final /* synthetic */ CursorAnchorInfo access$calculateCursorAnchorInfo(CursorAnchorInfoController $this) {
        return $this.calculateCursorAnchorInfo();
    }

    public static final /* synthetic */ ComposeInputMethodManager access$getComposeImm$p(CursorAnchorInfoController $this) {
        return $this.composeImm;
    }
}

