/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal;

import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import android.view.inputmethod.InputContentInfo;
import androidx.compose.foundation.text.input.TextFieldCharSequence;
import androidx.compose.foundation.text.input.TextFieldCharSequenceKt;
import androidx.compose.foundation.text.input.internal.Api25CommitContentImpl;
import androidx.compose.foundation.text.input.internal.EditCommandKt;
import androidx.compose.foundation.text.input.internal.EditingBuffer;
import androidx.compose.foundation.text.input.internal.StatelessInputConnection;
import androidx.compose.foundation.text.input.internal.StatelessInputConnection_androidKt;
import androidx.compose.foundation.text.input.internal.TextInputSession;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.input.ImeAction;
import androidx.core.view.inputmethod.InputConnectionCompat;
import androidx.core.view.inputmethod.InputContentInfoCompat;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0097\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b*\u0001\u0013\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J!\u0010\u0019\u001a\u00020\u00102\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\u0002\b\u0011H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\bH\u0016J\b\u0010 \u001a\u00020\u0010H\u0016J\u0012\u0010!\u001a\u00020\u001c2\b\u0010\u0015\u001a\u0004\u0018\u00010\"H\u0016J\"\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\b2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u0012\u0010)\u001a\u00020\u001c2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\u001a\u0010,\u001a\u00020\u001c2\b\u0010\u0015\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020\bH\u0016J\u0018\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\b2\u0006\u00101\u001a\u00020\bH\u0016J\u0018\u00102\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\b2\u0006\u00101\u001a\u00020\bH\u0016J\b\u00103\u001a\u00020\u001cH\u0016J\b\u00104\u001a\u00020\u001cH\u0002J\b\u00105\u001a\u00020\u001cH\u0016J\u0010\u00106\u001a\u00020\b2\u0006\u00107\u001a\u00020\bH\u0016J\u001a\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010&\u001a\u00020\bH\u0016J\n\u0010<\u001a\u0004\u0018\u00010=H\u0016J\u0012\u0010>\u001a\u0004\u0018\u00010-2\u0006\u0010&\u001a\u00020\bH\u0016J\u0018\u0010?\u001a\u00020-2\u0006\u0010@\u001a\u00020\b2\u0006\u0010&\u001a\u00020\bH\u0016J\u0018\u0010A\u001a\u00020-2\u0006\u0010@\u001a\u00020\b2\u0006\u0010&\u001a\u00020\bH\u0016J\u0010\u0010B\u001a\u00020\u00102\u0006\u0010C\u001a\u00020DH\u0002J\u0010\u0010E\u001a\u00020\u001c2\u0006\u0010F\u001a\u00020\bH\u0016J\u0010\u0010G\u001a\u00020\u001c2\u0006\u0010H\u001a\u00020\bH\u0016J\u001c\u0010I\u001a\u00020\u001c2\b\u0010J\u001a\u0004\u0018\u00010D2\b\u0010K\u001a\u0004\u0018\u00010(H\u0016J\u0010\u0010L\u001a\u00020\u001c2\u0006\u0010M\u001a\u00020\u001cH\u0016J\u0010\u0010N\u001a\u00020\u001c2\u0006\u0010O\u001a\u00020\bH\u0016J\u0010\u0010P\u001a\u00020\u001c2\u0006\u0010Q\u001a\u00020RH\u0016J\u0010\u0010S\u001a\u00020\u00102\u0006\u0010T\u001a\u00020\bH\u0002J\u0018\u0010U\u001a\u00020\u001c2\u0006\u0010V\u001a\u00020\b2\u0006\u0010W\u001a\u00020\bH\u0016J\u001a\u0010X\u001a\u00020\u001c2\b\u0010\u0015\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020\bH\u0016J\u0018\u0010Y\u001a\u00020\u001c2\u0006\u0010V\u001a\u00020\b2\u0006\u0010W\u001a\u00020\bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u000bR%\u0010\f\u001a\u0019\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\u0002\b\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006Z"}, d2={"Landroidx/compose/foundation/text/input/internal/StatelessInputConnection;", "Landroid/view/inputmethod/InputConnection;", "session", "Landroidx/compose/foundation/text/input/internal/TextInputSession;", "editorInfo", "Landroid/view/inputmethod/EditorInfo;", "(Landroidx/compose/foundation/text/input/internal/TextInputSession;Landroid/view/inputmethod/EditorInfo;)V", "batchDepth", "", "commitContentDelegateInputConnection", "getCommitContentDelegateInputConnection$annotations", "()V", "editCommands", "Landroidx/compose/runtime/collection/MutableVector;", "Lkotlin/Function1;", "Landroidx/compose/foundation/text/input/internal/EditingBuffer;", "", "Lkotlin/ExtensionFunctionType;", "terminalInputConnection", "androidx/compose/foundation/text/input/internal/StatelessInputConnection$terminalInputConnection$1", "Landroidx/compose/foundation/text/input/internal/StatelessInputConnection$terminalInputConnection$1;", "text", "Landroidx/compose/foundation/text/input/TextFieldCharSequence;", "getText", "()Landroidx/compose/foundation/text/input/TextFieldCharSequence;", "addEditCommandWithBatch", "editCommand", "beginBatchEdit", "", "beginBatchEditInternal", "clearMetaKeyStates", "states", "closeConnection", "commitCompletion", "Landroid/view/inputmethod/CompletionInfo;", "commitContent", "inputContentInfo", "Landroid/view/inputmethod/InputContentInfo;", "flags", "opts", "Landroid/os/Bundle;", "commitCorrection", "correctionInfo", "Landroid/view/inputmethod/CorrectionInfo;", "commitText", "", "newCursorPosition", "deleteSurroundingText", "beforeLength", "afterLength", "deleteSurroundingTextInCodePoints", "endBatchEdit", "endBatchEditInternal", "finishComposingText", "getCursorCapsMode", "reqModes", "getExtractedText", "Landroid/view/inputmethod/ExtractedText;", "request", "Landroid/view/inputmethod/ExtractedTextRequest;", "getHandler", "Landroid/os/Handler;", "getSelectedText", "getTextAfterCursor", "maxChars", "getTextBeforeCursor", "logDebug", "message", "", "performContextMenuAction", "id", "performEditorAction", "editorAction", "performPrivateCommand", "action", "data", "reportFullscreenMode", "enabled", "requestCursorUpdates", "cursorUpdateMode", "sendKeyEvent", "event", "Landroid/view/KeyEvent;", "sendSynthesizedKeyEvent", "code", "setComposingRegion", "start", "end", "setComposingText", "setSelection", "foundation_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nStatelessInputConnection.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatelessInputConnection.android.kt\nandroidx/compose/foundation/text/input/internal/StatelessInputConnection\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n*L\n1#1,522:1\n1208#2:523\n1187#2,2:524\n*S KotlinDebug\n*F\n+ 1 StatelessInputConnection.android.kt\nandroidx/compose/foundation/text/input/internal/StatelessInputConnection\n*L\n95#1:523\n95#1:524,2\n*E\n"})
public final class StatelessInputConnection
implements InputConnection {
    @NotNull
    private final TextInputSession session;
    private int batchDepth;
    @NotNull
    private final MutableVector<Function1<EditingBuffer, Unit>> editCommands;
    @NotNull
    private final terminalInputConnection.1 terminalInputConnection;
    @NotNull
    private final InputConnection commitContentDelegateInputConnection;
    public static final int $stable = 8;

    public StatelessInputConnection(@NotNull TextInputSession session, @NotNull EditorInfo editorInfo) {
        this.session = session;
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.editCommands = new MutableVector((Object[])new Function1[capacity$iv$iv], 0);
        this.terminalInputConnection = new InputConnectionWrapper(this){

            public boolean commitContent(@NotNull InputContentInfo inputContentInfo, int flags, @Nullable Bundle opts) {
                return false;
            }

            public boolean performPrivateCommand(@Nullable String action, @Nullable Bundle data) {
                return true;
            }
        };
        this.commitContentDelegateInputConnection = InputConnectionCompat.createWrapper((InputConnection)((InputConnection)this.terminalInputConnection), (EditorInfo)editorInfo, (InputConnectionCompat.OnCommitContentListener)new InputConnectionCompat.OnCommitContentListener(this){
            final /* synthetic */ StatelessInputConnection this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean onCommitContent(@NotNull InputContentInfoCompat inputContentInfo, int flags, @Nullable Bundle opts) {
                Bundle extras = opts;
                if (Build.VERSION.SDK_INT >= 25 && (flags & 1) != 0) {
                    try {
                        inputContentInfo.requestPermission();
                    }
                    catch (Exception e) {
                        StatelessInputConnection.access$logDebug(this.this$0, "Can't insert content from IME; requestPermission() failed, " + e);
                        return false;
                    }
                    Object object = inputContentInfo.unwrap();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.Parcelable");
                    Parcelable inputContentInfoFmk = (Parcelable)object;
                    extras = opts == null ? new Bundle() : new Bundle(opts);
                    extras.putParcelable("EXTRA_INPUT_CONTENT_INFO", inputContentInfoFmk);
                }
                return StatelessInputConnection.access$getSession$p(this.this$0).onCommitContent(StatelessInputConnection_androidKt.toTransferableContent(inputContentInfo, extras));
            }
        });
    }

    private final TextFieldCharSequence getText() {
        return this.session.getText();
    }

    private static /* synthetic */ void getCommitContentDelegateInputConnection$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addEditCommandWithBatch(Function1<? super EditingBuffer, Unit> editCommand) {
        this.beginBatchEditInternal();
        try {
            this.editCommands.add(editCommand);
        }
        finally {
            this.endBatchEditInternal();
        }
    }

    public boolean beginBatchEdit() {
        this.logDebug("beginBatchEdit()");
        return this.beginBatchEditInternal();
    }

    private final boolean beginBatchEditInternal() {
        int n = this.batchDepth;
        this.batchDepth = n + 1;
        return true;
    }

    public boolean endBatchEdit() {
        this.logDebug("endBatchEdit()");
        return this.endBatchEditInternal();
    }

    private final boolean endBatchEditInternal() {
        int n = this.batchDepth;
        this.batchDepth = n + -1;
        if (this.batchDepth == 0 && this.editCommands.isNotEmpty()) {
            this.session.requestEdit((Function1<? super EditingBuffer, Unit>)((Function1)new Function1<EditingBuffer, Unit>(this){
                final /* synthetic */ StatelessInputConnection this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull EditingBuffer $this$requestEdit) {
                    MutableVector this_$iv = StatelessInputConnection.access$getEditCommands$p(this.this$0);
                    boolean $i$f$forEach = false;
                    int size$iv = this_$iv.getSize();
                    if (size$iv > 0) {
                        int i$iv = 0;
                        Object[] content$iv = this_$iv.getContent();
                        do {
                            Function1 it = (Function1)content$iv[i$iv];
                            boolean bl = false;
                            it.invoke((Object)$this$requestEdit);
                        } while (++i$iv < size$iv);
                    }
                }
            }));
            this.editCommands.clear();
        }
        return this.batchDepth > 0;
    }

    public void closeConnection() {
        this.logDebug("closeConnection()");
        this.editCommands.clear();
        this.batchDepth = 0;
    }

    public boolean commitText(@Nullable CharSequence text, int newCursorPosition) {
        this.logDebug("commitText(\"" + text + "\", " + newCursorPosition + ')');
        this.addEditCommandWithBatch((Function1<? super EditingBuffer, Unit>)((Function1)new Function1<EditingBuffer, Unit>(text, newCursorPosition){
            final /* synthetic */ CharSequence $text;
            final /* synthetic */ int $newCursorPosition;
            {
                this.$text = $text;
                this.$newCursorPosition = $newCursorPosition;
                super(1);
            }

            public final void invoke(@NotNull EditingBuffer $this$addEditCommandWithBatch) {
                EditCommandKt.commitText($this$addEditCommandWithBatch, String.valueOf(this.$text), this.$newCursorPosition);
            }
        }));
        return true;
    }

    public boolean setComposingRegion(int start, int end) {
        this.logDebug("setComposingRegion(" + start + ", " + end + ')');
        this.addEditCommandWithBatch((Function1<? super EditingBuffer, Unit>)((Function1)new Function1<EditingBuffer, Unit>(start, end){
            final /* synthetic */ int $start;
            final /* synthetic */ int $end;
            {
                this.$start = $start;
                this.$end = $end;
                super(1);
            }

            public final void invoke(@NotNull EditingBuffer $this$addEditCommandWithBatch) {
                EditCommandKt.setComposingRegion($this$addEditCommandWithBatch, this.$start, this.$end);
            }
        }));
        return true;
    }

    public boolean setComposingText(@Nullable CharSequence text, int newCursorPosition) {
        this.logDebug("setComposingText(\"" + text + "\", " + newCursorPosition + ')');
        this.addEditCommandWithBatch((Function1<? super EditingBuffer, Unit>)((Function1)new Function1<EditingBuffer, Unit>(text, newCursorPosition){
            final /* synthetic */ CharSequence $text;
            final /* synthetic */ int $newCursorPosition;
            {
                this.$text = $text;
                this.$newCursorPosition = $newCursorPosition;
                super(1);
            }

            public final void invoke(@NotNull EditingBuffer $this$addEditCommandWithBatch) {
                EditCommandKt.setComposingText($this$addEditCommandWithBatch, String.valueOf(this.$text), this.$newCursorPosition);
            }
        }));
        return true;
    }

    public boolean deleteSurroundingTextInCodePoints(int beforeLength, int afterLength) {
        this.logDebug("deleteSurroundingTextInCodePoints(" + beforeLength + ", " + afterLength + ')');
        this.addEditCommandWithBatch((Function1<? super EditingBuffer, Unit>)((Function1)new Function1<EditingBuffer, Unit>(beforeLength, afterLength){
            final /* synthetic */ int $beforeLength;
            final /* synthetic */ int $afterLength;
            {
                this.$beforeLength = $beforeLength;
                this.$afterLength = $afterLength;
                super(1);
            }

            public final void invoke(@NotNull EditingBuffer $this$addEditCommandWithBatch) {
                EditCommandKt.deleteSurroundingTextInCodePoints($this$addEditCommandWithBatch, this.$beforeLength, this.$afterLength);
            }
        }));
        return true;
    }

    public boolean deleteSurroundingText(int beforeLength, int afterLength) {
        this.logDebug("deleteSurroundingText(" + beforeLength + ", " + afterLength + ')');
        this.addEditCommandWithBatch((Function1<? super EditingBuffer, Unit>)((Function1)new Function1<EditingBuffer, Unit>(beforeLength, afterLength){
            final /* synthetic */ int $beforeLength;
            final /* synthetic */ int $afterLength;
            {
                this.$beforeLength = $beforeLength;
                this.$afterLength = $afterLength;
                super(1);
            }

            public final void invoke(@NotNull EditingBuffer $this$addEditCommandWithBatch) {
                EditCommandKt.deleteSurroundingText($this$addEditCommandWithBatch, this.$beforeLength, this.$afterLength);
            }
        }));
        return true;
    }

    public boolean setSelection(int start, int end) {
        this.logDebug("setSelection(" + start + ", " + end + ')');
        this.addEditCommandWithBatch((Function1<? super EditingBuffer, Unit>)((Function1)new Function1<EditingBuffer, Unit>(start, end){
            final /* synthetic */ int $start;
            final /* synthetic */ int $end;
            {
                this.$start = $start;
                this.$end = $end;
                super(1);
            }

            public final void invoke(@NotNull EditingBuffer $this$addEditCommandWithBatch) {
                $this$addEditCommandWithBatch.setSelection(this.$start, this.$end);
            }
        }));
        return true;
    }

    public boolean finishComposingText() {
        this.logDebug("finishComposingText()");
        this.addEditCommandWithBatch((Function1<? super EditingBuffer, Unit>)((Function1)finishComposingText.1.INSTANCE));
        return true;
    }

    public boolean sendKeyEvent(@NotNull KeyEvent event) {
        this.logDebug("sendKeyEvent(" + event + ')');
        this.session.sendKeyEvent(event);
        return true;
    }

    @NotNull
    public CharSequence getTextBeforeCursor(int maxChars, int flags) {
        String result2 = ((Object)TextFieldCharSequenceKt.getTextBeforeSelection(this.getText(), maxChars)).toString();
        this.logDebug("getTextBeforeCursor(" + maxChars + ", " + flags + "): " + result2);
        return result2;
    }

    @NotNull
    public CharSequence getTextAfterCursor(int maxChars, int flags) {
        String result2 = ((Object)TextFieldCharSequenceKt.getTextAfterSelection(this.getText(), maxChars)).toString();
        this.logDebug("getTextAfterCursor(" + maxChars + ", " + flags + "): " + result2);
        return result2;
    }

    @Nullable
    public CharSequence getSelectedText(int flags) {
        CharSequence result2 = TextRange.getCollapsed-impl((long)this.getText().getSelection-d9O1mEE()) ? null : (CharSequence)((Object)TextFieldCharSequenceKt.getSelectedText(this.getText())).toString();
        this.logDebug("getSelectedText(" + flags + "): " + result2);
        return result2;
    }

    public boolean requestCursorUpdates(int cursorUpdateMode) {
        this.logDebug("requestCursorUpdates(" + cursorUpdateMode + ')');
        this.session.requestCursorUpdates(cursorUpdateMode);
        return true;
    }

    @NotNull
    public ExtractedText getExtractedText(@Nullable ExtractedTextRequest request2, int flags) {
        this.logDebug("getExtractedText(" + request2 + ", " + flags + ')');
        return StatelessInputConnection_androidKt.access$toExtractedText(this.getText());
    }

    public int getCursorCapsMode(int reqModes) {
        this.logDebug("getCursorCapsMode(" + reqModes + ')');
        return TextUtils.getCapsMode((CharSequence)this.getText(), (int)TextRange.getMin-impl((long)this.getText().getSelection-d9O1mEE()), (int)reqModes);
    }

    public boolean performContextMenuAction(int id) {
        this.logDebug("performContextMenuAction(" + id + ')');
        switch (id) {
            case 16908319: {
                this.addEditCommandWithBatch((Function1<? super EditingBuffer, Unit>)((Function1)new Function1<EditingBuffer, Unit>(this){
                    final /* synthetic */ StatelessInputConnection this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull EditingBuffer $this$addEditCommandWithBatch) {
                        $this$addEditCommandWithBatch.setSelection(0, StatelessInputConnection.access$getText(this.this$0).length());
                    }
                }));
                break;
            }
            case 0x1020020: {
                this.sendSynthesizedKeyEvent(277);
                break;
            }
            case 0x1020021: {
                this.sendSynthesizedKeyEvent(278);
                break;
            }
            case 0x1020022: {
                this.sendSynthesizedKeyEvent(279);
            }
        }
        return false;
    }

    private final void sendSynthesizedKeyEvent(int code) {
        this.sendKeyEvent(new KeyEvent(0, code));
        this.sendKeyEvent(new KeyEvent(1, code));
    }

    public boolean performEditorAction(int editorAction) {
        int n;
        this.logDebug("performEditorAction(" + editorAction + ')');
        switch (editorAction) {
            case 0: {
                n = ImeAction.Companion.getDefault-eUduSuo();
                break;
            }
            case 6: {
                n = ImeAction.Companion.getDone-eUduSuo();
                break;
            }
            case 4: {
                n = ImeAction.Companion.getSend-eUduSuo();
                break;
            }
            case 3: {
                n = ImeAction.Companion.getSearch-eUduSuo();
                break;
            }
            case 7: {
                n = ImeAction.Companion.getPrevious-eUduSuo();
                break;
            }
            case 5: {
                n = ImeAction.Companion.getNext-eUduSuo();
                break;
            }
            case 2: {
                n = ImeAction.Companion.getGo-eUduSuo();
                break;
            }
            default: {
                this.logDebug("IME sent an unrecognized editor action: " + editorAction);
                n = ImeAction.Companion.getDefault-eUduSuo();
            }
        }
        int imeAction = n;
        this.session.onImeAction-KlQnJC8(imeAction);
        return true;
    }

    public boolean commitCompletion(@Nullable CompletionInfo text) {
        CompletionInfo completionInfo = text;
        this.logDebug("commitCompletion(" + (completionInfo != null ? completionInfo.getText() : null) + ')');
        return false;
    }

    public boolean commitCorrection(@Nullable CorrectionInfo correctionInfo) {
        return true;
    }

    @Nullable
    public Handler getHandler() {
        this.logDebug("getHandler()");
        return null;
    }

    public boolean clearMetaKeyStates(int states) {
        this.logDebug("clearMetaKeyStates(" + states + ')');
        return false;
    }

    public boolean reportFullscreenMode(boolean enabled) {
        this.logDebug("reportFullscreenMode(" + enabled + ')');
        return false;
    }

    public boolean performPrivateCommand(@Nullable String action, @Nullable Bundle data) {
        this.logDebug("performPrivateCommand(" + action + ", " + data + ')');
        return this.commitContentDelegateInputConnection.performPrivateCommand(action, data);
    }

    public boolean commitContent(@NotNull InputContentInfo inputContentInfo, int flags, @Nullable Bundle opts) {
        this.logDebug("commitContent(" + inputContentInfo + ", " + flags + ", " + opts + ')');
        return Build.VERSION.SDK_INT >= 25 ? Api25CommitContentImpl.INSTANCE.commitContent(this.commitContentDelegateInputConnection, inputContentInfo, flags, opts) : false;
    }

    private final void logDebug(String message) {
    }

    public static final /* synthetic */ MutableVector access$getEditCommands$p(StatelessInputConnection $this) {
        return $this.editCommands;
    }

    public static final /* synthetic */ TextFieldCharSequence access$getText(StatelessInputConnection $this) {
        return $this.getText();
    }

    public static final /* synthetic */ void access$logDebug(StatelessInputConnection $this, String message) {
        $this.logDebug(message);
    }

    public static final /* synthetic */ TextInputSession access$getSession$p(StatelessInputConnection $this) {
        return $this.session;
    }
}

