/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal;

import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.EditorInfo;
import androidx.compose.foundation.text.LegacyTextFieldState;
import androidx.compose.foundation.text.input.internal.EditorInfo_androidKt;
import androidx.compose.foundation.text.input.internal.InputEventCallback2;
import androidx.compose.foundation.text.input.internal.InputMethodManager;
import androidx.compose.foundation.text.input.internal.LegacyCursorAnchorInfoController;
import androidx.compose.foundation.text.input.internal.LegacyPlatformTextInputServiceAdapter;
import androidx.compose.foundation.text.input.internal.LegacyPlatformTextInputServiceAdapter_androidKt;
import androidx.compose.foundation.text.input.internal.LegacyTextInputMethodRequest;
import androidx.compose.foundation.text.input.internal.RecordingInputConnection;
import androidx.compose.foundation.text.selection.TextFieldSelectionManager;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.platform.PlatformTextInputMethodRequest;
import androidx.compose.ui.platform.ViewConfiguration;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.ImeAction;
import androidx.compose.ui.text.input.ImeOptions;
import androidx.compose.ui.text.input.OffsetMapping;
import androidx.compose.ui.text.input.TextFieldValue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u00101\u001a\u00020\u001c2\u0006\u00102\u001a\u000203H\u0016J\u000e\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u000206J\b\u00107\u001a\u00020\u0007H\u0002JN\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u00020'2\b\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010\u001d\u001a\u00020\u001e2\u0018\u0010!\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\"\u0012\u0004\u0012\u00020\u00070\u00052\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00070\u0005J\u0018\u0010<\u001a\u00020\u00072\b\u0010=\u001a\u0004\u0018\u00010'2\u0006\u0010>\u001a\u00020'J.\u0010?\u001a\u00020\u00072\u0006\u0010@\u001a\u00020'2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u0002062\u0006\u0010F\u001a\u000206R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010!\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\"\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010(\u001a\u00020'2\u0006\u0010&\u001a\u00020'@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Landroidx/compose/foundation/text/input/internal/LegacyTextInputMethodRequest;", "Landroidx/compose/ui/platform/PlatformTextInputMethodRequest;", "view", "Landroid/view/View;", "localToScreen", "Lkotlin/Function1;", "Landroidx/compose/ui/graphics/Matrix;", "", "inputMethodManager", "Landroidx/compose/foundation/text/input/internal/InputMethodManager;", "(Landroid/view/View;Lkotlin/jvm/functions/Function1;Landroidx/compose/foundation/text/input/internal/InputMethodManager;)V", "baseInputConnection", "Landroid/view/inputmethod/BaseInputConnection;", "getBaseInputConnection", "()Landroid/view/inputmethod/BaseInputConnection;", "baseInputConnection$delegate", "Lkotlin/Lazy;", "cursorAnchorInfoController", "Landroidx/compose/foundation/text/input/internal/LegacyCursorAnchorInfoController;", "focusedRect", "Landroid/graphics/Rect;", "getFocusedRect$foundation_release", "()Landroid/graphics/Rect;", "setFocusedRect$foundation_release", "(Landroid/graphics/Rect;)V", "ics", "", "Ljava/lang/ref/WeakReference;", "Landroidx/compose/foundation/text/input/internal/RecordingInputConnection;", "imeOptions", "Landroidx/compose/ui/text/input/ImeOptions;", "legacyTextFieldState", "Landroidx/compose/foundation/text/LegacyTextFieldState;", "onEditCommand", "", "Landroidx/compose/ui/text/input/EditCommand;", "onImeActionPerformed", "Landroidx/compose/ui/text/input/ImeAction;", "<set-?>", "Landroidx/compose/ui/text/input/TextFieldValue;", "state", "getState", "()Landroidx/compose/ui/text/input/TextFieldValue;", "textFieldSelectionManager", "Landroidx/compose/foundation/text/selection/TextFieldSelectionManager;", "getView", "()Landroid/view/View;", "viewConfiguration", "Landroidx/compose/ui/platform/ViewConfiguration;", "createInputConnection", "outAttributes", "Landroid/view/inputmethod/EditorInfo;", "notifyFocusedRect", "rect", "Landroidx/compose/ui/geometry/Rect;", "restartInputImmediately", "startInput", "value", "textInputNode", "Landroidx/compose/foundation/text/input/internal/LegacyPlatformTextInputServiceAdapter$LegacyPlatformTextInputNode;", "updateState", "oldValue", "newValue", "updateTextLayoutResult", "textFieldValue", "offsetMapping", "Landroidx/compose/ui/text/input/OffsetMapping;", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "innerTextFieldBounds", "decorationBoxBounds", "foundation_release"})
@StabilityInferred(parameters=0)
public final class LegacyTextInputMethodRequest
implements PlatformTextInputMethodRequest {
    @NotNull
    private final View view;
    @NotNull
    private final InputMethodManager inputMethodManager;
    @NotNull
    private Function1<? super List<? extends EditCommand>, Unit> onEditCommand;
    @NotNull
    private Function1<? super ImeAction, Unit> onImeActionPerformed;
    @Nullable
    private LegacyTextFieldState legacyTextFieldState;
    @Nullable
    private TextFieldSelectionManager textFieldSelectionManager;
    @Nullable
    private ViewConfiguration viewConfiguration;
    @NotNull
    private TextFieldValue state;
    @NotNull
    private ImeOptions imeOptions;
    @NotNull
    private List<WeakReference<RecordingInputConnection>> ics;
    @NotNull
    private final Lazy baseInputConnection$delegate;
    @Nullable
    private android.graphics.Rect focusedRect;
    @NotNull
    private final LegacyCursorAnchorInfoController cursorAnchorInfoController;
    public static final int $stable = 8;

    public LegacyTextInputMethodRequest(@NotNull View view, @NotNull Function1<? super Matrix, Unit> localToScreen, @NotNull InputMethodManager inputMethodManager) {
        this.view = view;
        this.inputMethodManager = inputMethodManager;
        this.onEditCommand = onEditCommand.1.INSTANCE;
        this.onImeActionPerformed = onImeActionPerformed.1.INSTANCE;
        this.state = new TextFieldValue("", TextRange.Companion.getZero-d9O1mEE(), null, 4, null);
        this.imeOptions = ImeOptions.Companion.getDefault();
        this.ics = new ArrayList();
        this.baseInputConnection$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<BaseInputConnection>(this){
            final /* synthetic */ LegacyTextInputMethodRequest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final BaseInputConnection invoke() {
                return new BaseInputConnection(this.this$0.getView(), false);
            }
        }));
        this.cursorAnchorInfoController = new LegacyCursorAnchorInfoController(localToScreen, this.inputMethodManager);
    }

    @NotNull
    public final View getView() {
        return this.view;
    }

    @NotNull
    public final TextFieldValue getState() {
        return this.state;
    }

    private final BaseInputConnection getBaseInputConnection() {
        Lazy lazy = this.baseInputConnection$delegate;
        return (BaseInputConnection)lazy.getValue();
    }

    @Nullable
    public final android.graphics.Rect getFocusedRect$foundation_release() {
        return this.focusedRect;
    }

    public final void setFocusedRect$foundation_release(@Nullable android.graphics.Rect rect) {
        this.focusedRect = rect;
    }

    public final void startInput(@NotNull TextFieldValue value, @Nullable LegacyPlatformTextInputServiceAdapter.LegacyPlatformTextInputNode textInputNode, @NotNull ImeOptions imeOptions, @NotNull Function1<? super List<? extends EditCommand>, Unit> onEditCommand2, @NotNull Function1<? super ImeAction, Unit> onImeActionPerformed2) {
        this.state = value;
        this.imeOptions = imeOptions;
        this.onEditCommand = onEditCommand2;
        this.onImeActionPerformed = onImeActionPerformed2;
        LegacyPlatformTextInputServiceAdapter.LegacyPlatformTextInputNode legacyPlatformTextInputNode = textInputNode;
        this.legacyTextFieldState = legacyPlatformTextInputNode != null ? legacyPlatformTextInputNode.getLegacyTextFieldState() : null;
        LegacyPlatformTextInputServiceAdapter.LegacyPlatformTextInputNode legacyPlatformTextInputNode2 = textInputNode;
        this.textFieldSelectionManager = legacyPlatformTextInputNode2 != null ? legacyPlatformTextInputNode2.getTextFieldSelectionManager() : null;
        LegacyPlatformTextInputServiceAdapter.LegacyPlatformTextInputNode legacyPlatformTextInputNode3 = textInputNode;
        this.viewConfiguration = legacyPlatformTextInputNode3 != null ? legacyPlatformTextInputNode3.getViewConfiguration() : null;
    }

    @NotNull
    public RecordingInputConnection createInputConnection(@NotNull EditorInfo outAttributes) {
        EditorInfo_androidKt.update-pLxbY9I$default(outAttributes, this.state.getText(), this.state.getSelection-d9O1mEE(), this.imeOptions, null, 8, null);
        LegacyPlatformTextInputServiceAdapter_androidKt.access$updateWithEmojiCompat(outAttributes);
        Object object = this.state;
        boolean bl = this.imeOptions.getAutoCorrect();
        InputEventCallback2 inputEventCallback2 = new InputEventCallback2(this){
            final /* synthetic */ LegacyTextInputMethodRequest this$0;
            {
                this.this$0 = $receiver;
            }

            public void onEditCommands(@NotNull List<? extends EditCommand> editCommands) {
                LegacyTextInputMethodRequest.access$getOnEditCommand$p(this.this$0).invoke(editCommands);
            }

            public void onImeAction-KlQnJC8(int imeAction) {
                LegacyTextInputMethodRequest.access$getOnImeActionPerformed$p(this.this$0).invoke((Object)ImeAction.box-impl((int)imeAction));
            }

            public void onKeyEvent(@NotNull KeyEvent event) {
                LegacyTextInputMethodRequest.access$getBaseInputConnection(this.this$0).sendKeyEvent(event);
            }

            public void onRequestCursorAnchorInfo(boolean immediate, boolean monitor, boolean includeInsertionMarker, boolean includeCharacterBounds, boolean includeEditorBounds, boolean includeLineBounds) {
                LegacyTextInputMethodRequest.access$getCursorAnchorInfoController$p(this.this$0).requestUpdate(immediate, monitor, includeInsertionMarker, includeCharacterBounds, includeEditorBounds, includeLineBounds);
            }

            public void onConnectionClosed(@NotNull RecordingInputConnection inputConnection) {
                int n = LegacyTextInputMethodRequest.access$getIcs$p(this.this$0).size();
                for (int i = 0; i < n; ++i) {
                    if (!Intrinsics.areEqual(((WeakReference)LegacyTextInputMethodRequest.access$getIcs$p(this.this$0).get(i)).get(), (Object)inputConnection)) continue;
                    LegacyTextInputMethodRequest.access$getIcs$p(this.this$0).remove(i);
                    return;
                }
            }
        };
        LegacyTextFieldState legacyTextFieldState = this.legacyTextFieldState;
        TextFieldSelectionManager textFieldSelectionManager = this.textFieldSelectionManager;
        ViewConfiguration viewConfiguration = this.viewConfiguration;
        Object it = object = new RecordingInputConnection((TextFieldValue)object, inputEventCallback2, bl, legacyTextFieldState, textFieldSelectionManager, viewConfiguration);
        boolean bl2 = false;
        this.ics.add(new WeakReference<TextFieldValue>((TextFieldValue)it));
        return object;
    }

    public final void updateState(@Nullable TextFieldValue oldValue, @NotNull TextFieldValue newValue) {
        boolean bl;
        boolean needUpdateSelection = !TextRange.equals-impl0((long)this.state.getSelection-d9O1mEE(), (long)newValue.getSelection-d9O1mEE()) || !Intrinsics.areEqual((Object)this.state.getComposition-MzsxiRA(), (Object)newValue.getComposition-MzsxiRA());
        this.state = newValue;
        int n = this.ics.size();
        for (int i = 0; i < n; ++i) {
            RecordingInputConnection recordingInputConnection = (RecordingInputConnection)this.ics.get(i).get();
            if (recordingInputConnection == null) continue;
            recordingInputConnection.setTextFieldValue$foundation_release(newValue);
        }
        this.cursorAnchorInfoController.invalidate();
        if (Intrinsics.areEqual((Object)oldValue, (Object)newValue)) {
            if (needUpdateSelection) {
                TextRange textRange2 = this.state.getComposition-MzsxiRA();
                TextRange textRange3 = this.state.getComposition-MzsxiRA();
                this.inputMethodManager.updateSelection(TextRange.getMin-impl((long)newValue.getSelection-d9O1mEE()), TextRange.getMax-impl((long)newValue.getSelection-d9O1mEE()), textRange2 != null ? TextRange.getMin-impl((long)textRange2.unbox-impl()) : -1, textRange3 != null ? TextRange.getMax-impl((long)textRange3.unbox-impl()) : -1);
            }
            return;
        }
        TextFieldValue textFieldValue = oldValue;
        if (textFieldValue != null) {
            TextFieldValue it = textFieldValue;
            boolean bl2 = false;
            bl = !Intrinsics.areEqual((Object)it.getText(), (Object)newValue.getText()) || TextRange.equals-impl0((long)it.getSelection-d9O1mEE(), (long)newValue.getSelection-d9O1mEE()) && !Intrinsics.areEqual((Object)it.getComposition-MzsxiRA(), (Object)newValue.getComposition-MzsxiRA());
        } else {
            bl = false;
        }
        boolean restartInput2 = bl;
        if (restartInput2) {
            this.restartInputImmediately();
        } else {
            int n2 = this.ics.size();
            for (int i = 0; i < n2; ++i) {
                RecordingInputConnection recordingInputConnection = (RecordingInputConnection)this.ics.get(i).get();
                if (recordingInputConnection == null) continue;
                recordingInputConnection.updateInputState(this.state, this.inputMethodManager);
            }
        }
    }

    public final void notifyFocusedRect(@NotNull Rect rect) {
        block1: {
            this.focusedRect = new android.graphics.Rect(MathKt.roundToInt((float)rect.getLeft()), MathKt.roundToInt((float)rect.getTop()), MathKt.roundToInt((float)rect.getRight()), MathKt.roundToInt((float)rect.getBottom()));
            if (!this.ics.isEmpty()) break block1;
            android.graphics.Rect rect2 = this.focusedRect;
            if (rect2 != null) {
                android.graphics.Rect it = rect2;
                boolean bl = false;
                this.view.requestRectangleOnScreen(new android.graphics.Rect(it));
            }
        }
    }

    public final void updateTextLayoutResult(@NotNull TextFieldValue textFieldValue, @NotNull OffsetMapping offsetMapping, @NotNull TextLayoutResult textLayoutResult, @NotNull Rect innerTextFieldBounds, @NotNull Rect decorationBoxBounds) {
        this.cursorAnchorInfoController.updateTextLayoutResult(textFieldValue, offsetMapping, textLayoutResult, innerTextFieldBounds, decorationBoxBounds);
    }

    private final void restartInputImmediately() {
        this.inputMethodManager.restartInput();
    }

    public static final /* synthetic */ Function1 access$getOnEditCommand$p(LegacyTextInputMethodRequest $this) {
        return $this.onEditCommand;
    }

    public static final /* synthetic */ Function1 access$getOnImeActionPerformed$p(LegacyTextInputMethodRequest $this) {
        return $this.onImeActionPerformed;
    }

    public static final /* synthetic */ BaseInputConnection access$getBaseInputConnection(LegacyTextInputMethodRequest $this) {
        return $this.getBaseInputConnection();
    }

    public static final /* synthetic */ LegacyCursorAnchorInfoController access$getCursorAnchorInfoController$p(LegacyTextInputMethodRequest $this) {
        return $this.cursorAnchorInfoController;
    }

    public static final /* synthetic */ List access$getIcs$p(LegacyTextInputMethodRequest $this) {
        return $this.ics;
    }
}

