/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.annotation.FloatRange;
import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.SuspendAnimationKt;
import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.ScrollScope;
import androidx.compose.foundation.gestures.snapping.SnapPosition;
import androidx.compose.foundation.lazy.layout.LazyLayoutAnimateScrollScope;
import androidx.compose.foundation.pager.DefaultPagerState;
import androidx.compose.foundation.pager.PagerLayoutInfo;
import androidx.compose.foundation.pager.PagerMeasureResult;
import androidx.compose.foundation.pager.PagerState;
import androidx.compose.foundation.pager.PagerStateKt;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.saveable.RememberSaveableKt;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.ui.layout.AlignmentLine;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.IntSize;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000m\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\r\u001a(\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\n2\b\b\u0003\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0015\u001a\u0017\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0015H\u0082\b\u001a/\u0010\u001a\u001a\u00020\u00102\b\b\u0002\u0010\u001b\u001a\u00020\n2\b\b\u0003\u0010\u001c\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0015H\u0007\u00a2\u0006\u0002\u0010\u001d\u001aO\u0010\u001e\u001a\u00020\u0017*\u00020\u001f2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\u00132\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130#2\u001d\u0010$\u001a\u0019\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00170%\u00a2\u0006\u0002\b'H\u0082@\u00a2\u0006\u0002\u0010(\u001a\u0012\u0010)\u001a\u00020\u0017*\u00020\u0010H\u0080@\u00a2\u0006\u0002\u0010*\u001a\u0012\u0010+\u001a\u00020\u0017*\u00020\u0010H\u0080@\u00a2\u0006\u0002\u0010*\u001a\u0014\u0010,\u001a\u00020-*\u00020.2\u0006\u0010\u0014\u001a\u00020\nH\u0000\u001a\u0014\u0010/\u001a\u00020-*\u00020\u00062\u0006\u0010\u0014\u001a\u00020\nH\u0002\"\u0016\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0004\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u00060"}, d2={"DefaultPositionThreshold", "Landroidx/compose/ui/unit/Dp;", "getDefaultPositionThreshold", "()F", "F", "EmptyLayoutInfo", "Landroidx/compose/foundation/pager/PagerMeasureResult;", "getEmptyLayoutInfo", "()Landroidx/compose/foundation/pager/PagerMeasureResult;", "MaxPagesForAnimateScroll", "", "PagesToPrefetch", "UnitDensity", "androidx/compose/foundation/pager/PagerStateKt$UnitDensity$1", "Landroidx/compose/foundation/pager/PagerStateKt$UnitDensity$1;", "PagerState", "Landroidx/compose/foundation/pager/PagerState;", "currentPage", "currentPageOffsetFraction", "", "pageCount", "Lkotlin/Function0;", "debugLog", "", "generateMsg", "", "rememberPagerState", "initialPage", "initialPageOffsetFraction", "(IFLkotlin/jvm/functions/Function0;Landroidx/compose/runtime/Composer;II)Landroidx/compose/foundation/pager/PagerState;", "animateScrollToPage", "Landroidx/compose/foundation/lazy/layout/LazyLayoutAnimateScrollScope;", "targetPage", "targetPageOffsetToSnappedPosition", "animationSpec", "Landroidx/compose/animation/core/AnimationSpec;", "updateTargetPage", "Lkotlin/Function2;", "Landroidx/compose/foundation/gestures/ScrollScope;", "Lkotlin/ExtensionFunctionType;", "(Landroidx/compose/foundation/lazy/layout/LazyLayoutAnimateScrollScope;IFLandroidx/compose/animation/core/AnimationSpec;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "animateToNextPage", "(Landroidx/compose/foundation/pager/PagerState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "animateToPreviousPage", "calculateNewMaxScrollOffset", "", "Landroidx/compose/foundation/pager/PagerLayoutInfo;", "calculateNewMinScrollOffset", "foundation_release"})
@SourceDebugExtension(value={"SMAP\nPagerState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagerState.kt\nandroidx/compose/foundation/pager/PagerStateKt\n+ 2 Composer.kt\nandroidx/compose/runtime/ComposerKt\n+ 3 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,961:1\n868#1,4:968\n1220#2,6:962\n148#3:972\n*S KotlinDebug\n*F\n+ 1 PagerState.kt\nandroidx/compose/foundation/pager/PagerStateKt\n*L\n895#1:968,4\n88#1:962,6\n828#1:972\n*E\n"})
public final class PagerStateKt {
    private static final float DefaultPositionThreshold;
    private static final int MaxPagesForAnimateScroll = 3;
    public static final int PagesToPrefetch = 1;
    @NotNull
    private static final PagerMeasureResult EmptyLayoutInfo;
    @NotNull
    private static final UnitDensity.1 UnitDensity;

    /*
     * WARNING - void declaration
     */
    @Composable
    @NotNull
    public static final PagerState rememberPagerState(int initialPage, @FloatRange(from=-0.5, to=0.5) float initialPageOffsetFraction, @NotNull Function0<Integer> pageCount, @Nullable Composer $composer, int $changed, int n) {
        Object object;
        void $this$cache$iv;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)-1210768637, (String)"C(rememberPagerState)*87@3977L130,87@3927L180:PagerState.kt#g6yjnt");
        if ((n & 1) != 0) {
            initialPage = 0;
        }
        if ((n & 2) != 0) {
            initialPageOffsetFraction = 0.0f;
        }
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-1210768637, (int)$changed, (int)-1, (String)"androidx.compose.foundation.pager.rememberPagerState (PagerState.kt:86)");
        }
        Object[] objectArray = new Object[]{};
        Saver<DefaultPagerState, ?> saver2 = DefaultPagerState.Companion.getSaver();
        String string2 = null;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)17132194, (String)"CC(remember):PagerState.kt#9igjgp");
        Composer composer = $composer;
        boolean invalid$iv = (($changed & 0xE ^ 6) > 4 && $composer.changed(initialPage) || ($changed & 6) == 4) | (($changed & 0x70 ^ 0x30) > 32 && $composer.changed(initialPageOffsetFraction) || ($changed & 0x30) == 32) | (($changed & 0x380 ^ 0x180) > 256 && $composer.changed(pageCount) || ($changed & 0x180) == 256);
        boolean $i$f$cache = false;
        Object it$iv = $this$cache$iv.rememberedValue();
        boolean bl = false;
        if (invalid$iv || it$iv == Composer.Companion.getEmpty()) {
            String string3 = string2;
            Saver<DefaultPagerState, ?> saver3 = saver2;
            Object[] objectArray2 = objectArray;
            boolean bl2 = false;
            Function0 function0 = (Function0)new Function0<DefaultPagerState>(initialPage, initialPageOffsetFraction, pageCount){
                final /* synthetic */ int $initialPage;
                final /* synthetic */ float $initialPageOffsetFraction;
                final /* synthetic */ Function0<Integer> $pageCount;
                {
                    this.$initialPage = $initialPage;
                    this.$initialPageOffsetFraction = $initialPageOffsetFraction;
                    this.$pageCount = $pageCount;
                    super(0);
                }

                @NotNull
                public final DefaultPagerState invoke() {
                    return new DefaultPagerState(this.$initialPage, this.$initialPageOffsetFraction, this.$pageCount);
                }
            };
            objectArray = objectArray2;
            saver2 = saver3;
            string2 = string3;
            Function0 value$iv = function0;
            $this$cache$iv.updateRememberedValue((Object)value$iv);
            object = value$iv;
        } else {
            object = it$iv;
        }
        Object object2 = (Function0)object;
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        object2 = RememberSaveableKt.rememberSaveable((Object[])objectArray, saver2, string2, (Function0)object2, (Composer)$composer, (int)0, (int)4);
        DefaultPagerState $this$rememberPagerState_u24lambda_u241 = (DefaultPagerState)object2;
        boolean bl3 = false;
        $this$rememberPagerState_u24lambda_u241.getPageCountState().setValue(pageCount);
        DefaultPagerState defaultPagerState = (DefaultPagerState)object2;
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        return defaultPagerState;
    }

    @NotNull
    public static final PagerState PagerState(int currentPage, @FloatRange(from=-0.5, to=0.5) float currentPageOffsetFraction, @NotNull Function0<Integer> pageCount) {
        return new DefaultPagerState(currentPage, currentPageOffsetFraction, pageCount);
    }

    public static /* synthetic */ PagerState PagerState$default(int n, float f, Function0 function0, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            f = 0.0f;
        }
        return PagerStateKt.PagerState(n, f, (Function0<Integer>)function0);
    }

    @Nullable
    public static final Object animateToNextPage(@NotNull PagerState $this$animateToNextPage, @NotNull Continuation<? super Unit> $completion) {
        if ($this$animateToNextPage.getCurrentPage() + 1 < $this$animateToNextPage.getPageCount()) {
            Object object = PagerState.animateScrollToPage$default($this$animateToNextPage, $this$animateToNextPage.getCurrentPage() + 1, 0.0f, null, $completion, 6, null);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public static final Object animateToPreviousPage(@NotNull PagerState $this$animateToPreviousPage, @NotNull Continuation<? super Unit> $completion) {
        if ($this$animateToPreviousPage.getCurrentPage() - 1 >= 0) {
            Object object = PagerState.animateScrollToPage$default($this$animateToPreviousPage, $this$animateToPreviousPage.getCurrentPage() - 1, 0.0f, null, $completion, 6, null);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    public static final float getDefaultPositionThreshold() {
        return DefaultPositionThreshold;
    }

    @NotNull
    public static final PagerMeasureResult getEmptyLayoutInfo() {
        return EmptyLayoutInfo;
    }

    private static final void debugLog(Function0<String> generateMsg) {
        boolean $i$f$debugLog = false;
    }

    public static final long calculateNewMaxScrollOffset(@NotNull PagerLayoutInfo $this$calculateNewMaxScrollOffset, int pageCount) {
        int pageSizeWithSpacing = $this$calculateNewMaxScrollOffset.getPageSpacing() + $this$calculateNewMaxScrollOffset.getPageSize();
        long maxScrollPossible = (long)pageCount * (long)pageSizeWithSpacing + (long)$this$calculateNewMaxScrollOffset.getBeforeContentPadding() + (long)$this$calculateNewMaxScrollOffset.getAfterContentPadding();
        int layoutSize = $this$calculateNewMaxScrollOffset.getOrientation() == Orientation.Horizontal ? IntSize.getWidth-impl((long)$this$calculateNewMaxScrollOffset.getViewportSize-YbymL2g()) : IntSize.getHeight-impl((long)$this$calculateNewMaxScrollOffset.getViewportSize-YbymL2g());
        SnapPosition snapPosition = $this$calculateNewMaxScrollOffset.getSnapPosition();
        int n = $this$calculateNewMaxScrollOffset.getPageSize();
        int n2 = pageCount - 1;
        int n3 = $this$calculateNewMaxScrollOffset.getBeforeContentPadding();
        int n4 = $this$calculateNewMaxScrollOffset.getAfterContentPadding();
        int snapPositionDiscount = layoutSize - RangesKt.coerceIn((int)snapPosition.position(layoutSize, n, n3, n4, n2, pageCount), (int)0, (int)layoutSize);
        boolean $i$f$debugLog = false;
        return RangesKt.coerceAtLeast((long)(maxScrollPossible - (long)snapPositionDiscount), (long)0L);
    }

    private static final long calculateNewMinScrollOffset(PagerMeasureResult $this$calculateNewMinScrollOffset, int pageCount) {
        int layoutSize = $this$calculateNewMinScrollOffset.getOrientation() == Orientation.Horizontal ? IntSize.getWidth-impl((long)$this$calculateNewMinScrollOffset.getViewportSize-YbymL2g()) : IntSize.getHeight-impl((long)$this$calculateNewMinScrollOffset.getViewportSize-YbymL2g());
        SnapPosition snapPosition = $this$calculateNewMinScrollOffset.getSnapPosition();
        int n = $this$calculateNewMinScrollOffset.getPageSize();
        int n2 = $this$calculateNewMinScrollOffset.getBeforeContentPadding();
        int n3 = $this$calculateNewMinScrollOffset.getAfterContentPadding();
        return RangesKt.coerceIn((int)snapPosition.position(layoutSize, n, n2, n3, 0, pageCount), (int)0, (int)layoutSize);
    }

    private static final Object animateScrollToPage(LazyLayoutAnimateScrollScope $this$animateScrollToPage, int targetPage2, float targetPageOffsetToSnappedPosition, AnimationSpec<Float> animationSpec, Function2<? super ScrollScope, ? super Integer, Unit> updateTargetPage, Continuation<? super Unit> $completion) {
        Object object = $this$animateScrollToPage.scroll((Function2<? super ScrollScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<ScrollScope, Continuation<? super Unit>, Object>(updateTargetPage, targetPage2, $this$animateScrollToPage, targetPageOffsetToSnappedPosition, animationSpec, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Function2<ScrollScope, Integer, Unit> $updateTargetPage;
            final /* synthetic */ int $targetPage;
            final /* synthetic */ LazyLayoutAnimateScrollScope $this_animateScrollToPage;
            final /* synthetic */ float $targetPageOffsetToSnappedPosition;
            final /* synthetic */ AnimationSpec<Float> $animationSpec;
            {
                this.$updateTargetPage = $updateTargetPage;
                this.$targetPage = $targetPage;
                this.$this_animateScrollToPage = $receiver;
                this.$targetPageOffsetToSnappedPosition = $targetPageOffsetToSnappedPosition;
                this.$animationSpec = $animationSpec;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        boolean $i$f$debugLog;
                        ResultKt.throwOnFailure((Object)object);
                        ScrollScope $this$scroll = (ScrollScope)this.L$0;
                        this.$updateTargetPage.invoke((Object)$this$scroll, (Object)Boxing.boxInt((int)this.$targetPage));
                        boolean forward = this.$targetPage > this.$this_animateScrollToPage.getFirstVisibleItemIndex();
                        int visiblePages = this.$this_animateScrollToPage.getLastVisibleItemIndex() - this.$this_animateScrollToPage.getFirstVisibleItemIndex() + 1;
                        if ((forward && this.$targetPage > this.$this_animateScrollToPage.getLastVisibleItemIndex() || !forward && this.$targetPage < this.$this_animateScrollToPage.getFirstVisibleItemIndex()) && Math.abs(this.$targetPage - this.$this_animateScrollToPage.getFirstVisibleItemIndex()) >= 3) {
                            int preJumpPosition = forward ? RangesKt.coerceAtLeast((int)(this.$targetPage - visiblePages), (int)this.$this_animateScrollToPage.getFirstVisibleItemIndex()) : RangesKt.coerceAtMost((int)(this.$targetPage + visiblePages), (int)this.$this_animateScrollToPage.getFirstVisibleItemIndex());
                            $i$f$debugLog = false;
                            this.$this_animateScrollToPage.snapToItem($this$scroll, preJumpPosition, 0);
                        }
                        float displacement = this.$this_animateScrollToPage.calculateDistanceTo(this.$targetPage) + this.$targetPageOffsetToSnappedPosition;
                        $i$f$debugLog = false;
                        Ref.FloatRef previousValue = new Ref.FloatRef();
                        this.label = 1;
                        Object object3 = SuspendAnimationKt.animate$default((float)0.0f, (float)displacement, (float)0.0f, this.$animationSpec, (Function2)((Function2)new Function2<Float, Float, Unit>(previousValue, $this$scroll){
                            final /* synthetic */ Ref.FloatRef $previousValue;
                            final /* synthetic */ ScrollScope $$this$scroll;
                            {
                                this.$previousValue = $previousValue;
                                this.$$this$scroll = $$this$scroll;
                                super(2);
                            }

                            public final void invoke(float currentValue, float f) {
                                float delta = currentValue - this.$previousValue.element;
                                float consumed = this.$$this$scroll.scrollBy(delta);
                                boolean $i$f$debugLog = false;
                                this.$previousValue.element += consumed;
                            }
                        }), (Continuation)((Continuation)this), (int)4, null);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<ScrollScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull ScrollScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ UnitDensity.1 access$getUnitDensity$p() {
        return UnitDensity;
    }

    public static final /* synthetic */ Object access$animateScrollToPage(LazyLayoutAnimateScrollScope $receiver, int targetPage2, float targetPageOffsetToSnappedPosition, AnimationSpec animationSpec, Function2 updateTargetPage, Continuation $completion) {
        return PagerStateKt.animateScrollToPage($receiver, targetPage2, targetPageOffsetToSnappedPosition, (AnimationSpec<Float>)animationSpec, (Function2<? super ScrollScope, ? super Integer, Unit>)updateTargetPage, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ long access$calculateNewMinScrollOffset(PagerMeasureResult $receiver, int pageCount) {
        return PagerStateKt.calculateNewMinScrollOffset($receiver, pageCount);
    }

    static {
        int $this$dp$iv = 56;
        boolean $i$f$getDp = false;
        DefaultPositionThreshold = Dp.constructor-impl((float)$this$dp$iv);
        List list = CollectionsKt.emptyList();
        Orientation orientation = Orientation.Horizontal;
        SnapPosition.Start start = SnapPosition.Start.INSTANCE;
        MeasureResult measureResult2 = new MeasureResult(){
            private final int width;
            private final int height;
            @NotNull
            private final Map<AlignmentLine, Integer> alignmentLines;
            {
                this.alignmentLines = MapsKt.emptyMap();
            }

            public int getWidth() {
                return this.width;
            }

            public int getHeight() {
                return this.height;
            }

            @NotNull
            public Map<AlignmentLine, Integer> getAlignmentLines() {
                return this.alignmentLines;
            }

            public static /* synthetic */ void getAlignmentLines$annotations() {
            }

            public void placeChildren() {
            }
        };
        CoroutineScope coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)EmptyCoroutineContext.INSTANCE));
        EmptyLayoutInfo = new PagerMeasureResult(list, 0, 0, 0, orientation, 0, 0, false, 0, null, null, 0.0f, 0, false, start, measureResult2, false, null, null, coroutineScope, 393216, null);
        UnitDensity = new Density(){
            private final float density;
            private final float fontScale;
            {
                this.density = 1.0f;
                this.fontScale = 1.0f;
            }

            public float getDensity() {
                return this.density;
            }

            public float getFontScale() {
                return this.fontScale;
            }
        };
    }
}

