/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal;

import android.graphics.Matrix;
import android.os.Build;
import android.view.inputmethod.CursorAnchorInfo;
import androidx.compose.foundation.text.input.internal.CursorAnchorInfoApi33Helper;
import androidx.compose.foundation.text.input.internal.CursorAnchorInfoApi34Helper;
import androidx.compose.foundation.text.input.internal.LegacyCursorAnchorInfoBuilder_androidKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.unit.IntSize;
import kotlin.Metadata;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u001a,\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001ax\u0010\t\u001a\u00020\n*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u00142\b\b\u0002\u0010\u0017\u001a\u00020\u0014H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a$\u0010\u001a\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001c"}, d2={"addCharacterBounds", "Landroid/view/inputmethod/CursorAnchorInfo$Builder;", "startOffset", "", "endOffset", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "innerTextFieldBounds", "Landroidx/compose/ui/geometry/Rect;", "build", "Landroid/view/inputmethod/CursorAnchorInfo;", "text", "", "selection", "Landroidx/compose/ui/text/TextRange;", "composition", "matrix", "Landroid/graphics/Matrix;", "decorationBoxBounds", "includeInsertionMarker", "", "includeCharacterBounds", "includeEditorBounds", "includeLineBounds", "build-vxqZcH0", "(Landroid/view/inputmethod/CursorAnchorInfo$Builder;Ljava/lang/CharSequence;JLandroidx/compose/ui/text/TextRange;Landroidx/compose/ui/text/TextLayoutResult;Landroid/graphics/Matrix;Landroidx/compose/ui/geometry/Rect;Landroidx/compose/ui/geometry/Rect;ZZZZ)Landroid/view/inputmethod/CursorAnchorInfo;", "setInsertionMarker", "selectionStart", "foundation_release"})
public final class CursorAnchorInfoBuilder_androidKt {
    @NotNull
    public static final CursorAnchorInfo build-vxqZcH0(@NotNull CursorAnchorInfo.Builder $this$build_u2dvxqZcH0, @NotNull CharSequence text, long selection, @Nullable TextRange composition, @NotNull TextLayoutResult textLayoutResult, @NotNull Matrix matrix, @NotNull Rect innerTextFieldBounds, @NotNull Rect decorationBoxBounds, boolean includeInsertionMarker, boolean includeCharacterBounds, boolean includeEditorBounds, boolean includeLineBounds) {
        $this$build_u2dvxqZcH0.reset();
        $this$build_u2dvxqZcH0.setMatrix(matrix);
        int selectionStart = TextRange.getMin-impl((long)selection);
        int selectionEnd = TextRange.getMax-impl((long)selection);
        $this$build_u2dvxqZcH0.setSelectionRange(selectionStart, selectionEnd);
        if (includeInsertionMarker) {
            CursorAnchorInfoBuilder_androidKt.setInsertionMarker($this$build_u2dvxqZcH0, selectionStart, textLayoutResult, innerTextFieldBounds);
        }
        if (includeCharacterBounds) {
            int compositionEnd;
            TextRange textRange2 = composition;
            int compositionStart = textRange2 != null ? TextRange.getMin-impl((long)textRange2.unbox-impl()) : -1;
            TextRange textRange3 = composition;
            int n = compositionEnd = textRange3 != null ? TextRange.getMax-impl((long)textRange3.unbox-impl()) : -1;
            boolean bl = 0 <= compositionStart ? compositionStart < compositionEnd : false;
            if (bl) {
                $this$build_u2dvxqZcH0.setComposingText(compositionStart, text.subSequence(compositionStart, compositionEnd));
                CursorAnchorInfoBuilder_androidKt.addCharacterBounds($this$build_u2dvxqZcH0, compositionStart, compositionEnd, textLayoutResult, innerTextFieldBounds);
            }
        }
        if (Build.VERSION.SDK_INT >= 33 && includeEditorBounds) {
            CursorAnchorInfoApi33Helper.setEditorBoundsInfo($this$build_u2dvxqZcH0, decorationBoxBounds);
        }
        if (Build.VERSION.SDK_INT >= 34 && includeLineBounds) {
            CursorAnchorInfoApi34Helper.addVisibleLineBounds($this$build_u2dvxqZcH0, textLayoutResult, innerTextFieldBounds);
        }
        return $this$build_u2dvxqZcH0.build();
    }

    public static /* synthetic */ CursorAnchorInfo build-vxqZcH0$default(CursorAnchorInfo.Builder builder, CharSequence charSequence, long l, TextRange textRange2, TextLayoutResult textLayoutResult, Matrix matrix, Rect rect, Rect rect2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
        if ((n & 0x80) != 0) {
            bl = true;
        }
        if ((n & 0x100) != 0) {
            bl2 = true;
        }
        if ((n & 0x200) != 0) {
            bl3 = true;
        }
        if ((n & 0x400) != 0) {
            bl4 = true;
        }
        return CursorAnchorInfoBuilder_androidKt.build-vxqZcH0(builder, charSequence, l, textRange2, textLayoutResult, matrix, rect, rect2, bl, bl2, bl3, bl4);
    }

    private static final CursorAnchorInfo.Builder setInsertionMarker(CursorAnchorInfo.Builder $this$setInsertionMarker, int selectionStart, TextLayoutResult textLayoutResult, Rect innerTextFieldBounds) {
        if (selectionStart < 0) {
            return $this$setInsertionMarker;
        }
        Rect cursorRect = textLayoutResult.getCursorRect(selectionStart);
        float x = RangesKt.coerceIn((float)cursorRect.getLeft(), (float)0.0f, (float)IntSize.getWidth-impl((long)textLayoutResult.getSize-YbymL2g()));
        boolean isTopVisible = LegacyCursorAnchorInfoBuilder_androidKt.containsInclusive(innerTextFieldBounds, x, cursorRect.getTop());
        boolean isBottomVisible = LegacyCursorAnchorInfoBuilder_androidKt.containsInclusive(innerTextFieldBounds, x, cursorRect.getBottom());
        boolean isRtl = textLayoutResult.getBidiRunDirection(selectionStart) == ResolvedTextDirection.Rtl;
        int flags = 0;
        if (isTopVisible || isBottomVisible) {
            flags |= 1;
        }
        if (!isTopVisible || !isBottomVisible) {
            flags |= 2;
        }
        if (isRtl) {
            flags |= 4;
        }
        $this$setInsertionMarker.setInsertionMarkerLocation(x, cursorRect.getTop(), cursorRect.getBottom(), cursorRect.getBottom(), flags);
        return $this$setInsertionMarker;
    }

    private static final CursorAnchorInfo.Builder addCharacterBounds(CursorAnchorInfo.Builder $this$addCharacterBounds, int startOffset, int endOffset, TextLayoutResult textLayoutResult, Rect innerTextFieldBounds) {
        float[] array = new float[(endOffset - startOffset) * 4];
        textLayoutResult.getMultiParagraph().fillBoundingBoxes-8ffj60Q(TextRangeKt.TextRange((int)startOffset, (int)endOffset), array, 0);
        for (int offset = startOffset; offset < endOffset; ++offset) {
            int arrayIndex = 4 * (offset - startOffset);
            Rect rect = new Rect(array[arrayIndex], array[arrayIndex + 1], array[arrayIndex + 2], array[arrayIndex + 3]);
            int flags = 0;
            if (innerTextFieldBounds.overlaps(rect)) {
                flags |= 1;
            }
            if (!LegacyCursorAnchorInfoBuilder_androidKt.containsInclusive(innerTextFieldBounds, rect.getLeft(), rect.getTop()) || !LegacyCursorAnchorInfoBuilder_androidKt.containsInclusive(innerTextFieldBounds, rect.getRight(), rect.getBottom())) {
                flags |= 2;
            }
            if (textLayoutResult.getBidiRunDirection(offset) == ResolvedTextDirection.Rtl) {
                flags |= 4;
            }
            $this$addCharacterBounds.addCharacterBounds(offset, rect.getLeft(), rect.getTop(), rect.getRight(), rect.getBottom(), flags);
        }
        return $this$addCharacterBounds;
    }
}

