/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation;

import android.content.Context;
import android.os.Build;
import android.widget.EdgeEffect;
import androidx.compose.foundation.Api31Impl;
import androidx.compose.foundation.EdgeEffectCompat_androidKt;
import androidx.compose.foundation.GlowEdgeEffectCompat;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.unit.Density;
import kotlin.Metadata;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\"\u0010\u000b\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u00020\u0011*\u00020\u00052\u0006\u0010\f\u001a\u00020\u0012J\u001a\u0010\u0013\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004J\u0012\u0010\u0016\u001a\u00020\u0011*\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0004R\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Landroidx/compose/foundation/EdgeEffectCompat;", "", "()V", "distanceCompat", "", "Landroid/widget/EdgeEffect;", "getDistanceCompat", "(Landroid/widget/EdgeEffect;)F", "create", "context", "Landroid/content/Context;", "absorbToRelaxIfNeeded", "velocity", "edgeEffectLength", "density", "Landroidx/compose/ui/unit/Density;", "onAbsorbCompat", "", "", "onPullDistanceCompat", "deltaDistance", "displacement", "onReleaseWithOppositeDelta", "delta", "foundation_release"})
@StabilityInferred(parameters=1)
public final class EdgeEffectCompat {
    @NotNull
    public static final EdgeEffectCompat INSTANCE = new EdgeEffectCompat();
    public static final int $stable;

    private EdgeEffectCompat() {
    }

    @NotNull
    public final EdgeEffect create(@NotNull Context context) {
        return Build.VERSION.SDK_INT >= 31 ? Api31Impl.INSTANCE.create(context, null) : (EdgeEffect)new GlowEdgeEffectCompat(context);
    }

    public final float onPullDistanceCompat(@NotNull EdgeEffect $this$onPullDistanceCompat, float deltaDistance, float displacement) {
        if (Build.VERSION.SDK_INT >= 31) {
            return Api31Impl.INSTANCE.onPullDistance($this$onPullDistanceCompat, deltaDistance, displacement);
        }
        $this$onPullDistanceCompat.onPull(deltaDistance, displacement);
        return deltaDistance;
    }

    public final void onAbsorbCompat(@NotNull EdgeEffect $this$onAbsorbCompat, int velocity) {
        if (Build.VERSION.SDK_INT >= 31) {
            $this$onAbsorbCompat.onAbsorb(velocity);
            return;
        }
        if ($this$onAbsorbCompat.isFinished()) {
            $this$onAbsorbCompat.onAbsorb(velocity);
        }
    }

    public final float absorbToRelaxIfNeeded(@NotNull EdgeEffect $this$absorbToRelaxIfNeeded, float velocity, float edgeEffectLength, @NotNull Density density) {
        float f;
        float actualDistance;
        float flingDistance = EdgeEffectCompat_androidKt.access$flingDistance(density, velocity);
        if (flingDistance <= (actualDistance = this.getDistanceCompat($this$absorbToRelaxIfNeeded) * edgeEffectLength)) {
            this.onAbsorbCompat($this$absorbToRelaxIfNeeded, MathKt.roundToInt((float)velocity));
            f = velocity;
        } else {
            f = 0.0f;
        }
        return f;
    }

    public final void onReleaseWithOppositeDelta(@NotNull EdgeEffect $this$onReleaseWithOppositeDelta, float delta) {
        if ($this$onReleaseWithOppositeDelta instanceof GlowEdgeEffectCompat) {
            ((GlowEdgeEffectCompat)$this$onReleaseWithOppositeDelta).releaseWithOppositeDelta(delta);
        } else {
            $this$onReleaseWithOppositeDelta.onRelease();
        }
    }

    public final float getDistanceCompat(@NotNull EdgeEffect $this$distanceCompat) {
        return Build.VERSION.SDK_INT >= 31 ? Api31Impl.INSTANCE.getDistance($this$distanceCompat) : 0.0f;
    }
}

