/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.modifiers;

import androidx.compose.foundation.text.TextPointerIcon_androidKt;
import androidx.compose.foundation.text.modifiers.SelectionControllerKt;
import androidx.compose.foundation.text.modifiers.StaticTextSelectionParams;
import androidx.compose.foundation.text.selection.MultiWidgetSelectionDelegate;
import androidx.compose.foundation.text.selection.Selectable;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionRegistrar;
import androidx.compose.runtime.RememberObserver;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.graphics.ClipOp;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.drawscope.DrawContext;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawTransform;
import androidx.compose.ui.input.pointer.PointerIcon;
import androidx.compose.ui.input.pointer.PointerIconKt;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.text.TextLayoutResult;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0016J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eR\u0016\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001f"}, d2={"Landroidx/compose/foundation/text/modifiers/SelectionController;", "Landroidx/compose/runtime/RememberObserver;", "selectableId", "", "selectionRegistrar", "Landroidx/compose/foundation/text/selection/SelectionRegistrar;", "backgroundSelectionColor", "Landroidx/compose/ui/graphics/Color;", "params", "Landroidx/compose/foundation/text/modifiers/StaticTextSelectionParams;", "(JLandroidx/compose/foundation/text/selection/SelectionRegistrar;JLandroidx/compose/foundation/text/modifiers/StaticTextSelectionParams;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "modifier", "Landroidx/compose/ui/Modifier;", "getModifier", "()Landroidx/compose/ui/Modifier;", "selectable", "Landroidx/compose/foundation/text/selection/Selectable;", "draw", "", "drawScope", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "onAbandoned", "onForgotten", "onRemembered", "updateGlobalPosition", "coordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "updateTextLayout", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "foundation_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSelectionController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionController.kt\nandroidx/compose/foundation/text/modifiers/SelectionController\n+ 2 DrawScope.kt\nandroidx/compose/ui/graphics/drawscope/DrawScopeKt\n+ 3 Size.kt\nandroidx/compose/ui/geometry/Size\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 5 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n*L\n1#1,349:1\n202#2,4:350\n206#2:357\n207#2,3:360\n249#2,14:363\n57#3:354\n61#3:358\n60#4:355\n70#4:359\n22#5:356\n*S KotlinDebug\n*F\n+ 1 SelectionController.kt\nandroidx/compose/foundation/text/modifiers/SelectionController\n*L\n159#1:350,4\n159#1:357\n159#1:360,3\n159#1:363,14\n159#1:354\n159#1:358\n159#1:355\n159#1:359\n159#1:356\n*E\n"})
public final class SelectionController
implements RememberObserver {
    private final long selectableId;
    @NotNull
    private final SelectionRegistrar selectionRegistrar;
    private final long backgroundSelectionColor;
    @NotNull
    private StaticTextSelectionParams params;
    @Nullable
    private Selectable selectable;
    @NotNull
    private final Modifier modifier;
    public static final int $stable = 8;

    private SelectionController(long selectableId2, SelectionRegistrar selectionRegistrar, long backgroundSelectionColor, StaticTextSelectionParams params) {
        this.selectableId = selectableId2;
        this.selectionRegistrar = selectionRegistrar;
        this.backgroundSelectionColor = backgroundSelectionColor;
        this.params = params;
        this.modifier = PointerIconKt.pointerHoverIcon$default((Modifier)SelectionControllerKt.access$makeSelectionModifier(this.selectionRegistrar, this.selectableId, (Function0)new Function0<LayoutCoordinates>(this){
            final /* synthetic */ SelectionController this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final LayoutCoordinates invoke() {
                return SelectionController.access$getParams$p(this.this$0).getLayoutCoordinates();
            }
        }), (PointerIcon)TextPointerIcon_androidKt.getTextPointerIcon(), (boolean)false, (int)2, null);
    }

    public /* synthetic */ SelectionController(long l, SelectionRegistrar selectionRegistrar, long l2, StaticTextSelectionParams staticTextSelectionParams, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            staticTextSelectionParams = StaticTextSelectionParams.Companion.getEmpty();
        }
        this(l, selectionRegistrar, l2, staticTextSelectionParams, null);
    }

    @NotNull
    public final Modifier getModifier() {
        return this.modifier;
    }

    public void onRemembered() {
        this.selectable = this.selectionRegistrar.subscribe(new MultiWidgetSelectionDelegate(this.selectableId, (Function0<? extends LayoutCoordinates>)((Function0)new Function0<LayoutCoordinates>(this){
            final /* synthetic */ SelectionController this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final LayoutCoordinates invoke() {
                return SelectionController.access$getParams$p(this.this$0).getLayoutCoordinates();
            }
        }), (Function0<TextLayoutResult>)((Function0)new Function0<TextLayoutResult>(this){
            final /* synthetic */ SelectionController this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final TextLayoutResult invoke() {
                return SelectionController.access$getParams$p(this.this$0).getTextLayoutResult();
            }
        })));
    }

    public void onForgotten() {
        Selectable localSelectable = this.selectable;
        if (localSelectable != null) {
            this.selectionRegistrar.unsubscribe(localSelectable);
            this.selectable = null;
        }
    }

    public void onAbandoned() {
        Selectable localSelectable = this.selectable;
        if (localSelectable != null) {
            this.selectionRegistrar.unsubscribe(localSelectable);
            this.selectable = null;
        }
    }

    public final void updateTextLayout(@NotNull TextLayoutResult textLayoutResult) {
        TextLayoutResult prevTextLayoutResult = this.params.getTextLayoutResult();
        if (prevTextLayoutResult != null && !Intrinsics.areEqual((Object)prevTextLayoutResult.getLayoutInput().getText(), (Object)textLayoutResult.getLayoutInput().getText())) {
            this.selectionRegistrar.notifySelectableChange(this.selectableId);
        }
        this.params = StaticTextSelectionParams.copy$default(this.params, null, textLayoutResult, 1, null);
    }

    public final void updateGlobalPosition(@NotNull LayoutCoordinates coordinates) {
        this.params = StaticTextSelectionParams.copy$default(this.params, coordinates, null, 2, null);
        this.selectionRegistrar.notifyPositionChange(this.selectableId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void draw(@NotNull DrawScope drawScope) {
        int end;
        Selection selection = (Selection)this.selectionRegistrar.getSubselections().get(this.selectableId);
        if (selection == null) {
            return;
        }
        Selection selection2 = selection;
        int start = !selection2.getHandlesCrossed() ? selection2.getStart().getOffset() : selection2.getEnd().getOffset();
        int n = end = !selection2.getHandlesCrossed() ? selection2.getEnd().getOffset() : selection2.getStart().getOffset();
        if (start == end) {
            return;
        }
        Selectable selectable2 = this.selectable;
        int lastOffset = selectable2 != null ? selectable2.getLastVisibleOffset() : 0;
        int clippedStart = RangesKt.coerceAtMost((int)start, (int)lastOffset);
        int clippedEnd = RangesKt.coerceAtMost((int)end, (int)lastOffset);
        Path path = this.params.getPathForRange(clippedStart, clippedEnd);
        if (path == null) {
            return;
        }
        Path selectionPath = path;
        DrawScope $this$draw_u24lambda_u241 = drawScope;
        boolean bl = false;
        if (this.params.getShouldClip()) {
            DrawScope $this$clipRect_u2drOu3jXo_u24default$iv = $this$draw_u24lambda_u241;
            float left$iv = 0.0f;
            float top$iv = 0.0f;
            long arg0$iv$iv = $this$clipRect_u2drOu3jXo_u24default$iv.getSize-NH-jbRc();
            boolean bl2 = false;
            long value$iv$iv$iv = arg0$iv$iv;
            boolean $i$f$unpackFloat1 = false;
            int bits$iv$iv$iv$iv = (int)(value$iv$iv$iv >> 32);
            boolean $i$f$floatFromBits = false;
            float right$iv = Float.intBitsToFloat(bits$iv$iv$iv$iv);
            arg0$iv$iv = $this$clipRect_u2drOu3jXo_u24default$iv.getSize-NH-jbRc();
            boolean bl3 = false;
            value$iv$iv$iv = arg0$iv$iv;
            boolean $i$f$unpackFloat2 = false;
            bits$iv$iv$iv$iv = (int)(value$iv$iv$iv & 0xFFFFFFFFL);
            $i$f$floatFromBits = false;
            float bottom$iv = Float.intBitsToFloat(bits$iv$iv$iv$iv);
            int clipOp$iv = ClipOp.Companion.getIntersect-rtfAjoo();
            boolean bl4 = false;
            DrawScope $this$withTransform$iv$iv = $this$clipRect_u2drOu3jXo_u24default$iv;
            boolean $i$f$withTransform = false;
            DrawContext $this$withTransform_u24lambda_u246$iv$iv = $this$withTransform$iv$iv.getDrawContext();
            boolean bl5 = false;
            long previousSize$iv$iv = $this$withTransform_u24lambda_u246$iv$iv.getSize-NH-jbRc();
            $this$withTransform_u24lambda_u246$iv$iv.getCanvas().save();
            try {
                DrawTransform $this$clipRect_rOu3jXo_u24lambda_u244$iv = $this$withTransform_u24lambda_u246$iv$iv.getTransform();
                boolean bl6 = false;
                $this$clipRect_rOu3jXo_u24lambda_u244$iv.clipRect-N_I0leg(left$iv, top$iv, right$iv, bottom$iv, clipOp$iv);
                DrawScope $this$draw_u24lambda_u241_u24lambda_u240 = $this$withTransform$iv$iv;
                boolean bl7 = false;
                DrawScope.drawPath-LG529CI$default((DrawScope)$this$draw_u24lambda_u241_u24lambda_u240, (Path)selectionPath, (long)this.backgroundSelectionColor, (float)0.0f, null, null, (int)0, (int)60, null);
            }
            finally {
                $this$withTransform_u24lambda_u246$iv$iv.getCanvas().restore();
                $this$withTransform_u24lambda_u246$iv$iv.setSize-uvyYCjk(previousSize$iv$iv);
            }
        } else {
            DrawScope.drawPath-LG529CI$default((DrawScope)$this$draw_u24lambda_u241, (Path)selectionPath, (long)this.backgroundSelectionColor, (float)0.0f, null, null, (int)0, (int)60, null);
        }
    }

    public /* synthetic */ SelectionController(long selectableId2, SelectionRegistrar selectionRegistrar, long backgroundSelectionColor, StaticTextSelectionParams params, DefaultConstructorMarker $constructor_marker) {
        this(selectableId2, selectionRegistrar, backgroundSelectionColor, params);
    }

    public static final /* synthetic */ StaticTextSelectionParams access$getParams$p(SelectionController $this) {
        return $this.params;
    }
}

