/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.grid;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.ScrollScope;
import androidx.compose.foundation.lazy.grid.LazyGridItemInfo;
import androidx.compose.foundation.lazy.grid.LazyGridLayoutInfo;
import androidx.compose.foundation.lazy.grid.LazyGridState;
import androidx.compose.foundation.lazy.layout.LazyLayoutScrollScope;
import androidx.compose.ui.unit.IntOffset;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"LazyLayoutScrollScope", "Landroidx/compose/foundation/lazy/layout/LazyLayoutScrollScope;", "state", "Landroidx/compose/foundation/lazy/grid/LazyGridState;", "scrollScope", "Landroidx/compose/foundation/gestures/ScrollScope;", "foundation_release"})
public final class LazyGridScrollScopeKt {
    @NotNull
    public static final LazyLayoutScrollScope LazyLayoutScrollScope(@NotNull LazyGridState state, @NotNull ScrollScope scrollScope2) {
        return new LazyLayoutScrollScope(scrollScope2, state){
            private final /* synthetic */ ScrollScope $$delegate_0;
            final /* synthetic */ LazyGridState $state;
            {
                this.$state = $state;
                this.$$delegate_0 = $scrollScope;
            }

            public float scrollBy(float pixels) {
                return this.$$delegate_0.scrollBy(pixels);
            }

            public int getFirstVisibleItemIndex() {
                return this.$state.getFirstVisibleItemIndex();
            }

            public int getFirstVisibleItemScrollOffset() {
                return this.$state.getFirstVisibleItemScrollOffset();
            }

            public int getLastVisibleItemIndex() {
                LazyGridItemInfo lazyGridItemInfo = (LazyGridItemInfo)CollectionsKt.lastOrNull(this.$state.getLayoutInfo().getVisibleItemsInfo());
                return lazyGridItemInfo != null ? lazyGridItemInfo.getIndex() : 0;
            }

            public int getItemCount() {
                return this.$state.getLayoutInfo().getTotalItemsCount();
            }

            public void snapToItem(int index2, int offset) {
                this.$state.snapToItemIndexInternal$foundation_release(index2, offset, true);
            }

            public int calculateDistanceTo(int targetIndex, int targetOffset) {
                int n;
                LazyGridLayoutInfo layoutInfo = this.$state.getLayoutInfo();
                if (layoutInfo.getVisibleItemsInfo().isEmpty()) {
                    return 0;
                }
                int n2 = this.getFirstVisibleItemIndex();
                if (!(targetIndex <= this.getLastVisibleItemIndex() ? n2 <= targetIndex : false)) {
                    int slotsPerLine = this.$state.getSlotsPerLine$foundation_release();
                    int averageLineMainAxisSize = this.calculateLineAverageMainAxisSize(layoutInfo);
                    boolean before = targetIndex < this.getFirstVisibleItemIndex();
                    int linesDiff = (targetIndex - this.getFirstVisibleItemIndex() + (slotsPerLine - 1) * (before ? -1 : 1)) / slotsPerLine;
                    n = averageLineMainAxisSize * linesDiff - this.getFirstVisibleItemScrollOffset();
                } else {
                    Integer n3;
                    LazyGridItemInfo lazyGridItemInfo;
                    block6: {
                        List<LazyGridItemInfo> $this$fastFirstOrNull$iv = layoutInfo.getVisibleItemsInfo();
                        boolean $i$f$fastFirstOrNull = false;
                        List<LazyGridItemInfo> $this$fastForEach$iv$iv = $this$fastFirstOrNull$iv;
                        boolean $i$f$fastForEach = false;
                        int n4 = ((Collection)$this$fastForEach$iv$iv).size();
                        for (int index$iv$iv = 0; index$iv$iv < n4; ++index$iv$iv) {
                            LazyGridItemInfo item$iv$iv;
                            LazyGridItemInfo it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                            boolean bl = false;
                            LazyGridItemInfo it = it$iv;
                            boolean bl2 = false;
                            if (!(it.getIndex() == targetIndex)) continue;
                            lazyGridItemInfo = it$iv;
                            break block6;
                        }
                        lazyGridItemInfo = null;
                    }
                    LazyGridItemInfo visibleItem = lazyGridItemInfo;
                    if (layoutInfo.getOrientation() == Orientation.Vertical) {
                        LazyGridItemInfo lazyGridItemInfo2 = visibleItem;
                        n3 = lazyGridItemInfo2 != null ? Integer.valueOf(IntOffset.getY-impl((long)lazyGridItemInfo2.getOffset-nOcc-ac())) : null;
                    } else {
                        LazyGridItemInfo lazyGridItemInfo3 = visibleItem;
                        n3 = lazyGridItemInfo3 != null ? Integer.valueOf(IntOffset.getX-impl((long)lazyGridItemInfo3.getOffset-nOcc-ac())) : null;
                    }
                    n = n3 != null ? n3 : 0;
                }
                return n + targetOffset;
            }

            private final int calculateLineAverageMainAxisSize(LazyGridLayoutInfo layoutInfo) {
                boolean isVertical = layoutInfo.getOrientation() == Orientation.Vertical;
                List<LazyGridItemInfo> visibleItems = layoutInfo.getVisibleItemsInfo();
                Function1 lineOf2 = (Function1)new Function1<Integer, Integer>(isVertical, visibleItems){
                    final /* synthetic */ boolean $isVertical;
                    final /* synthetic */ List<LazyGridItemInfo> $visibleItems;
                    {
                        this.$isVertical = $isVertical;
                        this.$visibleItems = $visibleItems;
                        super(1);
                    }

                    public final Integer invoke(int it) {
                        return this.$isVertical ? this.$visibleItems.get(it).getRow() : this.$visibleItems.get(it).getColumn();
                    }
                };
                int totalLinesMainAxisSize = 0;
                int linesCount = 0;
                int lineStartIndex = 0;
                while (lineStartIndex < visibleItems.size()) {
                    int lineEndIndex;
                    int currentLine = ((Number)lineOf2.invoke((Object)lineStartIndex)).intValue();
                    if (currentLine == -1) {
                        ++lineStartIndex;
                        continue;
                    }
                    int lineMainAxisSize = 0;
                    for (lineEndIndex = lineStartIndex; lineEndIndex < visibleItems.size() && ((Number)lineOf2.invoke((Object)lineEndIndex)).intValue() == currentLine; ++lineEndIndex) {
                        int n;
                        long value$iv$iv;
                        if (isVertical) {
                            long arg0$iv = visibleItems.get(lineEndIndex).getSize-YbymL2g();
                            boolean bl = false;
                            value$iv$iv = arg0$iv;
                            boolean $i$f$unpackInt2 = false;
                            n = (int)(value$iv$iv & 0xFFFFFFFFL);
                        } else {
                            long arg0$iv = visibleItems.get(lineEndIndex).getSize-YbymL2g();
                            boolean bl = false;
                            value$iv$iv = arg0$iv;
                            boolean $i$f$unpackInt1 = false;
                            n = (int)(value$iv$iv >> 32);
                        }
                        int n2 = n;
                        lineMainAxisSize = Math.max(lineMainAxisSize, n2);
                    }
                    totalLinesMainAxisSize += lineMainAxisSize;
                    ++linesCount;
                    lineStartIndex = lineEndIndex;
                }
                return totalLinesMainAxisSize / linesCount + layoutInfo.getMainAxisItemSpacing();
            }
        };
    }
}

