/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.layout;

import android.view.Choreographer;
import android.view.Display;
import android.view.View;
import androidx.compose.foundation.ExperimentalFoundationApi;
import androidx.compose.foundation.lazy.layout.PrefetchRequest;
import androidx.compose.foundation.lazy.layout.PrefetchRequestScope;
import androidx.compose.foundation.lazy.layout.PrefetchScheduler;
import androidx.compose.runtime.RememberObserver;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b\u0001\u0018\u0000 \u001c2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0002\u001c\u001dB\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0011H\u0016R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroidx/compose/foundation/lazy/layout/AndroidPrefetchScheduler;", "Landroidx/compose/foundation/lazy/layout/PrefetchScheduler;", "Landroidx/compose/runtime/RememberObserver;", "Ljava/lang/Runnable;", "Landroid/view/Choreographer$FrameCallback;", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "choreographer", "Landroid/view/Choreographer;", "kotlin.jvm.PlatformType", "frameStartTimeNanos", "", "isActive", "", "prefetchRequests", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/foundation/lazy/layout/PrefetchRequest;", "prefetchScheduled", "doFrame", "", "frameTimeNanos", "onAbandoned", "onForgotten", "onRemembered", "run", "schedulePrefetch", "prefetchRequest", "Companion", "PrefetchRequestScopeImpl", "foundation_release"})
@ExperimentalFoundationApi
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPrefetchScheduler.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrefetchScheduler.android.kt\nandroidx/compose/foundation/lazy/layout/AndroidPrefetchScheduler\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,220:1\n1147#2:221\n1129#2,2:222\n542#3:224\n545#3:225\n489#3:226\n1#4:227\n*S KotlinDebug\n*F\n+ 1 PrefetchScheduler.android.kt\nandroidx/compose/foundation/lazy/layout/AndroidPrefetchScheduler\n*L\n88#1:221\n88#1:222,2\n107#1:224\n119#1:225\n121#1:226\n*E\n"})
public final class AndroidPrefetchScheduler
implements PrefetchScheduler,
RememberObserver,
Runnable,
Choreographer.FrameCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final View view;
    @NotNull
    private final MutableVector<PrefetchRequest> prefetchRequests;
    private boolean prefetchScheduled;
    private final Choreographer choreographer;
    private boolean isActive;
    private long frameStartTimeNanos;
    public static final int $stable = 8;
    private static long frameIntervalNs;

    public AndroidPrefetchScheduler(@NotNull View view) {
        this.view = view;
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.prefetchRequests = new MutableVector((Object[])new PrefetchRequest[capacity$iv$iv], 0);
        this.choreographer = Choreographer.getInstance();
        AndroidPrefetchScheduler.Companion.calculateFrameIntervalIfNeeded(this.view);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        MutableVector<PrefetchRequest> this_$iv = this.prefetchRequests;
        boolean $i$f$isEmpty = false;
        if (this_$iv.getSize() == 0 || !this.prefetchScheduled || !this.isActive || this.view.getWindowVisibility() != 0) {
            this.prefetchScheduled = false;
            return;
        }
        long nextFrameNs = this.frameStartTimeNanos + frameIntervalNs;
        PrefetchRequestScopeImpl scope = new PrefetchRequestScopeImpl(nextFrameNs);
        boolean scheduleForNextFrame = false;
        while (true) {
            MutableVector<PrefetchRequest> this_$iv2 = this.prefetchRequests;
            boolean $i$f$isNotEmpty2 = false;
            if (!(this_$iv2.getSize() != 0) || scheduleForNextFrame) break;
            if (scope.availableTimeNanos() > 0L) {
                void this_$iv3;
                PrefetchRequest request2;
                MutableVector<PrefetchRequest> $i$f$isNotEmpty2 = this.prefetchRequests;
                int index$iv = 0;
                boolean $i$f$get = false;
                PrefetchRequest $this$run_u24lambda_u240 = request2 = (PrefetchRequest)this_$iv3.getContent()[index$iv];
                boolean bl = false;
                boolean hasMoreWorkToDo = $this$run_u24lambda_u240.execute(scope);
                if (hasMoreWorkToDo) {
                    scheduleForNextFrame = true;
                    continue;
                }
                this.prefetchRequests.removeAt(0);
                continue;
            }
            scheduleForNextFrame = true;
        }
        if (scheduleForNextFrame) {
            this.choreographer.postFrameCallback((Choreographer.FrameCallback)this);
        } else {
            this.prefetchScheduled = false;
        }
    }

    public void doFrame(long frameTimeNanos) {
        if (this.isActive) {
            this.frameStartTimeNanos = frameTimeNanos;
            this.view.post((Runnable)this);
        }
    }

    @Override
    public void schedulePrefetch(@NotNull PrefetchRequest prefetchRequest) {
        this.prefetchRequests.add((Object)prefetchRequest);
        if (!this.prefetchScheduled) {
            this.prefetchScheduled = true;
            this.view.post((Runnable)this);
        }
    }

    public void onRemembered() {
        this.isActive = true;
    }

    public void onForgotten() {
        this.isActive = false;
        this.view.removeCallbacks((Runnable)this);
        this.choreographer.removeFrameCallback((Choreographer.FrameCallback)this);
    }

    public void onAbandoned() {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/compose/foundation/lazy/layout/AndroidPrefetchScheduler$Companion;", "", "()V", "frameIntervalNs", "", "calculateFrameIntervalIfNeeded", "", "view", "Landroid/view/View;", "foundation_release"})
    public static final class Companion {
        private Companion() {
        }

        private final void calculateFrameIntervalIfNeeded(View view) {
            if (frameIntervalNs == 0L) {
                float displayRefreshRate;
                Display display = view.getDisplay();
                float refreshRate = 60.0f;
                if (!view.isInEditMode() && display != null && (displayRefreshRate = display.getRefreshRate()) >= 30.0f) {
                    refreshRate = displayRefreshRate;
                }
                frameIntervalNs = (long)((float)1000000000 / refreshRate);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/compose/foundation/lazy/layout/AndroidPrefetchScheduler$PrefetchRequestScopeImpl;", "Landroidx/compose/foundation/lazy/layout/PrefetchRequestScope;", "nextFrameTimeNs", "", "(J)V", "availableTimeNanos", "foundation_release"})
    @StabilityInferred(parameters=1)
    public static final class PrefetchRequestScopeImpl
    implements PrefetchRequestScope {
        private final long nextFrameTimeNs;
        public static final int $stable;

        public PrefetchRequestScopeImpl(long nextFrameTimeNs) {
            this.nextFrameTimeNs = nextFrameTimeNs;
        }

        @Override
        public long availableTimeNanos() {
            return Math.max(0L, this.nextFrameTimeNs - System.nanoTime());
        }
    }
}

