/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lint;

import androidx.compose.foundation.lint.FoundationNames;
import androidx.compose.foundation.lint.NonLambdaOffsetModifierDetectorKt;
import androidx.compose.lint.KotlinMetadataUtilsKt;
import androidx.compose.lint.PsiUtilsKt;
import androidx.lint.kotlinx.metadata.KmClassifier;
import androidx.lint.kotlinx.metadata.KmFunction;
import androidx.lint.kotlinx.metadata.KmType;
import androidx.lint.kotlinx.metadata.KmValueParameter;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u00012\u00020\u0002:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\f\u0010\u0011\u001a\u00020\b*\u00020\u0010H\u0002\u00a8\u0006\u0013"}, d2={"Landroidx/compose/foundation/lint/NonLambdaOffsetModifierDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "hasStateBackedArguments", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "method", "Lcom/intellij/psi/PsiMethod;", "isDesiredOffsetOverload", "Companion", "foundation-lint"})
@SourceDebugExtension(value={"SMAP\nNonLambdaOffsetModifierDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonLambdaOffsetModifierDetector.kt\nandroidx/compose/foundation/lint/NonLambdaOffsetModifierDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,178:1\n1726#2,3:179\n1855#2,2:182\n*S KotlinDebug\n*F\n+ 1 NonLambdaOffsetModifierDetector.kt\nandroidx/compose/foundation/lint/NonLambdaOffsetModifierDetector\n*L\n97#1:179,3\n103#1:182,2\n*E\n"})
public final class NonLambdaOffsetModifierDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ReportMainMessage = "State backed values should use the lambda overload of Modifier.offset";
    @NotNull
    public static final String IssueId = "UseOfNonLambdaOffsetOverload";
    @NotNull
    private static final Issue UseOfNonLambdaOverload = Issue.Companion.create("UseOfNonLambdaOffsetOverload", "Modifier.offset{ } is preferred over Modifier.offset() for `State` backed arguments.", "`Modifier.offset()` is recommended to be used with static arguments only to avoid unnecessary recompositions. `Modifier.offset{ }` is preferred in the cases where the arguments are backed by a `State`.", Category.PERFORMANCE, 3, Severity.WARNING, new Implementation(NonLambdaOffsetModifierDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{FoundationNames.Layout.INSTANCE.getOffset().getShortName(), FoundationNames.Layout.INSTANCE.getAbsoluteOffset().getShortName()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!PsiUtilsKt.isInPackageName(method, FoundationNames.Layout.INSTANCE.getPackageName())) {
            return;
        }
        if (this.isDesiredOffsetOverload(method) && this.hasStateBackedArguments(node)) {
            JavaContext.report$default((JavaContext)context, (Issue)UseOfNonLambdaOverload, (UElement)((UElement)node), (Location)context.getNameLocation((UElement)node), (String)ReportMainMessage, null, (int)16, null);
        }
    }

    private final boolean isDesiredOffsetOverload(PsiMethod $this$isDesiredOffsetOverload) {
        boolean bl;
        block8: {
            KmFunction kmFunction = KotlinMetadataUtilsKt.toKmFunction($this$isDesiredOffsetOverload);
            if (kmFunction == null) {
                return false;
            }
            KmFunction kmFunction2 = kmFunction;
            Object object = kmFunction2.getReceiverParameterType();
            if (object == null || (object = ((KmType)object).getClassifier()) == null) {
                return false;
            }
            Object receiverClassifier = object;
            KmClassifier returnTypeClassifier = kmFunction2.getReturnType().getClassifier();
            if (!Intrinsics.areEqual((Object)receiverClassifier, (Object)NonLambdaOffsetModifierDetectorKt.access$getModifierClassifier$p())) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)returnTypeClassifier, (Object)NonLambdaOffsetModifierDetectorKt.access$getModifierClassifier$p())) {
                return false;
            }
            List<KmValueParameter> valueParameters = kmFunction2.getValueParameters();
            if (valueParameters.size() != 2) {
                return false;
            }
            Iterable $this$all$iv = valueParameters;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    KmValueParameter it = (KmValueParameter)element$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it.getType().getClassifier(), (Object)NonLambdaOffsetModifierDetectorKt.access$getDpClassifier$p())) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean hasStateBackedArguments(UCallExpression node) {
        Ref.BooleanRef dynamicArguments = new Ref.BooleanRef();
        Iterable $this$forEach$iv = node.getValueArguments();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UExpression expression = (UExpression)element$iv;
            boolean bl = false;
            expression.accept((UastVisitor)new AbstractUastVisitor(dynamicArguments){
                final /* synthetic */ Ref.BooleanRef $dynamicArguments;
                {
                    this.$dynamicArguments = $dynamicArguments;
                }

                public boolean visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    UDeclaration uDeclaration = UastLintUtils.Companion.tryResolveUDeclaration((UElement)node);
                    if (uDeclaration == null) {
                        return false;
                    }
                    UDeclaration declaration = uDeclaration;
                    this.$dynamicArguments.element = this.$dynamicArguments.element || NonLambdaOffsetModifierDetectorKt.access$isCompositionAwareType(declaration);
                    return this.$dynamicArguments.element;
                }
            });
        }
        return dynamicArguments.element;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Landroidx/compose/foundation/lint/NonLambdaOffsetModifierDetector$Companion;", "", "()V", "IssueId", "", "ReportMainMessage", "UseOfNonLambdaOverload", "Lcom/android/tools/lint/detector/api/Issue;", "getUseOfNonLambdaOverload", "()Lcom/android/tools/lint/detector/api/Issue;", "foundation-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getUseOfNonLambdaOverload() {
            return UseOfNonLambdaOverload;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

