/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.layout;

import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.lazy.layout.IntervalList;
import androidx.compose.foundation.lazy.layout.IntervalListKt;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001b\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010J\u0011\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\tH\u0082\bJ2\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0018\u0010\u0016\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0004\u0012\u00020\u000e0\u0017H\u0016J\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u0012\u001a\u00020\tH\u0096\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u001a\u001a\u00020\tH\u0002J\u001a\u0010\u001b\u001a\u00020\u001c*\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u0012\u001a\u00020\tH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Landroidx/compose/foundation/lazy/layout/MutableIntervalList;", "T", "Landroidx/compose/foundation/lazy/layout/IntervalList;", "()V", "intervals", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/foundation/lazy/layout/IntervalList$Interval;", "lastInterval", "<set-?>", "", "size", "getSize", "()I", "addInterval", "", "value", "(ILjava/lang/Object;)V", "checkIndexBounds", "index", "forEach", "fromIndex", "toIndex", "block", "Lkotlin/Function1;", "get", "getIntervalForIndex", "itemIndex", "contains", "", "foundation_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nIntervalList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntervalList.kt\nandroidx/compose/foundation/lazy/layout/MutableIntervalList\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/foundation/internal/InlineClassHelperKt\n+ 4 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n163#1,4:211\n163#1,4:215\n163#1,4:226\n1147#2:203\n1129#2,2:204\n96#3,5:206\n96#3,5:219\n489#4:224\n489#4:225\n489#4:230\n1#5:231\n*S KotlinDebug\n*F\n+ 1 IntervalList.kt\nandroidx/compose/foundation/lazy/layout/MutableIntervalList\n*L\n131#1:211,4\n132#1:215,4\n148#1:226,4\n93#1:203\n93#1:204,2\n111#1:206,5\n133#1:219,5\n138#1:224\n140#1:225\n157#1:230\n*E\n"})
public final class MutableIntervalList<T>
implements IntervalList<T> {
    @NotNull
    private final MutableVector<IntervalList.Interval<T>> intervals;
    private int size;
    @Nullable
    private IntervalList.Interval<? extends T> lastInterval;
    public static final int $stable = 8;

    public MutableIntervalList() {
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.intervals = new MutableVector((Object[])new IntervalList.Interval[capacity$iv$iv], 0);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public final void addInterval(int size, T value) {
        boolean value$iv = size >= 0;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("size should be >=0");
        }
        if (size == 0) {
            return;
        }
        IntervalList.Interval<T> interval = new IntervalList.Interval<T>(this.getSize(), size, value);
        this.size = this.getSize() + size;
        this.intervals.add(interval);
    }

    @Override
    public void forEach(int fromIndex, int toIndex, @NotNull Function1<? super IntervalList.Interval<? extends T>, Unit> block) {
        MutableIntervalList this_$iv = this;
        boolean $i$f$checkIndexBounds = false;
        if (!(0 <= fromIndex ? fromIndex < this_$iv.getSize() : false)) {
            InlineClassHelperKt.throwIndexOutOfBoundsException("Index " + fromIndex + ", size " + this_$iv.getSize());
        }
        this_$iv = this;
        $i$f$checkIndexBounds = false;
        if (!(0 <= toIndex ? toIndex < this_$iv.getSize() : false)) {
            InlineClassHelperKt.throwIndexOutOfBoundsException("Index " + toIndex + ", size " + this_$iv.getSize());
        }
        boolean value$iv = toIndex >= fromIndex;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("toIndex (" + toIndex + ") should be not smaller than fromIndex (" + fromIndex + ')');
        }
        int intervalIndex = IntervalListKt.access$binarySearch(this.intervals, fromIndex);
        MutableVector<IntervalList.Interval<T>> this_$iv2 = this.intervals;
        boolean $i$f$get = false;
        int itemIndex = ((IntervalList.Interval)this_$iv2.getContent()[intervalIndex]).getStartIndex();
        while (itemIndex <= toIndex) {
            MutableVector<IntervalList.Interval<T>> this_$iv3 = this.intervals;
            boolean $i$f$get2 = false;
            IntervalList.Interval interval = (IntervalList.Interval)this_$iv3.getContent()[intervalIndex];
            block.invoke((Object)interval);
            itemIndex += interval.getSize();
            ++intervalIndex;
        }
    }

    @Override
    @NotNull
    public IntervalList.Interval<T> get(int index2) {
        MutableIntervalList this_$iv = this;
        boolean $i$f$checkIndexBounds = false;
        if (!(0 <= index2 ? index2 < this_$iv.getSize() : false)) {
            InlineClassHelperKt.throwIndexOutOfBoundsException("Index " + index2 + ", size " + this_$iv.getSize());
        }
        return this.getIntervalForIndex(index2);
    }

    /*
     * WARNING - void declaration
     */
    private final IntervalList.Interval<T> getIntervalForIndex(int itemIndex) {
        IntervalList.Interval interval;
        IntervalList.Interval lastInterval = this.lastInterval;
        if (lastInterval != null && this.contains(lastInterval, itemIndex)) {
            interval = lastInterval;
        } else {
            void this_$iv;
            Object object = this.intervals;
            int index$iv = IntervalListKt.access$binarySearch(this.intervals, itemIndex);
            boolean $i$f$get = false;
            object = this_$iv.getContent()[index$iv];
            IntervalList.Interval it = (IntervalList.Interval)object;
            boolean bl = false;
            this.lastInterval = it;
            interval = (IntervalList.Interval)object;
        }
        return interval;
    }

    private final void checkIndexBounds(int index2) {
        boolean $i$f$checkIndexBounds = false;
        if (!(0 <= index2 ? index2 < this.getSize() : false)) {
            InlineClassHelperKt.throwIndexOutOfBoundsException("Index " + index2 + ", size " + this.getSize());
        }
    }

    private final boolean contains(IntervalList.Interval<? extends T> $this$contains, int index2) {
        int n = $this$contains.getStartIndex();
        return index2 < $this$contains.getStartIndex() + $this$contains.getSize() ? n <= index2 : false;
    }
}

