/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input;

import androidx.compose.foundation.ExperimentalFoundationApi;
import androidx.compose.foundation.text.input.TextFieldBuffer;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a2\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0007\u0010\b\u001a{\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2`\u0010\u000e\u001a\\\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\n0\u000fH\u0080\b\u001a\u001a\u0010\u0016\u001a\u00020\n*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004\u001aE\u0010\u001a\u001a\u00020\n*\u00020\u001b26\u0010\u001c\u001a2\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u001e\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0002\u0012\u0004\u0012\u00020\n0\u001dH\u0087\b\u001aE\u0010\u001f\u001a\u00020\n*\u00020\u001b26\u0010\u001c\u001a2\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u001e\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0002\u0012\u0004\u0012\u00020\n0\u001dH\u0087\b\u001a\u001a\u0010 \u001a\u00020\n*\u00020\u00172\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020#\u001a\n\u0010$\u001a\u00020\n*\u00020\u0017\u001a\n\u0010%\u001a\u00020\n*\u00020\u0017\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006&"}, d2={"adjustTextRange", "Landroidx/compose/ui/text/TextRange;", "originalRange", "replaceStart", "", "replaceEnd", "insertedTextLength", "adjustTextRange-vJH6DeI", "(JIII)J", "findCommonPrefixAndSuffix", "", "a", "", "b", "onFound", "Lkotlin/Function4;", "Lkotlin/ParameterName;", "name", "aPrefixStart", "aSuffixStart", "bPrefixStart", "bSuffixStart", "delete", "Landroidx/compose/foundation/text/input/TextFieldBuffer;", "start", "end", "forEachChange", "Landroidx/compose/foundation/text/input/TextFieldBuffer$ChangeList;", "block", "Lkotlin/Function2;", "range", "forEachChangeReversed", "insert", "index", "text", "", "placeCursorAtEnd", "selectAll", "foundation_release"})
public final class TextFieldBufferKt {
    public static final long adjustTextRange-vJH6DeI(long originalRange, int replaceStart, int replaceEnd, int insertedTextLength) {
        int selStart = TextRange.getMin-impl((long)originalRange);
        int selEnd = TextRange.getMax-impl((long)originalRange);
        if (selEnd < replaceStart) {
            return originalRange;
        }
        if (selStart <= replaceStart && replaceEnd <= selEnd) {
            int diff = insertedTextLength - (replaceEnd - replaceStart);
            if (selStart == selEnd) {
                selStart += diff;
            }
            selEnd += diff;
        } else if (selStart > replaceStart && selEnd < replaceEnd) {
            selStart = replaceStart + insertedTextLength;
            selEnd = replaceStart + insertedTextLength;
        } else if (selStart >= replaceEnd) {
            int diff = insertedTextLength - (replaceEnd - replaceStart);
            selStart += diff;
            selEnd += diff;
        } else if (replaceStart < selStart) {
            selStart = replaceStart + insertedTextLength;
            selEnd += insertedTextLength - (replaceEnd - replaceStart);
        } else {
            selEnd = replaceStart;
        }
        return TextRangeKt.TextRange((int)selStart, (int)selEnd);
    }

    public static final void insert(@NotNull TextFieldBuffer $this$insert, int index2, @NotNull String text) {
        $this$insert.replace(index2, index2, text);
    }

    public static final void delete(@NotNull TextFieldBuffer $this$delete, int start, int end) {
        $this$delete.replace(start, end, "");
    }

    public static final void placeCursorAtEnd(@NotNull TextFieldBuffer $this$placeCursorAtEnd) {
        $this$placeCursorAtEnd.placeCursorBeforeCharAt($this$placeCursorAtEnd.getLength());
    }

    public static final void selectAll(@NotNull TextFieldBuffer $this$selectAll) {
        $this$selectAll.setSelection-5zc-tL8(TextRangeKt.TextRange((int)0, (int)$this$selectAll.getLength()));
    }

    @ExperimentalFoundationApi
    public static final void forEachChange(@NotNull TextFieldBuffer.ChangeList $this$forEachChange, @NotNull Function2<? super TextRange, ? super TextRange, Unit> block) {
        boolean $i$f$forEachChange = false;
        for (int i = 0; i < $this$forEachChange.getChangeCount(); ++i) {
            block.invoke((Object)TextRange.box-impl((long)$this$forEachChange.getRange--jx7JFs(i)), (Object)TextRange.box-impl((long)$this$forEachChange.getOriginalRange--jx7JFs(i)));
        }
    }

    @ExperimentalFoundationApi
    public static final void forEachChangeReversed(@NotNull TextFieldBuffer.ChangeList $this$forEachChangeReversed, @NotNull Function2<? super TextRange, ? super TextRange, Unit> block) {
        boolean $i$f$forEachChangeReversed = false;
        for (int i = $this$forEachChangeReversed.getChangeCount() - 1; i >= 0; --i) {
            block.invoke((Object)TextRange.box-impl((long)$this$forEachChangeReversed.getRange--jx7JFs(i)), (Object)TextRange.box-impl((long)$this$forEachChangeReversed.getOriginalRange--jx7JFs(i)));
        }
    }

    public static final void findCommonPrefixAndSuffix(@NotNull CharSequence a, @NotNull CharSequence b, @NotNull Function4<? super Integer, ? super Integer, ? super Integer, ? super Integer, Unit> onFound) {
        boolean $i$f$findCommonPrefixAndSuffix = false;
        int aStart = 0;
        int aEnd = a.length();
        int bStart = 0;
        int bEnd = b.length();
        if (a.length() > 0 && b.length() > 0) {
            boolean prefixFound = false;
            boolean suffixFound = false;
            do {
                if (!prefixFound) {
                    if (a.charAt(aStart) == b.charAt(bStart)) {
                        ++aStart;
                        ++bStart;
                    } else {
                        prefixFound = true;
                    }
                }
                if (suffixFound) continue;
                if (a.charAt(aEnd - 1) == b.charAt(bEnd - 1)) {
                    --aEnd;
                    --bEnd;
                    continue;
                }
                suffixFound = true;
            } while (aStart < aEnd && bStart < bEnd && (!prefixFound || !suffixFound));
        }
        if (aStart >= aEnd && bStart >= bEnd) {
            return;
        }
        onFound.invoke((Object)aStart, (Object)aEnd, (Object)bStart, (Object)bEnd);
    }
}

