/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal;

import android.view.inputmethod.CursorAnchorInfo;
import androidx.compose.foundation.text.input.internal.InputMethodManager;
import androidx.compose.foundation.text.input.internal.LegacyCursorAnchorInfoBuilder_androidKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.AndroidMatrixConversions_androidKt;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.input.OffsetMapping;
import androidx.compose.ui.text.input.TextFieldValue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010 \u001a\u00020\u0005J6\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010J\b\u0010$\u001a\u00020\u0005H\u0002J.\u0010%\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006&"}, d2={"Landroidx/compose/foundation/text/input/internal/LegacyCursorAnchorInfoController;", "", "localToScreen", "Lkotlin/Function1;", "Landroidx/compose/ui/graphics/Matrix;", "", "inputMethodManager", "Landroidx/compose/foundation/text/input/internal/InputMethodManager;", "(Lkotlin/jvm/functions/Function1;Landroidx/compose/foundation/text/input/internal/InputMethodManager;)V", "androidMatrix", "Landroid/graphics/Matrix;", "builder", "Landroid/view/inputmethod/CursorAnchorInfo$Builder;", "decorationBoxBounds", "Landroidx/compose/ui/geometry/Rect;", "hasPendingImmediateRequest", "", "includeCharacterBounds", "includeEditorBounds", "includeInsertionMarker", "includeLineBounds", "innerTextFieldBounds", "lock", "matrix", "[F", "monitorEnabled", "offsetMapping", "Landroidx/compose/ui/text/input/OffsetMapping;", "textFieldValue", "Landroidx/compose/ui/text/input/TextFieldValue;", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "invalidate", "requestUpdate", "immediate", "monitor", "updateCursorAnchorInfo", "updateTextLayoutResult", "foundation_release"})
@StabilityInferred(parameters=0)
public final class LegacyCursorAnchorInfoController {
    @NotNull
    private final Function1<Matrix, Unit> localToScreen;
    @NotNull
    private final InputMethodManager inputMethodManager;
    @NotNull
    private final Object lock;
    private boolean monitorEnabled;
    private boolean hasPendingImmediateRequest;
    private boolean includeInsertionMarker;
    private boolean includeCharacterBounds;
    private boolean includeEditorBounds;
    private boolean includeLineBounds;
    @Nullable
    private TextFieldValue textFieldValue;
    @Nullable
    private TextLayoutResult textLayoutResult;
    @Nullable
    private OffsetMapping offsetMapping;
    @Nullable
    private Rect innerTextFieldBounds;
    @Nullable
    private Rect decorationBoxBounds;
    @NotNull
    private final CursorAnchorInfo.Builder builder;
    @NotNull
    private final float[] matrix;
    @NotNull
    private final android.graphics.Matrix androidMatrix;
    public static final int $stable = 8;

    public LegacyCursorAnchorInfoController(@NotNull Function1<? super Matrix, Unit> localToScreen, @NotNull InputMethodManager inputMethodManager) {
        this.localToScreen = localToScreen;
        this.inputMethodManager = inputMethodManager;
        this.lock = new Object();
        this.builder = new CursorAnchorInfo.Builder();
        this.matrix = Matrix.constructor-impl$default(null, (int)1, null);
        this.androidMatrix = new android.graphics.Matrix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void requestUpdate(boolean immediate, boolean monitor, boolean includeInsertionMarker, boolean includeCharacterBounds, boolean includeEditorBounds, boolean includeLineBounds) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.includeInsertionMarker = includeInsertionMarker;
            this.includeCharacterBounds = includeCharacterBounds;
            this.includeEditorBounds = includeEditorBounds;
            this.includeLineBounds = includeLineBounds;
            if (immediate) {
                this.hasPendingImmediateRequest = true;
                if (this.textFieldValue != null) {
                    this.updateCursorAnchorInfo();
                }
            }
            this.monitorEnabled = monitor;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateTextLayoutResult(@NotNull TextFieldValue textFieldValue, @NotNull OffsetMapping offsetMapping, @NotNull TextLayoutResult textLayoutResult, @NotNull Rect innerTextFieldBounds, @NotNull Rect decorationBoxBounds) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.textFieldValue = textFieldValue;
            this.offsetMapping = offsetMapping;
            this.textLayoutResult = textLayoutResult;
            this.innerTextFieldBounds = innerTextFieldBounds;
            this.decorationBoxBounds = decorationBoxBounds;
            if (this.hasPendingImmediateRequest || this.monitorEnabled) {
                this.updateCursorAnchorInfo();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invalidate() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.textFieldValue = null;
            this.offsetMapping = null;
            this.textLayoutResult = null;
            this.innerTextFieldBounds = null;
            this.decorationBoxBounds = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void updateCursorAnchorInfo() {
        if (!this.inputMethodManager.isActive()) {
            return;
        }
        Matrix.reset-impl((float[])this.matrix);
        this.localToScreen.invoke((Object)Matrix.box-impl((float[])this.matrix));
        Rect rect = this.decorationBoxBounds;
        Intrinsics.checkNotNull((Object)rect);
        float f = -rect.getLeft();
        Rect rect2 = this.decorationBoxBounds;
        Intrinsics.checkNotNull((Object)rect2);
        Matrix.translate-impl((float[])this.matrix, (float)f, (float)(-rect2.getTop()), (float)0.0f);
        AndroidMatrixConversions_androidKt.setFrom-EL8BTi8((android.graphics.Matrix)this.androidMatrix, (float[])this.matrix);
        TextFieldValue textFieldValue = this.textFieldValue;
        Intrinsics.checkNotNull((Object)textFieldValue);
        OffsetMapping offsetMapping = this.offsetMapping;
        Intrinsics.checkNotNull((Object)offsetMapping);
        TextLayoutResult textLayoutResult = this.textLayoutResult;
        Intrinsics.checkNotNull((Object)textLayoutResult);
        Rect rect3 = this.innerTextFieldBounds;
        Intrinsics.checkNotNull((Object)rect3);
        Rect rect4 = this.decorationBoxBounds;
        Intrinsics.checkNotNull((Object)rect4);
        this.inputMethodManager.updateCursorAnchorInfo(LegacyCursorAnchorInfoBuilder_androidKt.build(this.builder, textFieldValue, offsetMapping, textLayoutResult, this.androidMatrix, rect3, rect4, this.includeInsertionMarker, this.includeCharacterBounds, this.includeEditorBounds, this.includeLineBounds));
        this.hasPendingImmediateRequest = false;
    }
}

