/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text2.input;

import androidx.compose.foundation.text.KeyboardOptions;
import androidx.compose.foundation.text2.input.InputTransformation;
import androidx.compose.foundation.text2.input.TextFieldBuffer;
import androidx.compose.foundation.text2.input.TextFieldCharSequence;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Landroidx/compose/foundation/text2/input/FilterChain;", "Landroidx/compose/foundation/text2/input/InputTransformation;", "first", "second", "(Landroidx/compose/foundation/text2/input/InputTransformation;Landroidx/compose/foundation/text2/input/InputTransformation;)V", "keyboardOptions", "Landroidx/compose/foundation/text/KeyboardOptions;", "getKeyboardOptions", "()Landroidx/compose/foundation/text/KeyboardOptions;", "equals", "", "other", "", "hashCode", "", "toString", "", "transformInput", "", "originalValue", "Landroidx/compose/foundation/text2/input/TextFieldCharSequence;", "valueWithChanges", "Landroidx/compose/foundation/text2/input/TextFieldBuffer;", "foundation"})
final class FilterChain
implements InputTransformation {
    @NotNull
    private final InputTransformation first;
    @NotNull
    private final InputTransformation second;

    public FilterChain(@NotNull InputTransformation first, @NotNull InputTransformation second) {
        this.first = first;
        this.second = second;
    }

    @Override
    @Nullable
    public KeyboardOptions getKeyboardOptions() {
        KeyboardOptions keyboardOptions = this.second.getKeyboardOptions();
        if (keyboardOptions == null) {
            keyboardOptions = this.first.getKeyboardOptions();
        }
        return keyboardOptions;
    }

    @Override
    public void transformInput(@NotNull TextFieldCharSequence originalValue, @NotNull TextFieldBuffer valueWithChanges) {
        this.first.transformInput(originalValue, valueWithChanges);
        this.second.transformInput(originalValue, valueWithChanges);
    }

    @NotNull
    public String toString() {
        return this.first + ".then(" + this.second + ')';
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        FilterChain cfr_ignored_0 = (FilterChain)other;
        if (!Intrinsics.areEqual((Object)this.first, (Object)((FilterChain)other).first)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.second, (Object)((FilterChain)other).second)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getKeyboardOptions(), (Object)((FilterChain)other).getKeyboardOptions());
    }

    public int hashCode() {
        int result2 = this.first.hashCode();
        result2 = 31 * result2 + this.second.hashCode();
        KeyboardOptions keyboardOptions = this.getKeyboardOptions();
        result2 = 32 * result2 + (keyboardOptions != null ? ((Object)keyboardOptions).hashCode() : 0);
        return result2;
    }
}

