/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.layout;

import androidx.annotation.FloatRange;
import androidx.compose.Immutable;
import androidx.compose.Stable;
import androidx.ui.core.Alignment;
import androidx.ui.core.AlignmentLine;
import androidx.ui.core.HorizontalAlignmentLine;
import androidx.ui.core.Measured;
import androidx.ui.core.Modifier;
import androidx.ui.layout.LayoutScopeMarker;
import androidx.ui.layout.LayoutWeightImpl;
import androidx.ui.layout.SiblingsAlignedModifier;
import androidx.ui.layout.VerticalGravityModifier;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@LayoutScopeMarker
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, xi=16, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0002\b\u0002J#\u0010\u0002\u001a\u00020\u0003*\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0007\u00f8\u0001\u0000J\u0014\u0010\u0002\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0007J\u0014\u0010\n\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0007J \u0010\r\u001a\u00020\u0003*\u00020\u00032\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Landroidx/ui/layout/RowScope;", "", "alignWithSiblings", "Landroidx/ui/core/Modifier;", "alignmentLineBlock", "Lkotlin/Function1;", "Landroidx/ui/core/Measured;", "", "alignmentLine", "Landroidx/ui/core/HorizontalAlignmentLine;", "gravity", "align", "Landroidx/ui/core/Alignment$Vertical;", "weight", "", "fill", "", "foundation-layout_release"})
@Immutable
public final class RowScope {
    @NotNull
    public static final RowScope INSTANCE = new RowScope();

    private RowScope() {
    }

    @Stable
    @NotNull
    public final Modifier gravity(@NotNull Modifier $this$gravity, @NotNull Alignment.Vertical align) {
        Intrinsics.checkNotNullParameter((Object)$this$gravity, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)align, (String)"align");
        return $this$gravity.plus((Modifier)new VerticalGravityModifier(align));
    }

    @Stable
    @NotNull
    public final Modifier alignWithSiblings(@NotNull Modifier $this$alignWithSiblings, @NotNull HorizontalAlignmentLine alignmentLine) {
        Intrinsics.checkNotNullParameter((Object)$this$alignWithSiblings, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)alignmentLine, (String)"alignmentLine");
        return $this$alignWithSiblings.plus((Modifier)new SiblingsAlignedModifier.WithAlignmentLine((AlignmentLine)alignmentLine));
    }

    @Stable
    @NotNull
    public final Modifier weight(@NotNull Modifier $this$weight, @FloatRange(from=0.0, to=3.4E38, fromInclusive=false) float weight, boolean fill) {
        Intrinsics.checkNotNullParameter((Object)$this$weight, (String)"<this>");
        boolean bl = (double)weight > 0.0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "invalid weight " + weight + "; must be greater than zero";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return $this$weight.plus((Modifier)new LayoutWeightImpl(weight, fill));
    }

    public static /* synthetic */ Modifier weight$default(RowScope rowScope, Modifier modifier, float f, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return rowScope.weight(modifier, f, bl);
    }

    @Stable
    @NotNull
    public final Modifier alignWithSiblings(@NotNull Modifier $this$alignWithSiblings, @NotNull Function1<? super Measured, Integer> alignmentLineBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$alignWithSiblings, (String)"<this>");
        Intrinsics.checkNotNullParameter(alignmentLineBlock, (String)"alignmentLineBlock");
        return $this$alignWithSiblings.plus((Modifier)new SiblingsAlignedModifier.WithAlignmentLineBlock(alignmentLineBlock));
    }
}

