/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.layout;

import android.os.Build;
import android.os.SystemClock;
import android.view.View;
import androidx.compose.foundation.layout.WindowInsetsHolder;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.WindowInsetsAnimationCompat;
import androidx.core.view.WindowInsetsCompat;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0007H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u001e\u0010#\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\f\u0010$\u001a\b\u0012\u0004\u0012\u00020!0%H\u0016J\u0018\u0010&\u001a\u00020'2\u0006\u0010 \u001a\u00020!2\u0006\u0010(\u001a\u00020'H\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006*"}, d2={"Landroidx/compose/foundation/layout/InsetsListener;", "Landroidx/core/view/OnApplyWindowInsetsListener;", "Landroidx/core/view/WindowInsetsAnimationCompat$Callback;", "composeInsets", "Landroidx/compose/foundation/layout/WindowInsetsHolder;", "(Landroidx/compose/foundation/layout/WindowInsetsHolder;)V", "animationInsets", "Landroidx/core/view/WindowInsetsCompat;", "getAnimationInsets", "()Landroidx/core/view/WindowInsetsCompat;", "setAnimationInsets", "(Landroidx/core/view/WindowInsetsCompat;)V", "getComposeInsets", "()Landroidx/compose/foundation/layout/WindowInsetsHolder;", "prepareGiveUpTime", "", "getPrepareGiveUpTime", "()J", "setPrepareGiveUpTime", "(J)V", "started", "", "getStarted", "()Z", "setStarted", "(Z)V", "onApplyWindowInsets", "view", "Landroid/view/View;", "insets", "onEnd", "", "animation", "Landroidx/core/view/WindowInsetsAnimationCompat;", "onPrepare", "onProgress", "runningAnimations", "", "onStart", "Landroidx/core/view/WindowInsetsAnimationCompat$BoundsCompat;", "bounds", "Companion", "foundation-layout_release"})
final class InsetsListener
extends WindowInsetsAnimationCompat.Callback
implements OnApplyWindowInsetsListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WindowInsetsHolder composeInsets;
    private long prepareGiveUpTime;
    private boolean started;
    @Nullable
    private WindowInsetsCompat animationInsets;
    public static final long AnimationCanceledMillis = 100L;

    public InsetsListener(@NotNull WindowInsetsHolder composeInsets) {
        Intrinsics.checkNotNullParameter((Object)composeInsets, (String)"composeInsets");
        super(composeInsets.getConsumes() ? 0 : 1);
        this.composeInsets = composeInsets;
    }

    @NotNull
    public final WindowInsetsHolder getComposeInsets() {
        return this.composeInsets;
    }

    public final long getPrepareGiveUpTime() {
        return this.prepareGiveUpTime;
    }

    public final void setPrepareGiveUpTime(long l) {
        this.prepareGiveUpTime = l;
    }

    public final boolean getStarted() {
        return this.started;
    }

    public final void setStarted(boolean bl) {
        this.started = bl;
    }

    @Nullable
    public final WindowInsetsCompat getAnimationInsets() {
        return this.animationInsets;
    }

    public final void setAnimationInsets(@Nullable WindowInsetsCompat windowInsetsCompat) {
        this.animationInsets = windowInsetsCompat;
    }

    public void onPrepare(@NotNull WindowInsetsAnimationCompat animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        this.prepareGiveUpTime = SystemClock.uptimeMillis() + 100L;
        super.onPrepare(animation);
    }

    @NotNull
    public WindowInsetsAnimationCompat.BoundsCompat onStart(@NotNull WindowInsetsAnimationCompat animation, @NotNull WindowInsetsAnimationCompat.BoundsCompat bounds) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        this.started = true;
        WindowInsetsAnimationCompat.BoundsCompat boundsCompat = super.onStart(animation, bounds);
        Intrinsics.checkNotNullExpressionValue((Object)boundsCompat, (String)"super.onStart(animation, bounds)");
        return boundsCompat;
    }

    @NotNull
    public WindowInsetsCompat onProgress(@NotNull WindowInsetsCompat insets, @NotNull List<WindowInsetsAnimationCompat> runningAnimations) {
        WindowInsetsCompat windowInsetsCompat;
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        Intrinsics.checkNotNullParameter(runningAnimations, (String)"runningAnimations");
        this.prepareGiveUpTime = 0L;
        WindowInsetsHolder.update$default(this.composeInsets, insets, 0, 2, null);
        if (this.composeInsets.getConsumes()) {
            WindowInsetsCompat windowInsetsCompat2 = WindowInsetsCompat.CONSUMED;
            windowInsetsCompat = windowInsetsCompat2;
            Intrinsics.checkNotNullExpressionValue((Object)windowInsetsCompat2, (String)"CONSUMED");
        } else {
            windowInsetsCompat = insets;
        }
        return windowInsetsCompat;
    }

    public void onEnd(@NotNull WindowInsetsAnimationCompat animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        this.started = false;
        this.prepareGiveUpTime = 0L;
        WindowInsetsCompat insets = this.animationInsets;
        if (animation.getDurationMillis() != 0L && insets != null) {
            this.composeInsets.update(insets, animation.getTypeMask());
        }
        this.animationInsets = null;
        super.onEnd(animation);
    }

    @NotNull
    public WindowInsetsCompat onApplyWindowInsets(@NotNull View view, @NotNull WindowInsetsCompat insets) {
        WindowInsetsCompat windowInsetsCompat;
        boolean preparing;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        long prepareGiveUpTime = this.prepareGiveUpTime;
        this.prepareGiveUpTime = 0L;
        boolean bl = preparing = prepareGiveUpTime != 0L && (Build.VERSION.SDK_INT > 30 || prepareGiveUpTime > SystemClock.uptimeMillis());
        if (this.started || preparing) {
            this.animationInsets = insets;
            return insets;
        }
        WindowInsetsHolder.update$default(this.composeInsets, insets, 0, 2, null);
        if (this.composeInsets.getConsumes()) {
            WindowInsetsCompat windowInsetsCompat2 = WindowInsetsCompat.CONSUMED;
            windowInsetsCompat = windowInsetsCompat2;
            Intrinsics.checkNotNullExpressionValue((Object)windowInsetsCompat2, (String)"CONSUMED");
        } else {
            windowInsetsCompat = insets;
        }
        return windowInsetsCompat;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/compose/foundation/layout/InsetsListener$Companion;", "", "()V", "AnimationCanceledMillis", "", "foundation-layout_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

