/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.layout;

import androidx.compose.foundation.layout.CrossAxisAlignment;
import androidx.compose.foundation.layout.LayoutOrientation;
import androidx.compose.foundation.layout.OrientationIndependentConstraints;
import androidx.compose.foundation.layout.RowColumnImplKt;
import androidx.compose.foundation.layout.RowColumnMeasureHelperResult;
import androidx.compose.foundation.layout.RowColumnParentData;
import androidx.compose.foundation.layout.SizeMode;
import androidx.compose.ui.layout.IntrinsicMeasurable;
import androidx.compose.ui.layout.Measurable;
import androidx.compose.ui.layout.MeasureScope;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0015\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001Br\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012*\u0010\u0004\u001a&\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J2\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u00162\b\u0010-\u001a\u0004\u0018\u00010)2\u0006\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020\u0006H\u0002J(\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u00072\u0006\u00104\u001a\u000205H\u0002J3\u00106\u001a\u0002072\u0006\u00104\u001a\u0002052\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u0006\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b<\u0010=J&\u0010>\u001a\u00020\n2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u0002072\u0006\u0010B\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\bJ\n\u0010\r\u001a\u00020\u0006*\u00020\u0016J\n\u0010C\u001a\u00020\u0006*\u00020\u0016R5\u0010\u0004\u001a&\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u000b\u001a\u00020\f\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001b\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015\u00a2\u0006\n\n\u0002\u0010'\u001a\u0004\b%\u0010&R\u0018\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010)0\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010*\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006D"}, d2={"Landroidx/compose/foundation/layout/RowColumnMeasurementHelper;", "", "orientation", "Landroidx/compose/foundation/layout/LayoutOrientation;", "arrangement", "Lkotlin/Function5;", "", "", "Landroidx/compose/ui/unit/LayoutDirection;", "Landroidx/compose/ui/unit/Density;", "", "arrangementSpacing", "Landroidx/compose/ui/unit/Dp;", "crossAxisSize", "Landroidx/compose/foundation/layout/SizeMode;", "crossAxisAlignment", "Landroidx/compose/foundation/layout/CrossAxisAlignment;", "measurables", "", "Landroidx/compose/ui/layout/Measurable;", "placeables", "", "Landroidx/compose/ui/layout/Placeable;", "(Landroidx/compose/foundation/layout/LayoutOrientation;Lkotlin/jvm/functions/Function5;FLandroidx/compose/foundation/layout/SizeMode;Landroidx/compose/foundation/layout/CrossAxisAlignment;Ljava/util/List;[Landroidx/compose/ui/layout/Placeable;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getArrangement", "()Lkotlin/jvm/functions/Function5;", "getArrangementSpacing-D9Ej5fM", "()F", "F", "getCrossAxisAlignment", "()Landroidx/compose/foundation/layout/CrossAxisAlignment;", "getCrossAxisSize", "()Landroidx/compose/foundation/layout/SizeMode;", "getMeasurables", "()Ljava/util/List;", "getOrientation", "()Landroidx/compose/foundation/layout/LayoutOrientation;", "getPlaceables", "()[Landroidx/compose/ui/layout/Placeable;", "[Landroidx/compose/ui/layout/Placeable;", "rowColumnParentData", "Landroidx/compose/foundation/layout/RowColumnParentData;", "[Landroidx/compose/foundation/layout/RowColumnParentData;", "getCrossAxisPosition", "placeable", "parentData", "crossAxisLayoutSize", "layoutDirection", "beforeCrossAxisAlignmentLine", "mainAxisPositions", "mainAxisLayoutSize", "childrenMainAxisSize", "measureScope", "Landroidx/compose/ui/layout/MeasureScope;", "measureWithoutPlacing", "Landroidx/compose/foundation/layout/RowColumnMeasureHelperResult;", "constraints", "Landroidx/compose/ui/unit/Constraints;", "startIndex", "endIndex", "measureWithoutPlacing-_EkL_-Y", "(Landroidx/compose/ui/layout/MeasureScope;JII)Landroidx/compose/foundation/layout/RowColumnMeasureHelperResult;", "placeHelper", "placeableScope", "Landroidx/compose/ui/layout/Placeable$PlacementScope;", "measureResult", "crossAxisOffset", "mainAxisSize", "foundation-layout_release"})
public final class RowColumnMeasurementHelper {
    @NotNull
    private final LayoutOrientation orientation;
    @NotNull
    private final Function5<Integer, int[], LayoutDirection, Density, int[], Unit> arrangement;
    private final float arrangementSpacing;
    @NotNull
    private final SizeMode crossAxisSize;
    @NotNull
    private final CrossAxisAlignment crossAxisAlignment;
    @NotNull
    private final List<Measurable> measurables;
    @NotNull
    private final Placeable[] placeables;
    @NotNull
    private final RowColumnParentData[] rowColumnParentData;

    private RowColumnMeasurementHelper(LayoutOrientation orientation, Function5<? super Integer, ? super int[], ? super LayoutDirection, ? super Density, ? super int[], Unit> arrangement, float arrangementSpacing, SizeMode crossAxisSize, CrossAxisAlignment crossAxisAlignment, List<? extends Measurable> measurables2, Placeable[] placeables) {
        this.orientation = orientation;
        this.arrangement = arrangement;
        this.arrangementSpacing = arrangementSpacing;
        this.crossAxisSize = crossAxisSize;
        this.crossAxisAlignment = crossAxisAlignment;
        this.measurables = measurables2;
        this.placeables = placeables;
        int n = 0;
        int n2 = this.measurables.size();
        RowColumnParentData[] rowColumnParentDataArray = new RowColumnParentData[n2];
        RowColumnMeasurementHelper rowColumnMeasurementHelper = this;
        while (n < n2) {
            int n3 = n++;
            rowColumnParentDataArray[n3] = RowColumnImplKt.getRowColumnParentData((IntrinsicMeasurable)this.measurables.get(n3));
        }
        rowColumnMeasurementHelper.rowColumnParentData = rowColumnParentDataArray;
    }

    @NotNull
    public final LayoutOrientation getOrientation() {
        return this.orientation;
    }

    @NotNull
    public final Function5<Integer, int[], LayoutDirection, Density, int[], Unit> getArrangement() {
        return this.arrangement;
    }

    public final float getArrangementSpacing-D9Ej5fM() {
        return this.arrangementSpacing;
    }

    @NotNull
    public final SizeMode getCrossAxisSize() {
        return this.crossAxisSize;
    }

    @NotNull
    public final CrossAxisAlignment getCrossAxisAlignment() {
        return this.crossAxisAlignment;
    }

    @NotNull
    public final List<Measurable> getMeasurables() {
        return this.measurables;
    }

    @NotNull
    public final Placeable[] getPlaceables() {
        return this.placeables;
    }

    public final int mainAxisSize(@NotNull Placeable $this$mainAxisSize) {
        Intrinsics.checkNotNullParameter((Object)$this$mainAxisSize, (String)"<this>");
        return this.orientation == LayoutOrientation.Horizontal ? $this$mainAxisSize.getWidth() : $this$mainAxisSize.getHeight();
    }

    public final int crossAxisSize(@NotNull Placeable $this$crossAxisSize) {
        Intrinsics.checkNotNullParameter((Object)$this$crossAxisSize, (String)"<this>");
        return this.orientation == LayoutOrientation.Horizontal ? $this$crossAxisSize.getHeight() : $this$crossAxisSize.getWidth();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RowColumnMeasureHelperResult measureWithoutPlacing-_EkL_-Y(@NotNull MeasureScope measureScope, long constraints, int startIndex, int endIndex) {
        int n;
        int n2;
        Iterator iterator;
        int n3;
        Object placeable;
        Intrinsics.checkNotNullParameter((Object)measureScope, (String)"measureScope");
        OrientationIndependentConstraints constraints2 = new OrientationIndependentConstraints(constraints, this.orientation, null);
        MeasureScope $this$measureWithoutPlacing__EkL__Y_u24lambda_u240 = measureScope;
        boolean bl = false;
        int arrangementSpacingPx = $this$measureWithoutPlacing__EkL__Y_u24lambda_u240.roundToPx-0680j_4(this.arrangementSpacing);
        float totalWeight = 0.0f;
        int fixedSpace = 0;
        int crossAxisSpace = 0;
        int weightChildrenCount = 0;
        boolean anyAlignBy = false;
        int subSize = endIndex - startIndex;
        int spaceAfterLastNoWeight = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            Measurable child = this.measurables.get(i);
            RowColumnParentData parentData = this.rowColumnParentData[i];
            float weight = RowColumnImplKt.getWeight(parentData);
            if (weight > 0.0f) {
                totalWeight += weight;
                ++weightChildrenCount;
                continue;
            }
            int mainAxisMax = constraints2.getMainAxisMax();
            Placeable placeable2 = this.placeables[i];
            if (placeable2 == null) {
                placeable2 = child.measure-BRTryo0(OrientationIndependentConstraints.copy$default(constraints2, 0, mainAxisMax == Integer.MAX_VALUE ? Integer.MAX_VALUE : mainAxisMax - fixedSpace, 0, 0, 8, null).toBoxConstraints-OenEA2s(this.orientation));
            }
            placeable = placeable2;
            spaceAfterLastNoWeight = Math.min(arrangementSpacingPx, mainAxisMax - fixedSpace - this.mainAxisSize((Placeable)placeable));
            fixedSpace += this.mainAxisSize((Placeable)placeable) + spaceAfterLastNoWeight;
            crossAxisSpace = Math.max(crossAxisSpace, this.crossAxisSize((Placeable)placeable));
            anyAlignBy = anyAlignBy || RowColumnImplKt.isRelative(parentData);
            this.placeables[i] = placeable;
        }
        int weightedSpace = 0;
        if (weightChildrenCount == 0) {
            fixedSpace -= spaceAfterLastNoWeight;
        } else {
            int targetSpace = totalWeight > 0.0f && constraints2.getMainAxisMax() != Integer.MAX_VALUE ? constraints2.getMainAxisMax() : constraints2.getMainAxisMin();
            int remainingToTarget = targetSpace - fixedSpace - arrangementSpacingPx * (weightChildrenCount - 1);
            float weightUnitSpace = totalWeight > 0.0f ? (float)remainingToTarget / totalWeight : 0.0f;
            placeable = (Iterable)RangesKt.until((int)startIndex, (int)endIndex);
            n3 = remainingToTarget;
            int n4 = 0;
            iterator = placeable.iterator();
            while (iterator.hasNext()) {
                void it;
                int n5;
                n2 = n5 = ((IntIterator)iterator).nextInt();
                n = n4;
                boolean bl2 = false;
                int n6 = MathKt.roundToInt((float)(weightUnitSpace * RowColumnImplKt.getWeight(this.rowColumnParentData[it])));
                n4 = n + n6;
            }
            n = n4;
            int remainder = n3 - n;
            for (int i = startIndex; i < endIndex; ++i) {
                if (this.placeables[i] != null) continue;
                Measurable child = this.measurables.get(i);
                RowColumnParentData parentData = this.rowColumnParentData[i];
                float weight = RowColumnImplKt.getWeight(parentData);
                if (!(weight > 0.0f)) {
                    boolean $i$a$-check-RowColumnMeasurementHelper$measureWithoutPlacing$22 = false;
                    String $i$a$-check-RowColumnMeasurementHelper$measureWithoutPlacing$22 = "All weights <= 0 should have placeables";
                    throw new IllegalStateException($i$a$-check-RowColumnMeasurementHelper$measureWithoutPlacing$22.toString());
                }
                int remainderUnit = MathKt.getSign((int)remainder);
                remainder -= remainderUnit;
                int childMainAxisSize = Math.max(0, MathKt.roundToInt((float)(weightUnitSpace * weight)) + remainderUnit);
                Placeable placeable3 = child.measure-BRTryo0(new OrientationIndependentConstraints(RowColumnImplKt.getFill(parentData) && childMainAxisSize != Integer.MAX_VALUE ? childMainAxisSize : 0, childMainAxisSize, 0, constraints2.getCrossAxisMax()).toBoxConstraints-OenEA2s(this.orientation));
                weightedSpace += this.mainAxisSize(placeable3);
                crossAxisSpace = Math.max(crossAxisSpace, this.crossAxisSize(placeable3));
                anyAlignBy = anyAlignBy || RowColumnImplKt.isRelative(parentData);
                this.placeables[i] = placeable3;
            }
            weightedSpace = RangesKt.coerceAtMost((int)(weightedSpace + arrangementSpacingPx * (weightChildrenCount - 1)), (int)(constraints2.getMainAxisMax() - fixedSpace));
        }
        int beforeCrossAxisAlignmentLine = 0;
        int afterCrossAxisAlignmentLine = 0;
        if (anyAlignBy) {
            for (int i = startIndex; i < endIndex; ++i) {
                Placeable placeable4;
                Integer alignmentLinePosition;
                Intrinsics.checkNotNull((Object)this.placeables[i]);
                RowColumnParentData parentData = this.rowColumnParentData[i];
                iterator = RowColumnImplKt.getCrossAxisAlignment(parentData);
                Integer n7 = alignmentLinePosition = iterator != null ? ((CrossAxisAlignment)((Object)iterator)).calculateAlignmentLinePosition$foundation_layout_release(placeable4) : null;
                if (alignmentLinePosition == null) continue;
                int it = ((Number)alignmentLinePosition).intValue();
                boolean bl3 = false;
                int n8 = it != Integer.MIN_VALUE ? it : 0;
                beforeCrossAxisAlignmentLine = Math.max(beforeCrossAxisAlignmentLine, n8);
                it = ((Number)alignmentLinePosition).intValue();
                n3 = this.crossAxisSize(placeable4);
                boolean bl4 = false;
                n = it != Integer.MIN_VALUE ? it : this.crossAxisSize(placeable4);
                n8 = n3 - n;
                afterCrossAxisAlignmentLine = Math.max(afterCrossAxisAlignmentLine, n8);
            }
        }
        int mainAxisLayoutSize = Math.max(fixedSpace + weightedSpace, constraints2.getMainAxisMin());
        int crossAxisLayoutSize = constraints2.getCrossAxisMax() != Integer.MAX_VALUE && this.crossAxisSize == SizeMode.Expand ? constraints2.getCrossAxisMax() : Math.max(crossAxisSpace, Math.max(constraints2.getCrossAxisMin(), beforeCrossAxisAlignmentLine + afterCrossAxisAlignmentLine));
        int alignmentLinePosition = 0;
        iterator = (Iterator)new int[subSize];
        while (alignmentLinePosition < subSize) {
            int n9 = alignmentLinePosition++;
            iterator[n9] = (Iterator)false;
        }
        Iterator mainAxisPositions = iterator;
        int n10 = 0;
        int[] nArray = new int[subSize];
        while (n10 < subSize) {
            n2 = n10++;
            Placeable placeable5 = this.placeables[n2 + startIndex];
            Intrinsics.checkNotNull((Object)placeable5);
            nArray[n2] = this.mainAxisSize(placeable5);
        }
        int[] childrenMainAxisSize = nArray;
        n10 = beforeCrossAxisAlignmentLine;
        nArray = this.mainAxisPositions(mainAxisLayoutSize, childrenMainAxisSize, (int[])mainAxisPositions, measureScope);
        return new RowColumnMeasureHelperResult(crossAxisLayoutSize, mainAxisLayoutSize, startIndex, endIndex, n10, nArray);
    }

    private final int[] mainAxisPositions(int mainAxisLayoutSize, int[] childrenMainAxisSize, int[] mainAxisPositions, MeasureScope measureScope) {
        this.arrangement.invoke((Object)mainAxisLayoutSize, (Object)childrenMainAxisSize, (Object)measureScope.getLayoutDirection(), (Object)measureScope, (Object)mainAxisPositions);
        return mainAxisPositions;
    }

    private final int getCrossAxisPosition(Placeable placeable, RowColumnParentData parentData, int crossAxisLayoutSize, LayoutDirection layoutDirection, int beforeCrossAxisAlignmentLine) {
        Object object = parentData;
        if (object == null || (object = ((RowColumnParentData)object).getCrossAxisAlignment()) == null) {
            object = this.crossAxisAlignment;
        }
        Object childCrossAlignment = object;
        return ((CrossAxisAlignment)childCrossAlignment).align$foundation_layout_release(crossAxisLayoutSize - this.crossAxisSize(placeable), this.orientation == LayoutOrientation.Horizontal ? LayoutDirection.Ltr : layoutDirection, placeable, beforeCrossAxisAlignmentLine);
    }

    public final void placeHelper(@NotNull Placeable.PlacementScope placeableScope, @NotNull RowColumnMeasureHelperResult measureResult, int crossAxisOffset, @NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)placeableScope, (String)"placeableScope");
        Intrinsics.checkNotNullParameter((Object)measureResult, (String)"measureResult");
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        Placeable.PlacementScope $this$placeHelper_u24lambda_u245 = placeableScope;
        boolean bl = false;
        int n = measureResult.getEndIndex();
        for (int i = measureResult.getStartIndex(); i < n; ++i) {
            Placeable placeable = this.placeables[i];
            Intrinsics.checkNotNull((Object)placeable);
            int[] mainAxisPositions = measureResult.getMainAxisPositions();
            Object object = this.measurables.get(i).getParentData();
            int crossAxisPosition = this.getCrossAxisPosition(placeable, object instanceof RowColumnParentData ? (RowColumnParentData)object : null, measureResult.getCrossAxisSize(), layoutDirection, measureResult.getBeforeCrossAxisAlignmentLine()) + crossAxisOffset;
            if (this.orientation == LayoutOrientation.Horizontal) {
                Placeable.PlacementScope.place$default((Placeable.PlacementScope)$this$placeHelper_u24lambda_u245, (Placeable)placeable, (int)mainAxisPositions[i - measureResult.getStartIndex()], (int)crossAxisPosition, (float)0.0f, (int)4, null);
                continue;
            }
            Placeable.PlacementScope.place$default((Placeable.PlacementScope)$this$placeHelper_u24lambda_u245, (Placeable)placeable, (int)crossAxisPosition, (int)mainAxisPositions[i - measureResult.getStartIndex()], (float)0.0f, (int)4, null);
        }
    }

    public /* synthetic */ RowColumnMeasurementHelper(LayoutOrientation orientation, Function5 arrangement, float arrangementSpacing, SizeMode crossAxisSize, CrossAxisAlignment crossAxisAlignment, List measurables2, Placeable[] placeables, DefaultConstructorMarker $constructor_marker) {
        this(orientation, (Function5<? super Integer, ? super int[], ? super LayoutDirection, ? super Density, ? super int[], Unit>)arrangement, arrangementSpacing, crossAxisSize, crossAxisAlignment, measurables2, placeables);
    }
}

