/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.automirrored.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.AutoMirrored.TwoTone.Send: ImageVector
    get() {
        if (_send != null) {
            return _send!!
        }
        _send = materialIcon(name = "AutoMirrored.TwoTone.Send", autoMirror = true) {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(4.0f, 8.25f)
                lineToRelative(7.51f, 1.0f)
                lineToRelative(-7.5f, -3.22f)
                close()
                moveTo(4.01f, 17.97f)
                lineToRelative(7.5f, -3.22f)
                lineToRelative(-7.51f, 1.0f)
                close()
            }
            materialPath {
                moveTo(2.01f, 3.0f)
                lineTo(2.0f, 10.0f)
                lineToRelative(15.0f, 2.0f)
                lineToRelative(-15.0f, 2.0f)
                lineToRelative(0.01f, 7.0f)
                lineTo(23.0f, 12.0f)
                lineTo(2.01f, 3.0f)
                close()
                moveTo(4.0f, 8.25f)
                lineTo(4.0f, 6.03f)
                lineToRelative(7.51f, 3.22f)
                lineToRelative(-7.51f, -1.0f)
                close()
                moveTo(4.01f, 17.97f)
                verticalLineToRelative(-2.22f)
                lineToRelative(7.51f, -1.0f)
                lineToRelative(-7.51f, 3.22f)
                close()
            }
        }
        return _send!!
    }

private var _send: ImageVector? = null
