/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector
import kotlin.Deprecated

@Deprecated(
    "Use the AutoMirrored version at Icons.AutoMirrored.Rounded.Send",
    ReplaceWith( "Icons.AutoMirrored.Rounded.Send",
            "androidx.compose.material.icons.automirrored.rounded.Send"),
)
public val Icons.Rounded.Send: ImageVector
    get() {
        if (_send != null) {
            return _send!!
        }
        _send = materialIcon(name = "Rounded.Send") {
            materialPath {
                moveTo(3.4f, 20.4f)
                lineToRelative(17.45f, -7.48f)
                curveToRelative(0.81f, -0.35f, 0.81f, -1.49f, 0.0f, -1.84f)
                lineTo(3.4f, 3.6f)
                curveToRelative(-0.66f, -0.29f, -1.39f, 0.2f, -1.39f, 0.91f)
                lineTo(2.0f, 9.12f)
                curveToRelative(0.0f, 0.5f, 0.37f, 0.93f, 0.87f, 0.99f)
                lineTo(17.0f, 12.0f)
                lineTo(2.87f, 13.88f)
                curveToRelative(-0.5f, 0.07f, -0.87f, 0.5f, -0.87f, 1.0f)
                lineToRelative(0.01f, 4.61f)
                curveToRelative(0.0f, 0.71f, 0.73f, 1.2f, 1.39f, 0.91f)
                close()
            }
        }
        return _send!!
    }

private var _send: ImageVector? = null
