/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.VectorAsset

val Icons.Rounded.Refresh: VectorAsset
    get() {
        if (icon != null) return icon!!
        icon = materialIcon {
            materialPath {
                moveTo(17.65f, 6.35f)
                curveToRelative(-1.63f, -1.63f, -3.94f, -2.57f, -6.48f, -2.31f)
                curveToRelative(-3.67f, 0.37f, -6.69f, 3.35f, -7.1f, 7.02f)
                curveTo(3.52f, 15.91f, 7.27f, 20.0f, 12.0f, 20.0f)
                curveToRelative(3.19f, 0.0f, 5.93f, -1.87f, 7.21f, -4.56f)
                curveToRelative(0.32f, -0.67f, -0.16f, -1.44f, -0.9f, -1.44f)
                curveToRelative(-0.37f, 0.0f, -0.72f, 0.2f, -0.88f, 0.53f)
                curveToRelative(-1.13f, 2.43f, -3.84f, 3.97f, -6.8f, 3.31f)
                curveToRelative(-2.22f, -0.49f, -4.01f, -2.3f, -4.48f, -4.52f)
                curveTo(5.31f, 9.44f, 8.26f, 6.0f, 12.0f, 6.0f)
                curveToRelative(1.66f, 0.0f, 3.14f, 0.69f, 4.22f, 1.78f)
                lineToRelative(-1.51f, 1.51f)
                curveToRelative(-0.63f, 0.63f, -0.19f, 1.71f, 0.7f, 1.71f)
                horizontalLineTo(19.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineTo(6.41f)
                curveToRelative(0.0f, -0.89f, -1.08f, -1.34f, -1.71f, -0.71f)
                lineToRelative(-0.64f, 0.65f)
                close()
            }
        }
        return icon!!
    }

private var icon: VectorAsset? = null
