/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.VectorAsset

val Icons.Outlined.Face: VectorAsset
    get() {
        if (_face != null) {
            return _face!!
        }
        _face = materialIcon {
            materialPath {
                moveTo(10.25f, 13.0f)
                curveToRelative(0.0f, 0.69f, -0.56f, 1.25f, -1.25f, 1.25f)
                reflectiveCurveTo(7.75f, 13.69f, 7.75f, 13.0f)
                reflectiveCurveToRelative(0.56f, -1.25f, 1.25f, -1.25f)
                reflectiveCurveToRelative(1.25f, 0.56f, 1.25f, 1.25f)
                close()
                moveTo(15.0f, 11.75f)
                curveToRelative(-0.69f, 0.0f, -1.25f, 0.56f, -1.25f, 1.25f)
                reflectiveCurveToRelative(0.56f, 1.25f, 1.25f, 1.25f)
                reflectiveCurveToRelative(1.25f, -0.56f, 1.25f, -1.25f)
                reflectiveCurveToRelative(-0.56f, -1.25f, -1.25f, -1.25f)
                close()
                moveTo(22.0f, 12.0f)
                curveToRelative(0.0f, 5.52f, -4.48f, 10.0f, -10.0f, 10.0f)
                reflectiveCurveTo(2.0f, 17.52f, 2.0f, 12.0f)
                reflectiveCurveTo(6.48f, 2.0f, 12.0f, 2.0f)
                reflectiveCurveToRelative(10.0f, 4.48f, 10.0f, 10.0f)
                close()
                moveTo(10.66f, 4.12f)
                curveTo(12.06f, 6.44f, 14.6f, 8.0f, 17.5f, 8.0f)
                curveToRelative(0.46f, 0.0f, 0.91f, -0.05f, 1.34f, -0.12f)
                curveTo(17.44f, 5.56f, 14.9f, 4.0f, 12.0f, 4.0f)
                curveToRelative(-0.46f, 0.0f, -0.91f, 0.05f, -1.34f, 0.12f)
                close()
                moveTo(4.42f, 9.47f)
                curveToRelative(1.71f, -0.97f, 3.03f, -2.55f, 3.66f, -4.44f)
                curveTo(6.37f, 6.0f, 5.05f, 7.58f, 4.42f, 9.47f)
                close()
                moveTo(20.0f, 12.0f)
                curveToRelative(0.0f, -0.78f, -0.12f, -1.53f, -0.33f, -2.24f)
                curveToRelative(-0.7f, 0.15f, -1.42f, 0.24f, -2.17f, 0.24f)
                curveToRelative(-3.13f, 0.0f, -5.92f, -1.44f, -7.76f, -3.69f)
                curveTo(8.69f, 8.87f, 6.6f, 10.88f, 4.0f, 11.86f)
                curveToRelative(0.01f, 0.04f, 0.0f, 0.09f, 0.0f, 0.14f)
                curveToRelative(0.0f, 4.41f, 3.59f, 8.0f, 8.0f, 8.0f)
                reflectiveCurveToRelative(8.0f, -3.59f, 8.0f, -8.0f)
                close()
            }
        }
        return _face!!
    }

private var _face: VectorAsset? = null
