/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.VectorAsset

val Icons.Sharp.ThumbUp: VectorAsset
    get() {
        if (_thumbUp != null) {
            return _thumbUp!!
        }
        _thumbUp = materialIcon {
            materialPath {
                moveTo(14.17f, 1.0f)
                lineTo(7.0f, 8.18f)
                verticalLineTo(21.0f)
                horizontalLineToRelative(12.31f)
                lineTo(23.0f, 12.4f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(-8.31f)
                lineToRelative(1.12f, -5.38f)
                close()
                moveTo(1.0f, 9.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(12.0f)
                horizontalLineTo(1.0f)
                close()
            }
        }
        return _thumbUp!!
    }

private var _thumbUp: VectorAsset? = null
