/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.VectorAsset

val Icons.TwoTone.Email: VectorAsset
    get() {
        if (_email != null) {
            return _email!!
        }
        _email = materialIcon {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(20.0f, 8.0f)
                lineToRelative(-8.0f, 5.0f)
                lineToRelative(-8.0f, -5.0f)
                verticalLineToRelative(10.0f)
                horizontalLineToRelative(16.0f)
                close()
                moveTo(20.0f, 6.0f)
                lineTo(4.0f, 6.0f)
                lineToRelative(8.0f, 4.99f)
                close()
            }
            materialPath {
                moveTo(4.0f, 20.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(6.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(4.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                close()
                moveTo(20.0f, 6.0f)
                lineToRelative(-8.0f, 4.99f)
                lineTo(4.0f, 6.0f)
                horizontalLineToRelative(16.0f)
                close()
                moveTo(4.0f, 8.0f)
                lineToRelative(8.0f, 5.0f)
                lineToRelative(8.0f, -5.0f)
                verticalLineToRelative(10.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(8.0f)
                close()
            }
        }
        return _email!!
    }

private var _email: VectorAsset? = null
