/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Build: ImageVector
    get() {
        if (_build != null) {
            return _build!!
        }
        _build = materialIcon(name = "Rounded.Build") {
            materialPath {
                moveTo(19.65f, 16.11f)
                lineToRelative(-5.03f, -5.03f)
                curveToRelative(0.42f, -1.14f, 0.53f, -2.43f, 0.13f, -3.78f)
                curveToRelative(-0.61f, -2.08f, -2.34f, -3.72f, -4.45f, -4.17f)
                curveTo(8.61f, 2.78f, 7.01f, 3.14f, 5.74f, 3.97f)
                lineToRelative(3.64f, 3.64f)
                lineTo(7.61f, 9.38f)
                lineTo(3.97f, 5.74f)
                curveTo(3.14f, 7.01f, 2.78f, 8.61f, 3.14f, 10.3f)
                curveToRelative(0.45f, 2.12f, 2.09f, 3.85f, 4.16f, 4.45f)
                curveToRelative(1.36f, 0.4f, 2.65f, 0.29f, 3.78f, -0.13f)
                lineToRelative(5.03f, 5.03f)
                curveToRelative(0.98f, 0.98f, 2.56f, 0.98f, 3.54f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveTo(20.62f, 18.67f, 20.62f, 17.09f, 19.65f, 16.11f)
                close()
            }
        }
        return _build!!
    }

private var _build: ImageVector? = null
