/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.MailOutline: ImageVector
    get() {
        if (_mailOutline != null) {
            return _mailOutline!!
        }
        _mailOutline = materialIcon(name = "Rounded.MailOutline") {
            materialPath {
                moveTo(20.0f, 4.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 4.0f, 2.01f, 4.9f, 2.01f, 6.0f)
                lineTo(2.0f, 18.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(6.0f)
                curveTo(22.0f, 4.9f, 21.1f, 4.0f, 20.0f, 4.0f)
                close()
                moveTo(19.6f, 8.25f)
                lineToRelative(-7.07f, 4.42f)
                curveToRelative(-0.32f, 0.2f, -0.74f, 0.2f, -1.06f, 0.0f)
                lineTo(4.4f, 8.25f)
                curveTo(4.15f, 8.09f, 4.0f, 7.82f, 4.0f, 7.53f)
                curveToRelative(0.0f, -0.67f, 0.73f, -1.07f, 1.3f, -0.72f)
                lineTo(12.0f, 11.0f)
                lineToRelative(6.7f, -4.19f)
                curveTo(19.27f, 6.46f, 20.0f, 6.86f, 20.0f, 7.53f)
                curveTo(20.0f, 7.82f, 19.85f, 8.09f, 19.6f, 8.25f)
                close()
            }
        }
        return _mailOutline!!
    }

private var _mailOutline: ImageVector? = null
