/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Search: ImageVector
    get() {
        if (_search != null) {
            return _search!!
        }
        _search = materialIcon(name = "Rounded.Search") {
            materialPath {
                moveTo(20.29f, 18.88f)
                lineToRelative(-5.56f, -5.56f)
                curveToRelative(1.13f, -1.55f, 1.63f, -3.58f, 0.98f, -5.74f)
                curveToRelative(-0.68f, -2.23f, -2.57f, -3.98f, -4.85f, -4.44f)
                curveTo(6.21f, 2.2f, 2.2f, 6.22f, 3.14f, 10.86f)
                curveToRelative(0.46f, 2.29f, 2.21f, 4.18f, 4.44f, 4.85f)
                curveToRelative(2.16f, 0.65f, 4.19f, 0.15f, 5.74f, -0.98f)
                lineToRelative(5.56f, 5.56f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveTo(20.68f, 19.9f, 20.68f, 19.27f, 20.29f, 18.88f)
                close()
                moveTo(5.0f, 9.5f)
                curveTo(5.0f, 7.01f, 7.01f, 5.0f, 9.5f, 5.0f)
                reflectiveCurveTo(14.0f, 7.01f, 14.0f, 9.5f)
                reflectiveCurveTo(11.99f, 14.0f, 9.5f, 14.0f)
                reflectiveCurveTo(5.0f, 11.99f, 5.0f, 9.5f)
                close()
            }
        }
        return _search!!
    }

private var _search: ImageVector? = null
