/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Favorite: ImageVector
    get() {
        if (_favorite != null) {
            return _favorite!!
        }
        _favorite = materialIcon(name = "Rounded.Favorite") {
            materialPath {
                moveTo(10.67f, 19.8f)
                curveTo(5.15f, 14.85f, 1.95f, 12.16f, 2.0f, 8.41f)
                curveToRelative(0.04f, -2.97f, 2.3f, -4.39f, 2.35f, -4.43f)
                curveTo(7.96f, 1.52f, 11.24f, 4.2f, 12.0f, 5.09f)
                curveToRelative(0.75f, -0.88f, 3.99f, -3.51f, 7.56f, -1.16f)
                curveToRelative(0.52f, 0.34f, 2.23f, 1.65f, 2.42f, 4.12f)
                curveToRelative(0.32f, 4.28f, -4.14f, 7.76f, -8.65f, 11.76f)
                curveToRelative(-0.38f, 0.34f, -0.86f, 0.5f, -1.34f, 0.5f)
                curveTo(11.52f, 20.31f, 11.05f, 20.14f, 10.67f, 19.8f)
                close()
            }
        }
        return _favorite!!
    }

private var _favorite: ImageVector? = null
