/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Send: ImageVector
    get() {
        if (_send != null) {
            return _send!!
        }
        _send = materialIcon(name = "Rounded.Send") {
            materialPath {
                moveTo(3.0f, 5.51f)
                verticalLineToRelative(3.71f)
                curveToRelative(0.0f, 0.46f, 0.31f, 0.86f, 0.76f, 0.97f)
                lineTo(11.0f, 12.0f)
                lineToRelative(-7.24f, 1.81f)
                curveTo(3.31f, 13.92f, 3.0f, 14.32f, 3.0f, 14.78f)
                verticalLineToRelative(3.71f)
                curveToRelative(0.0f, 0.72f, 0.73f, 1.2f, 1.39f, 0.92f)
                lineToRelative(15.42f, -6.49f)
                curveToRelative(0.82f, -0.34f, 0.82f, -1.5f, 0.0f, -1.84f)
                lineTo(4.39f, 4.58f)
                curveTo(3.73f, 4.31f, 3.0f, 4.79f, 3.0f, 5.51f)
                close()
            }
        }
        return _send!!
    }

private var _send: ImageVector? = null
