/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.ShoppingCart: ImageVector
    get() {
        if (_shoppingCart != null) {
            return _shoppingCart!!
        }
        _shoppingCart = materialIcon(name = "Rounded.ShoppingCart") {
            materialPath {
                moveTo(15.55f, 13.0f)
                curveToRelative(1.22f, 0.0f, 1.74f, -1.01f, 1.75f, -1.03f)
                lineToRelative(3.55f, -6.44f)
                curveToRelative(0.23f, -0.45f, 0.18f, -0.84f, -0.01f, -1.11f)
                curveTo(20.66f, 4.16f, 20.33f, 4.0f, 20.0f, 4.0f)
                curveTo(19.99f, 4.0f, 5.21f, 4.0f, 5.21f, 4.0f)
                lineTo(4.54f, 2.57f)
                curveTo(4.38f, 2.22f, 4.02f, 2.0f, 3.64f, 2.0f)
                horizontalLineTo(2.0f)
                curveTo(1.45f, 2.0f, 1.0f, 2.45f, 1.0f, 3.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(1.0f)
                lineToRelative(3.6f, 7.59f)
                lineToRelative(-1.35f, 2.44f)
                curveTo(4.52f, 15.37f, 5.48f, 17.0f, 7.0f, 17.0f)
                horizontalLineToRelative(11.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(7.0f)
                lineToRelative(1.1f, -2.0f)
                horizontalLineTo(15.55f)
                close()
            }
            materialPath {
                moveTo(7.0f, 20.0f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
            materialPath {
                moveTo(17.0f, 20.0f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
        }
        return _shoppingCart!!
    }

private var _shoppingCart: ImageVector? = null
