/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.automirrored.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.AutoMirrored.Sharp.Rtt: ImageVector
    get() {
        if (_rtt != null) {
            return _rtt!!
        }
        _rtt = materialIcon(name = "AutoMirrored.Sharp.Rtt", autoMirror = true) {
            materialPath {
                moveTo(9.03f, 3.0f)
                lineToRelative(-1.11f, 7.07f)
                horizontalLineToRelative(2.62f)
                lineToRelative(0.7f, -4.5f)
                horizontalLineToRelative(2.58f)
                lineTo(11.8f, 18.43f)
                horizontalLineTo(9.47f)
                lineTo(9.06f, 21.0f)
                horizontalLineToRelative(7.27f)
                lineToRelative(0.4f, -2.57f)
                horizontalLineToRelative(-2.35f)
                lineToRelative(2.0f, -12.86f)
                horizontalLineToRelative(2.58f)
                lineToRelative(-0.71f, 4.5f)
                horizontalLineToRelative(2.65f)
                lineTo(22.0f, 3.0f)
                horizontalLineTo(9.03f)
                close()
                moveTo(8.0f, 5.0f)
                horizontalLineTo(4.0f)
                lineTo(3.69f, 7.0f)
                horizontalLineToRelative(4.0f)
                lineTo(8.0f, 5.0f)
                close()
                moveTo(7.39f, 9.0f)
                horizontalLineToRelative(-4.0f)
                lineToRelative(-0.31f, 2.0f)
                horizontalLineToRelative(4.0f)
                lineTo(7.39f, 9.0f)
                close()
                moveTo(8.31f, 17.0f)
                horizontalLineToRelative(-6.0f)
                lineTo(2.0f, 19.0f)
                horizontalLineToRelative(6.0f)
                lineTo(8.31f, 17.0f)
                close()
                moveTo(8.93f, 13.0f)
                horizontalLineToRelative(-6.0f)
                lineToRelative(-0.31f, 2.0f)
                horizontalLineToRelative(6.01f)
                lineTo(8.93f, 13.0f)
                close()
            }
        }
        return _rtt!!
    }

private var _rtt: ImageVector? = null
