/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.SettingsApplications: ImageVector
    get() {
        if (_settingsApplications != null) {
            return _settingsApplications!!
        }
        _settingsApplications = materialIcon(name = "Filled.SettingsApplications") {
            materialPath {
                moveTo(12.0f, 10.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveToRelative(0.9f, 2.0f, 2.0f, 2.0f)
                reflectiveCurveToRelative(2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveToRelative(-0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(19.0f, 3.0f)
                lineTo(5.0f, 3.0f)
                curveToRelative(-1.11f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.89f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.11f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(21.0f, 5.0f)
                curveToRelative(0.0f, -1.1f, -0.89f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(17.25f, 12.0f)
                curveToRelative(0.0f, 0.23f, -0.02f, 0.46f, -0.05f, 0.68f)
                lineToRelative(1.48f, 1.16f)
                curveToRelative(0.13f, 0.11f, 0.17f, 0.3f, 0.08f, 0.45f)
                lineToRelative(-1.4f, 2.42f)
                curveToRelative(-0.09f, 0.15f, -0.27f, 0.21f, -0.43f, 0.15f)
                lineToRelative(-1.74f, -0.7f)
                curveToRelative(-0.36f, 0.28f, -0.76f, 0.51f, -1.18f, 0.69f)
                lineToRelative(-0.26f, 1.85f)
                curveToRelative(-0.03f, 0.17f, -0.18f, 0.3f, -0.35f, 0.3f)
                horizontalLineToRelative(-2.8f)
                curveToRelative(-0.17f, 0.0f, -0.32f, -0.13f, -0.35f, -0.29f)
                lineToRelative(-0.26f, -1.85f)
                curveToRelative(-0.43f, -0.18f, -0.82f, -0.41f, -1.18f, -0.69f)
                lineToRelative(-1.74f, 0.7f)
                curveToRelative(-0.16f, 0.06f, -0.34f, 0.0f, -0.43f, -0.15f)
                lineToRelative(-1.4f, -2.42f)
                curveToRelative(-0.09f, -0.15f, -0.05f, -0.34f, 0.08f, -0.45f)
                lineToRelative(1.48f, -1.16f)
                curveToRelative(-0.03f, -0.23f, -0.05f, -0.46f, -0.05f, -0.69f)
                curveToRelative(0.0f, -0.23f, 0.02f, -0.46f, 0.05f, -0.68f)
                lineToRelative(-1.48f, -1.16f)
                curveToRelative(-0.13f, -0.11f, -0.17f, -0.3f, -0.08f, -0.45f)
                lineToRelative(1.4f, -2.42f)
                curveToRelative(0.09f, -0.15f, 0.27f, -0.21f, 0.43f, -0.15f)
                lineToRelative(1.74f, 0.7f)
                curveToRelative(0.36f, -0.28f, 0.76f, -0.51f, 1.18f, -0.69f)
                lineToRelative(0.26f, -1.85f)
                curveToRelative(0.03f, -0.17f, 0.18f, -0.3f, 0.35f, -0.3f)
                horizontalLineToRelative(2.8f)
                curveToRelative(0.17f, 0.0f, 0.32f, 0.13f, 0.35f, 0.29f)
                lineToRelative(0.26f, 1.85f)
                curveToRelative(0.43f, 0.18f, 0.82f, 0.41f, 1.18f, 0.69f)
                lineToRelative(1.74f, -0.7f)
                curveToRelative(0.16f, -0.06f, 0.34f, 0.0f, 0.43f, 0.15f)
                lineToRelative(1.4f, 2.42f)
                curveToRelative(0.09f, 0.15f, 0.05f, 0.34f, -0.08f, 0.45f)
                lineToRelative(-1.48f, 1.16f)
                curveToRelative(0.03f, 0.23f, 0.05f, 0.46f, 0.05f, 0.69f)
                close()
            }
        }
        return _settingsApplications!!
    }

private var _settingsApplications: ImageVector? = null
