/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Doorbell: ImageVector
    get() {
        if (_doorbell != null) {
            return _doorbell!!
        }
        _doorbell = materialIcon(name = "Outlined.Doorbell") {
            materialPath {
                moveTo(11.0f, 16.5f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveTo(11.0f, 17.05f, 11.0f, 16.5f)
                close()
                moveTo(15.0f, 15.0f)
                verticalLineToRelative(-2.34f)
                curveToRelative(0.0f, -1.54f, -0.81f, -2.82f, -2.25f, -3.16f)
                verticalLineTo(9.25f)
                curveToRelative(0.0f, -0.41f, -0.34f, -0.75f, -0.75f, -0.75f)
                reflectiveCurveToRelative(-0.75f, 0.34f, -0.75f, 0.75f)
                verticalLineTo(9.5f)
                curveTo(9.82f, 9.84f, 9.0f, 11.12f, 9.0f, 12.66f)
                verticalLineTo(15.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineTo(15.0f)
                close()
                moveTo(12.0f, 5.5f)
                lineTo(6.0f, 10.0f)
                verticalLineToRelative(9.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(-9.0f)
                lineTo(12.0f, 5.5f)
                moveTo(12.0f, 3.0f)
                lineToRelative(8.0f, 6.0f)
                verticalLineToRelative(12.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(9.0f)
                lineTo(12.0f, 3.0f)
                close()
            }
        }
        return _doorbell!!
    }

private var _doorbell: ImageVector? = null
