/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.ZoomInMap: ImageVector
    get() {
        if (_zoomInMap != null) {
            return _zoomInMap!!
        }
        _zoomInMap = materialIcon(name = "Outlined.ZoomInMap") {
            materialPath {
                moveTo(9.0f, 9.0f)
                lineToRelative(0.0f, -6.0f)
                lineTo(7.0f, 3.0f)
                lineToRelative(0.0f, 2.59f)
                lineTo(3.91f, 2.5f)
                lineTo(2.5f, 3.91f)
                lineTo(5.59f, 7.0f)
                lineTo(3.0f, 7.0f)
                lineToRelative(0.0f, 2.0f)
                lineTo(9.0f, 9.0f)
                close()
                moveTo(21.0f, 9.0f)
                verticalLineTo(7.0f)
                lineToRelative(-2.59f, 0.0f)
                lineToRelative(3.09f, -3.09f)
                lineTo(20.09f, 2.5f)
                lineTo(17.0f, 5.59f)
                verticalLineTo(3.0f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, 6.0f)
                lineTo(21.0f, 9.0f)
                close()
                moveTo(3.0f, 15.0f)
                lineToRelative(0.0f, 2.0f)
                horizontalLineToRelative(2.59f)
                lineTo(2.5f, 20.09f)
                lineToRelative(1.41f, 1.41f)
                lineTo(7.0f, 18.41f)
                lineTo(7.0f, 21.0f)
                horizontalLineToRelative(2.0f)
                lineToRelative(0.0f, -6.0f)
                lineTo(3.0f, 15.0f)
                close()
                moveTo(15.0f, 15.0f)
                lineToRelative(0.0f, 6.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-2.59f)
                lineToRelative(3.09f, 3.09f)
                lineToRelative(1.41f, -1.41f)
                lineTo(18.41f, 17.0f)
                horizontalLineTo(21.0f)
                verticalLineToRelative(-2.0f)
                lineTo(15.0f, 15.0f)
                close()
            }
        }
        return _zoomInMap!!
    }

private var _zoomInMap: ImageVector? = null
