/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Functions: ImageVector
    get() {
        if (_functions != null) {
            return _functions!!
        }
        _functions = materialIcon(name = "Rounded.Functions") {
            materialPath {
                moveTo(16.5f, 4.0f)
                horizontalLineTo(7.56f)
                curveTo(6.7f, 4.0f, 6.0f, 4.7f, 6.0f, 5.56f)
                curveToRelative(0.0f, 0.28f, 0.12f, 0.55f, 0.32f, 0.74f)
                lineTo(12.5f, 12.0f)
                lineToRelative(-6.18f, 5.7f)
                curveToRelative(-0.2f, 0.19f, -0.32f, 0.46f, -0.32f, 0.74f)
                curveTo(6.0f, 19.3f, 6.7f, 20.0f, 7.56f, 20.0f)
                horizontalLineToRelative(8.94f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                reflectiveCurveToRelative(-0.67f, -1.5f, -1.5f, -1.5f)
                horizontalLineTo(11.0f)
                lineToRelative(3.59f, -3.59f)
                curveToRelative(0.78f, -0.78f, 0.78f, -2.05f, 0.0f, -2.83f)
                lineTo(11.0f, 7.0f)
                horizontalLineToRelative(5.5f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                reflectiveCurveTo(17.33f, 4.0f, 16.5f, 4.0f)
                close()
            }
        }
        return _functions!!
    }

private var _functions: ImageVector? = null
