/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector
import kotlin.Deprecated

@Deprecated(
    "Use the AutoMirrored version at Icons.AutoMirrored.Rounded.LabelOff",
    ReplaceWith( "Icons.AutoMirrored.Rounded.LabelOff",
            "androidx.compose.material.icons.automirrored.rounded.LabelOff"),
)
public val Icons.Rounded.LabelOff: ImageVector
    get() {
        if (_labelOff != null) {
            return _labelOff!!
        }
        _labelOff = materialIcon(name = "Rounded.LabelOff") {
            materialPath {
                moveTo(21.59f, 12.58f)
                curveToRelative(0.25f, -0.35f, 0.25f, -0.81f, 0.0f, -1.16f)
                lineToRelative(-3.96f, -5.58f)
                curveTo(17.27f, 5.33f, 16.67f, 5.0f, 16.0f, 5.0f)
                horizontalLineTo(8.66f)
                lineToRelative(10.7f, 10.73f)
                lineToRelative(2.23f, -3.15f)
                close()
                moveTo(2.72f, 4.72f)
                lineToRelative(0.87f, 0.87f)
                curveTo(3.23f, 5.95f, 3.0f, 6.45f, 3.0f, 7.0f)
                verticalLineToRelative(10.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(12.0f)
                lineToRelative(1.29f, 1.29f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineTo(4.14f, 3.31f)
                curveToRelative(-0.38f, -0.38f, -1.01f, -0.39f, -1.4f, -0.01f)
                curveToRelative(-0.41f, 0.38f, -0.41f, 1.03f, -0.02f, 1.42f)
                close()
            }
        }
        return _labelOff!!
    }

private var _labelOff: ImageVector? = null
