/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.LocalDrink: ImageVector
    get() {
        if (_localDrink != null) {
            return _localDrink!!
        }
        _localDrink = materialIcon(name = "Rounded.LocalDrink") {
            materialPath {
                moveTo(5.23f, 2.0f)
                curveTo(4.04f, 2.0f, 3.11f, 3.04f, 3.24f, 4.22f)
                lineToRelative(1.77f, 16.01f)
                curveTo(5.13f, 21.23f, 5.97f, 22.0f, 7.0f, 22.0f)
                horizontalLineToRelative(10.0f)
                curveToRelative(1.03f, 0.0f, 1.87f, -0.77f, 1.99f, -1.77f)
                lineToRelative(1.77f, -16.01f)
                curveToRelative(0.13f, -1.18f, -0.8f, -2.22f, -1.99f, -2.22f)
                lineTo(5.23f, 2.0f)
                close()
                moveTo(12.0f, 19.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, -1.34f, -3.0f, -3.0f)
                curveToRelative(0.0f, -1.55f, 1.81f, -3.95f, 2.62f, -4.94f)
                curveToRelative(0.2f, -0.25f, 0.57f, -0.25f, 0.77f, 0.0f)
                curveToRelative(0.81f, 1.0f, 2.62f, 3.39f, 2.62f, 4.94f)
                curveToRelative(-0.01f, 1.66f, -1.35f, 3.0f, -3.01f, 3.0f)
                close()
                moveTo(18.33f, 8.0f)
                lineTo(5.67f, 8.0f)
                lineToRelative(-0.32f, -2.89f)
                curveToRelative(-0.06f, -0.59f, 0.4f, -1.11f, 1.0f, -1.11f)
                horizontalLineToRelative(11.3f)
                curveToRelative(0.59f, 0.0f, 1.06f, 0.52f, 0.99f, 1.11f)
                lineTo(18.33f, 8.0f)
                close()
            }
        }
        return _localDrink!!
    }

private var _localDrink: ImageVector? = null
