/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.MacroOff: ImageVector
    get() {
        if (_macroOff != null) {
            return _macroOff!!
        }
        _macroOff = materialIcon(name = "Rounded.MacroOff") {
            materialPath {
                moveTo(4.2f, 13.08f)
                curveToRelative(-0.64f, -0.09f, -1.21f, 0.48f, -1.12f, 1.12f)
                curveTo(3.67f, 18.6f, 7.44f, 22.0f, 12.0f, 22.0f)
                curveTo(12.0f, 17.44f, 8.6f, 13.67f, 4.2f, 13.08f)
                close()
            }
            materialPath {
                moveTo(12.0f, 5.5f)
                curveToRelative(1.38f, 0.0f, 2.5f, 1.12f, 2.5f, 2.5f)
                curveToRelative(0.0f, 0.99f, -0.58f, 1.84f, -1.42f, 2.25f)
                lineToRelative(2.48f, 2.48f)
                curveToRelative(0.11f, 0.02f, 0.23f, 0.03f, 0.35f, 0.03f)
                curveToRelative(1.38f, 0.0f, 2.5f, -1.12f, 2.5f, -2.5f)
                curveToRelative(0.0f, -1.0f, -0.59f, -1.85f, -1.43f, -2.25f)
                curveToRelative(0.84f, -0.4f, 1.43f, -1.25f, 1.43f, -2.25f)
                curveToRelative(0.0f, -1.38f, -1.12f, -2.5f, -2.5f, -2.5f)
                curveToRelative(-0.53f, 0.0f, -1.01f, 0.16f, -1.42f, 0.44f)
                lineTo(14.5f, 3.5f)
                curveTo(14.5f, 2.12f, 13.38f, 1.0f, 12.0f, 1.0f)
                reflectiveCurveTo(9.5f, 2.12f, 9.5f, 3.5f)
                lineToRelative(0.02f, 0.19f)
                curveTo(9.12f, 3.41f, 8.63f, 3.25f, 8.1f, 3.25f)
                curveToRelative(-0.57f, 0.0f, -1.09f, 0.2f, -1.51f, 0.52f)
                lineToRelative(3.16f, 3.16f)
                curveTo(10.16f, 6.08f, 11.01f, 5.5f, 12.0f, 5.5f)
                close()
            }
            materialPath {
                moveTo(19.98f, 17.15f)
                curveToRelative(0.47f, -0.91f, 0.8f, -1.9f, 0.94f, -2.95f)
                curveToRelative(0.09f, -0.64f, -0.48f, -1.21f, -1.12f, -1.12f)
                curveToRelative(-1.05f, 0.14f, -2.05f, 0.47f, -2.95f, 0.94f)
                lineTo(19.98f, 17.15f)
                close()
            }
            materialPath {
                moveTo(2.1f, 3.51f)
                lineTo(2.1f, 3.51f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(3.93f, 3.93f)
                curveToRelative(-0.35f, 0.52f, -0.53f, 1.17f, -0.38f, 1.89f)
                curveToRelative(0.22f, 1.13f, 1.26f, 1.98f, 2.41f, 2.0f)
                curveToRelative(0.54f, 0.01f, 1.02f, -0.15f, 1.44f, -0.43f)
                lineToRelative(0.02f, 0.02f)
                lineTo(9.5f, 12.5f)
                curveToRelative(0.0f, 1.38f, 1.12f, 2.5f, 2.5f, 2.5f)
                curveToRelative(0.05f, 0.0f, 0.1f, -0.01f, 0.16f, -0.02f)
                lineToRelative(1.64f, 1.64f)
                curveTo(12.67f, 18.12f, 12.0f, 19.98f, 12.0f, 22.0f)
                curveToRelative(2.02f, 0.0f, 3.88f, -0.67f, 5.38f, -1.79f)
                lineToRelative(1.69f, 1.69f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineTo(3.51f, 3.51f)
                curveTo(3.12f, 3.12f, 2.49f, 3.12f, 2.1f, 3.51f)
                close()
            }
        }
        return _macroOff!!
    }

private var _macroOff: ImageVector? = null
