/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SimCardDownload: ImageVector
    get() {
        if (_simCardDownload != null) {
            return _simCardDownload!!
        }
        _simCardDownload = materialIcon(name = "Rounded.SimCardDownload") {
            materialPath {
                moveTo(18.0f, 2.0f)
                horizontalLineToRelative(-7.17f)
                curveTo(10.3f, 2.0f, 9.79f, 2.21f, 9.41f, 2.59f)
                lineTo(4.59f, 7.41f)
                curveTo(4.21f, 7.79f, 4.0f, 8.3f, 4.0f, 8.83f)
                verticalLineTo(20.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(12.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(4.0f)
                curveTo(20.0f, 2.9f, 19.1f, 2.0f, 18.0f, 2.0f)
                close()
                moveTo(11.65f, 16.65f)
                lineToRelative(-2.79f, -2.79f)
                curveTo(8.54f, 13.54f, 8.76f, 13.0f, 9.21f, 13.0f)
                horizontalLineTo(11.0f)
                verticalLineToRelative(-2.99f)
                curveToRelative(0.0f, -0.55f, 0.44f, -0.99f, 0.99f, -1.0f)
                horizontalLineToRelative(0.0f)
                curveTo(12.55f, 9.0f, 13.0f, 9.45f, 13.0f, 10.01f)
                verticalLineTo(13.0f)
                horizontalLineToRelative(1.79f)
                curveToRelative(0.45f, 0.0f, 0.67f, 0.54f, 0.35f, 0.85f)
                lineToRelative(-2.79f, 2.79f)
                curveTo(12.16f, 16.84f, 11.84f, 16.84f, 11.65f, 16.65f)
                close()
            }
        }
        return _simCardDownload!!
    }

private var _simCardDownload: ImageVector? = null
