/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.UnfoldLessDouble: ImageVector
    get() {
        if (_unfoldLessDouble != null) {
            return _unfoldLessDouble!!
        }
        _unfoldLessDouble = materialIcon(name = "Rounded.UnfoldLessDouble") {
            materialPath {
                moveTo(14.46f, 5.7f)
                lineToRelative(-2.47f, 2.46f)
                lineTo(9.53f, 5.7f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                reflectiveCurveToRelative(-0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(3.17f, 3.18f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(3.17f, -3.18f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                reflectiveCurveTo(14.85f, 5.31f, 14.46f, 5.7f)
                close()
            }
            materialPath {
                moveTo(14.46f, 0.7f)
                lineToRelative(-2.47f, 2.46f)
                lineTo(9.53f, 0.7f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                reflectiveCurveToRelative(-0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(3.17f, 3.18f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(3.17f, -3.18f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                reflectiveCurveTo(14.85f, 0.31f, 14.46f, 0.7f)
                close()
            }
            materialPath {
                moveTo(9.54f, 23.3f)
                lineToRelative(2.47f, -2.46f)
                lineToRelative(2.46f, 2.46f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineToRelative(-3.17f, -3.18f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineToRelative(-3.17f, 3.18f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                curveTo(8.52f, 23.69f, 9.15f, 23.69f, 9.54f, 23.3f)
                close()
            }
            materialPath {
                moveTo(9.54f, 18.29f)
                lineToRelative(2.47f, -2.45f)
                lineToRelative(2.46f, 2.46f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineToRelative(-3.17f, -3.18f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineToRelative(-3.17f, 3.17f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                reflectiveCurveTo(9.15f, 18.68f, 9.54f, 18.29f)
                close()
            }
        }
        return _unfoldLessDouble!!
    }

private var _unfoldLessDouble: ImageVector? = null
