/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.AutoDelete: ImageVector
    get() {
        if (_autoDelete != null) {
            return _autoDelete!!
        }
        _autoDelete = materialIcon(name = "Sharp.AutoDelete") {
            materialPath {
                moveTo(15.0f, 2.0f)
                lineToRelative(-3.5f, 0.0f)
                lineToRelative(-1.0f, -1.0f)
                lineToRelative(-5.0f, 0.0f)
                lineToRelative(-1.0f, 1.0f)
                lineToRelative(-3.5f, 0.0f)
                lineToRelative(0.0f, 2.0f)
                lineToRelative(14.0f, 0.0f)
                close()
            }
            materialPath {
                moveTo(16.0f, 9.0f)
                curveToRelative(-0.7f, 0.0f, -1.37f, 0.1f, -2.0f, 0.29f)
                verticalLineTo(5.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(14.0f)
                horizontalLineToRelative(7.68f)
                curveToRelative(1.12f, 2.36f, 3.53f, 4.0f, 6.32f, 4.0f)
                curveToRelative(3.87f, 0.0f, 7.0f, -3.13f, 7.0f, -7.0f)
                curveTo(23.0f, 12.13f, 19.87f, 9.0f, 16.0f, 9.0f)
                close()
                moveTo(16.0f, 21.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, -2.24f, -5.0f, -5.0f)
                reflectiveCurveToRelative(2.24f, -5.0f, 5.0f, -5.0f)
                reflectiveCurveToRelative(5.0f, 2.24f, 5.0f, 5.0f)
                reflectiveCurveTo(18.76f, 21.0f, 16.0f, 21.0f)
                close()
            }
            materialPath {
                moveTo(16.5f, 12.0f)
                lineToRelative(-1.5f, 0.0f)
                lineToRelative(0.0f, 5.0f)
                lineToRelative(3.6f, 2.1f)
                lineToRelative(0.8f, -1.2f)
                lineToRelative(-2.9f, -1.7f)
                close()
            }
        }
        return _autoDelete!!
    }

private var _autoDelete: ImageVector? = null
