/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.EditLocationAlt: ImageVector
    get() {
        if (_editLocationAlt != null) {
            return _editLocationAlt!!
        }
        _editLocationAlt = materialIcon(name = "Sharp.EditLocationAlt") {
            materialPath {
                moveTo(13.95f, 13.0f)
                horizontalLineTo(9.0f)
                verticalLineTo(8.05f)
                lineToRelative(5.61f, -5.61f)
                curveTo(13.78f, 2.16f, 12.9f, 2.0f, 12.0f, 2.0f)
                curveToRelative(-4.2f, 0.0f, -8.0f, 3.22f, -8.0f, 8.2f)
                curveToRelative(0.0f, 3.32f, 2.67f, 7.25f, 8.0f, 11.8f)
                curveToRelative(5.33f, -4.55f, 8.0f, -8.48f, 8.0f, -11.8f)
                curveToRelative(0.0f, -1.01f, -0.16f, -1.94f, -0.45f, -2.8f)
                lineTo(13.95f, 13.0f)
                close()
                moveTo(11.0f, 11.0f)
                horizontalLineToRelative(2.12f)
                lineToRelative(6.16f, -6.16f)
                lineToRelative(-2.12f, -2.12f)
                lineTo(11.0f, 8.88f)
                verticalLineTo(11.0f)
                close()
                moveTo(19.29f, 0.59f)
                lineToRelative(-1.42f, 1.42f)
                lineToRelative(2.12f, 2.12f)
                lineToRelative(1.42f, -1.42f)
                lineTo(19.29f, 0.59f)
                close()
            }
        }
        return _editLocationAlt!!
    }

private var _editLocationAlt: ImageVector? = null
