/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.PanoramaVerticalSelect: ImageVector
    get() {
        if (_panoramaVerticalSelect != null) {
            return _panoramaVerticalSelect!!
        }
        _panoramaVerticalSelect = materialIcon(name = "Sharp.PanoramaVerticalSelect") {
            materialPath {
                moveTo(18.49f, 11.99f)
                curveToRelative(0.0f, -5.25f, 1.54f, -9.01f, 1.92f, -10.0f)
                lineToRelative(-16.82f, 0.0f)
                curveToRelative(0.76f, 2.16f, 1.9f, 5.21f, 1.9f, 10.0f)
                curveToRelative(0.0f, 4.78f, -1.17f, 7.91f, -1.9f, 10.0f)
                lineToRelative(16.81f, 0.0f)
                curveTo(19.66f, 19.91f, 18.49f, 16.76f, 18.49f, 11.99f)
                close()
            }
        }
        return _panoramaVerticalSelect!!
    }

private var _panoramaVerticalSelect: ImageVector? = null
