/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.SavedSearch: ImageVector
    get() {
        if (_savedSearch != null) {
            return _savedSearch!!
        }
        _savedSearch = materialIcon(name = "TwoTone.SavedSearch") {
            materialPath {
                moveTo(14.73f, 13.31f)
                curveTo(15.52f, 12.24f, 16.0f, 10.93f, 16.0f, 9.5f)
                curveTo(16.0f, 5.91f, 13.09f, 3.0f, 9.5f, 3.0f)
                reflectiveCurveTo(3.0f, 5.91f, 3.0f, 9.5f)
                curveTo(3.0f, 13.09f, 5.91f, 16.0f, 9.5f, 16.0f)
                curveToRelative(1.43f, 0.0f, 2.74f, -0.48f, 3.81f, -1.27f)
                lineTo(19.59f, 21.0f)
                lineTo(21.0f, 19.59f)
                lineTo(14.73f, 13.31f)
                close()
                moveTo(9.5f, 14.0f)
                curveTo(7.01f, 14.0f, 5.0f, 11.99f, 5.0f, 9.5f)
                reflectiveCurveTo(7.01f, 5.0f, 9.5f, 5.0f)
                reflectiveCurveTo(14.0f, 7.01f, 14.0f, 9.5f)
                reflectiveCurveTo(11.99f, 14.0f, 9.5f, 14.0f)
                close()
            }
            materialPath {
                moveTo(9.5f, 6.0f)
                lineToRelative(-0.79f, 2.44f)
                lineToRelative(-2.46f, 0.0f)
                lineToRelative(2.01f, 1.59f)
                lineToRelative(-0.77f, 2.47f)
                lineToRelative(2.01f, -1.53f)
                lineToRelative(2.01f, 1.53f)
                lineToRelative(-0.77f, -2.47f)
                lineToRelative(2.01f, -1.59f)
                lineToRelative(-2.46f, 0.0f)
                close()
            }
        }
        return _savedSearch!!
    }

private var _savedSearch: ImageVector? = null
